// system_iopll_0.v

// Generated using ACDS version 25.1 129

`timescale 1 ps / 1 ps
module system_iopll_0 (
		input  wire  refclk,   //  refclk.clk,    The reference clock source that drives the I/O PLL.
		output wire  locked,   //  locked.export, The IOPLL IP core drives this port high when the PLL acquires lock. The port remains high as long as the I/O PLL is locked. The I/O PLL asserts the locked port when the phases and frequencies of the reference clock and feedback clock are the same or within the lock circuit tolerance. When the difference between the two clock signals exceeds the lock circuit tolerance, the I/O PLL loses lock.
		input  wire  rst,      //   reset.reset,  The asynchronous reset port for the output clocks. Drive this port high to reset all output clocks to the value of 0.
		output wire  outclk_0, // outclk0.clk,    Output clock Channel 0 from I/O PLL.
		output wire  outclk_1, // outclk1.clk,    Output clock Channel 1 from I/O PLL.
		output wire  outclk_2, // outclk2.clk,    Output clock Channel 2 from I/O PLL.
		output wire  outclk_3, // outclk3.clk,    Output clock Channel 3 from I/O PLL.
		output wire  outclk_4, // outclk4.clk,    Output clock Channel 4 from I/O PLL.
		output wire  outclk_5  // outclk5.clk,    Output clock Channel 5 from I/O PLL.
	);

	system_iopll_0_altera_iopll_2000_ytycs6q iopll_sys (
		.refclk   (refclk),   //   input,  width = 1,  refclk.clk
		.locked   (locked),   //  output,  width = 1,  locked.export
		.rst      (rst),      //   input,  width = 1,   reset.reset
		.outclk_0 (outclk_0), //  output,  width = 1, outclk0.clk
		.outclk_1 (outclk_1), //  output,  width = 1, outclk1.clk
		.outclk_2 (outclk_2), //  output,  width = 1, outclk2.clk
		.outclk_3 (outclk_3), //  output,  width = 1, outclk3.clk
		.outclk_4 (outclk_4), //  output,  width = 1, outclk4.clk
		.outclk_5 (outclk_5)  //  output,  width = 1, outclk5.clk
	);

endmodule
