// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



module dphy_timer #(
        parameter WIDTH = 8
   ) 
   (
        input  wire                     clk,     
        input  wire                     srst_n,     
        
        input                           timer_en, 
        input                           ld_timer,   
        input [WIDTH-1:0]               ld_val, 
        output logic                    timer_out           

    );
    
    logic [WIDTH-1:0] cntr;
    logic [WIDTH-1:0] e_cntr;
    logic e_timeout;

    always @(posedge clk)
    begin
        if(srst_n == 1'b0)
            cntr <= {WIDTH{1'b1}};
        else if(ld_timer)
            cntr <= ld_val;
        else if(~&cntr)
            cntr <= e_cntr;
    end
    assign e_cntr = cntr - timer_en;
    assign timer_out = ~|cntr & ~ld_timer & timer_en;



endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "9QgWcS4BAPM0ijhGxFMUlbGjnPppWaR0YyNAdZWTcmGrECrj4gvxvXQLdWaGUWx1flqhiB7hZArgo45zOL12QZTa//IH6WALqExWaaTGOBBf3xIcRMaO8DBqZIhy1HLpRPRmEOcNzcGmRGq+Q3v81HBA2YRjjmIypoU3QErFIzyIuSAHPdWq24/2dMSQPgP5vJP9/EepkjUbBBUcTbQYowR9S9a6LFSGsn1aoUnfU0MMYkYLjPYPC0pghG8EmUFUV7BBhXUsRccQLXQPIVIF/lSSsNU7Y3f+qBbApXFj2zvztLftz9SqdkcAGg4gGm9AOS1+hC7Cc8MH1h2/AH56CZol19f1sL1CJIjo7CeBqfeGrmyzHor3dTLh5c3w4x4A+ZtIoA0Jk8I85gpJp/+Iuexq6BnNovOiEl5d/RcdGDxznceHmNp6iDwX12G0mkhIQLQnLZLeD14mE52R7J97+731t3e5AWp9ZlICabT++gUWRsk1mmOCttInpDm8DhuN0GjuFJPvX38wpYpGMNojV3sz7+MKrIv62kJu+WwaOb4Rvr9YXT0Qdt1V9Pziwr9pFzVbbWFLwSQDBfRMA3Ca17BTEGYlXHm32glcwlvhoMPhr/hjU97wQOjTEdyozCO71wNzZ49tpwAS9QJSgrhcEyNWqqEvprHXTQfrwrW5S6oDSucEFcXWG2nfhrINzVvhzUdHmsmEGws6lAGlvXMlBq7VDw8XVdVwVdqaESNvWSM9Ru9JAgRqY4g6Ow2CQtDQfKYwfoM6A1xBjilyzc19UdKaAmM6tdpBkZiQkP9wDv2nBn8Si8UPNRY0HuH7jd/9Vz7xaxiyZOfgDRIzmQWBG1K1w5ISCHqwKQmTTRJ8vnbOz5p+vXP14D8wN9zLnvTT3QGP8IPQTik6Jlw+5IKX4eznnk/Jxkw0gw9BgBkMJHmbnxvJpwDwZlafpNLdU0JnY+ixJcLC/XdtHi7qSdJ0PItqoL7kVjxxkjoMDEDLo2wVjsozthrqD6w1jsR/No2g"
`endif