// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



import dphy_pkg::*;


module dphy_pcs_data_timing_rx # (
        parameter DIN_PIPE_DEPTH = 2
   ) (
        input wire   rx_clk, 
        input wire   srst_rx_n,
        input wire   arst_rx_n, 
        input wire   fr_clk,
        input wire   srst_fr_n, 
        input wire   fr_clk_1024,
        input wire   enable,
        input wire   is_ulps,
        input wire   ulps_wake_cnt, 
        
        input wire   lpctrl_hs_req_fr,
        input wire   lpctrl_hs_stop_fr,
        input wire   lpctrl_hs_diff_fr,
        input wire   lpctrl_lp_req_fr,
        input wire   fast_stop,

        input [7:0]  t_hs_settle, 
        input [7:0]  t_hs_skip, 
        input [7:0]  t_init,
        input [7:0]  t_wake_ulps,

        output logic ulps_wake_done,
        output logic init_done,
        output logic din_valid           

    );
    
    localparam FR_TIMER_WIDTH = 16;
    localparam DIN_VALID_PIPE_LEN = DIN_PIPE_DEPTH > 2 ? DIN_PIPE_DEPTH - 2 : 0;
    
   logic             fr_ld_timer;   
   logic [FR_TIMER_WIDTH-1:0] fr_ld_val; 
   logic                      fr_timer_out;
   
   logic                      din_valid_fr;
   logic                      din_valid_rx;
   logic                      din_valid_int;
   logic                      fast_stop_rx;
   logic                      enable_q;


   
   
   assign ulps_wake_done = is_ulps & fr_timer_out;
    
    always @(posedge fr_clk)
    begin
        if(srst_fr_n == 1'b0)
        begin
                din_valid_fr <= 1'b0;
                init_done <= 1'b0;
                enable_q <= 1'b0;
        end
        else 
        begin
            din_valid_fr <= (init_done & fr_timer_out) | (din_valid_fr & lpctrl_hs_diff_fr);
            init_done <= ( init_done & ( enable === 1'b1) )  | (fr_timer_out === 1'b1);
            enable_q <= enable;
        end
    end

    assign fr_timer_en = (init_done == 1'b0) || (ulps_wake_cnt == 1'b1) ? fr_clk_1024 : lpctrl_hs_diff_fr;
    assign fr_ld_timer = init_done == 1'b1 ? ( is_ulps == 1'b1 ? ~ulps_wake_cnt : lpctrl_hs_req_fr ) : lpctrl_hs_stop_fr === 1'b1 && enable_q === 1'b1 ? 1'b0 : 1'b1;
    assign fr_ld_val = init_done == 1'b1 ? (is_ulps == 1'b1 ? { 8'h0, t_wake_ulps } : { 8'h0, t_hs_settle }) : { 8'h0, t_init }  ;

    dphy_timer #(
        .WIDTH(FR_TIMER_WIDTH)
   ) rx_timer_fr
   (
        .clk(fr_clk),     
        .srst_n(srst_fr_n),     
        .timer_en(fr_timer_en), 
        .ld_timer(fr_ld_timer),   
        .ld_val(fr_ld_val), 
        .timer_out(fr_timer_out)   
    );

    altera_std_synchronizer_nocut # (
        .depth(3)
    ) cdc_sync_din_valid (
        .clk(rx_clk),
        .reset_n(arst_rx_n),
        .din(din_valid_fr),
        .dout(din_valid_rx)
    );

    altera_std_synchronizer_nocut # (
        .depth(3)
    ) cdc_sync_fast_stop (
        .clk(rx_clk),
        .reset_n(arst_rx_n),
        .din(fast_stop),
        .dout(fast_stop_rx)
    );

    assign din_valid_int = din_valid_rx & ~fast_stop_rx;
    hyperpipe # (.WIDTH(1), .CYCLES(DIN_VALID_PIPE_LEN)) din_valid_pipe (.clk(rx_clk), .din(din_valid_int), .dout(din_valid) );

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "EFp3MeAJX/lIDaqlP2bXklYrJ9H4kLxD18of/nu1/yvzD8WAeCSdgm842C29sY+u4jKW4cJhiBbRNxkoZOsJXr0Nl0UlJ2vNeyvx1FnvcIQJ1IOHvsnSV/sCIxLCk2lhGEl8PhdNJMALVPIbEBiGREMWXAMa9WmHpxw3xSZIzUU2Gt9VPV5HnzUgXy8dXsXSELTll6nsjuaaMkUcqpbujl9iNlYf5Wk78osDP8IQggRnV5QIgU5/bzfLu/0kYde0lmUhToPd+OcUbKeSBHKawyd/+WC6Cg2daH3Wg0a6KRUYV2+HhKE8d63/1nEPn/2A0Hp4qLXh2cqUcHZqJW5kG+QJXGNtpaHgZs0BPAXu2jtl83rl8WcApdQqxbQ1oJdZpkLlOrIngBa921zbHFbTF4emnJSqAqQR9d2a75ED7DDHQCSxhw1h55pGN+jE/JxJvO+/sqcMTUyzbhukhpc+e6nEwlGo+B+1W5eEdyp5iHw8x+xneAlHfTetWAa2VjPEOj1TWD2ziVX9JXd/9lZ6CV8+EunbA3RTlQJZR4X6z5aD854nz3TSUFoe8EvwiLDzk4W5ROEtP7n+jtQRcbaiU2e4v137RtM5/8S27mnNW0Apz/7xaxdo8hMwyaMGNhZQWWZAFI/EeYvrW09mWePc0jPIKtPn96JRncnhimZgrcRL6YuuXqYnhN3+pwXejyPfRiNGezOW9upPdRRuRBQNoPRsvOq1yu38WMpSubgXU9Gu2LR7SaPLj61WaLeulN7gengVu8Mp0zlM0+kjKmo1Ng0iyVRDEFUA4Yw7FYSQCx5dTcks50AWAgJD08gJVR1oXQv5WNpI9TNNoVSQW11qibSkjx5HDG7cKry1m3k4mAvD5GgYkZDQnMCw2uZ2nWMy+c9MwFV/Q2ICDxtZ/9omDHEkNhdDRpq71snFqYDapepqAwE1/rVuHDp/MuWyEV7HeB3CH2lOcfSnlQX+H3PRAmDDad5zP8kJkXU1SsnjGQLYHoa/eRUcCx/aHrmhDH2v"
`endif