// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.





// synthesis translate_off   

`ifdef DPHY_BHV_SIM
`define BHV_CPA 1
`endif

`ifdef BHV_CPA
`define cpa_name dphy_cpa_bhv
`endif

`define SIM 1

// synthesis translate_on

`ifndef cpa_name
`define cpa_name tennm_clkgen
`endif

module dphy_cpa_wrap #(
    parameter CPA_ID = 0,
    parameter PHY_CLK_DIV = 1,
    parameter VCO_CLK_DIV_EXPONENT = 2,
    parameter VCO_CLK_FREQ = 36'h00000000
) ( 
    input  wire            i_core_clk_in,                  
    input  wire            i_phyclk,                       
    input  wire            i_phyclk_sync,                  
    output logic           o_core_clk_out,                 
    input  wire  [7:0]     i_vco8ph,                       
    output logic           o_lock,                         
    input  wire            i_pll_lock                      
);

localparam PROTOCOL_MODE = 1'b0
// synthesis translate_off
                           | 1'b1
// synthesis translate_on
                           ? "PROTOCOL_MODE_NON_EMIF"
                           : "PROTOCOL_MODE_EMIF";

   
    `cpa_name #(
        .base_address( (16'h3<<8) | (16'h1a<<1) | CPA_ID ),
        .feedback_dly_sel( "FEEDBACK_DLY_SEL_DLY_PHY" ),
        .feedback_dly_steps( 7'h00 ),
        .phy_clk_div( PHY_CLK_DIV ),
        .protocol_mode( PROTOCOL_MODE ),
        .vco_clk_div_exponent( VCO_CLK_DIV_EXPONENT ),
        .vco_clk_div_mantissa( 5'h00 ),
        .vco_clk_freq( VCO_CLK_FREQ )
    ) cpa_inst (
        .i_core_clk_in( i_core_clk_in ),                              
        .i_phyclk( i_phyclk ),                                        
        .i_phyclk_sync( i_phyclk_sync ),                              
        .o_core_clk_out( o_core_clk_out ),                            
        .i_vco8ph( i_vco8ph ),                                        
        .o_lock( o_lock ),                                            
        .i_avl_clk(),                                                 
        .i_avl_rst_n(),                                               
        .i_avl_write(),                                               
        .i_avl_read(),                                                
        .i_avl_address(),                                             
        .i_avl_writedata(),                                           
        .o_avl_readdata(  ),                                          
        .i_pll_lock( i_pll_lock )                                     
    );
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "9QgWcS4BAPM0ijhGxFMUlbGjnPppWaR0YyNAdZWTcmGrECrj4gvxvXQLdWaGUWx1flqhiB7hZArgo45zOL12QZTa//IH6WALqExWaaTGOBBf3xIcRMaO8DBqZIhy1HLpRPRmEOcNzcGmRGq+Q3v81HBA2YRjjmIypoU3QErFIzyIuSAHPdWq24/2dMSQPgP5vJP9/EepkjUbBBUcTbQYowR9S9a6LFSGsn1aoUnfU0NDd8ViqODJUFyO8t1dzf5hiIIo8QdgZpC3Fo25L2jL6/bZto8jvABrLZVkXh6UPGVNyJI3yhX7YAAuQd2FZlqx3aDa/zX5kqc0y46Ooci8et4s7VFsW/iY1RKTRLi3Pd8L7FAmKrSUfK2O4Vb1BzExuAWEd/cizPhS4JfQT3zzgUxKChm6UnoDuc7uyIEKuAbnNuhPsLxnGANwJk8bc4Gnumq5IhWleB19+VSAcd9zl+tTTyJCU0uUs1BPu5JoRJKY3Y+8YtwDEdpDc6fi0Q8yT3TfdupdIQZoqM+GUW5lI0hNMDtQG4R9/tw/6kgtDyGw6e4D3Lf3/t5F70DL4OmG9CBhRTJ7JqQyzsD/IgNIuxvG/qI00zCGifbjuJh/h5ZkOkTQGL3NGdplHeLKZvamFYLYTQpnqjOG88+g800yCTSqqLBOUR5kW0RdK8453NeQqWAw09jKkvE2sw04PAHY7QarsMNXqDfJKp2YBuKIwGOgLpUCjJegVGgXtv5IazbiNFoY6VC9pznYmDvJGKCVjfCzRouI08UnlGnas9cqQwHoOxwSCdheAJriyfb0XTyH9jvlUC6wbHdTbSbg85eco7K5hgRoAoTPvVgDZOIxjIqmjvwlhbkZk75M+AEgKlu+kcS6hOGM/GBmZZ8xuCSPn2iPEIu0Glsfy5VJFJ6/8olCGPaLk4mk6VoLi1rIi+olbND+jIuiTT5ojgS5X/n2aP11Jw1xrobddQLhSFm6q1MDG05hvUyx4Ju3TsMhGhFMb9ax2bNLQKFVDa8bMEsl"
`endif