// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.





`timescale 1ns / 1ns

module altera_std_synchronizer_nocut (
                                clk, 
                                reset_n, 
                                din, 
                                dout
                                );

   parameter depth = 3; 
   parameter rst_value = 0;     
     
   input   clk;
   input   reset_n;    
   input   din;
   output  dout;
   

   (* altera_attribute = {"-name ADV_NETLIST_OPT_ALLOWED NEVER_ALLOW; -name SYNCHRONIZER_IDENTIFICATION FORCED; -name DONT_MERGE_REGISTER ON; -name PRESERVE_REGISTER ON  "} *) reg din_s1;

   (* altera_attribute = {"-name ADV_NETLIST_OPT_ALLOWED NEVER_ALLOW; -name DONT_MERGE_REGISTER ON; -name PRESERVE_REGISTER ON"} *) reg [depth-2:0] dreg;    
   
   // synthesis translate_off
   `ifndef QUARTUS_CDC
   initial begin
      if (depth <2) begin
         $display("%m: Error: synchronizer length: %0d less than 2.", depth);
      end
   end
   `endif

   
`ifdef __ALTERA_STD__METASTABLE_SIM

   reg[31:0]  RANDOM_SEED = 123456;      
   wire  next_din_s1;
   wire  dout;
   reg   din_last;
   reg          random;
   event metastable_event; 

   
   always @(posedge clk) begin
      if (reset_n == 0)
        random <= $random(RANDOM_SEED);
      else
        random <= $random;
   end

   assign next_din_s1 = (din_last ^ din) ? random : din;   

   always @(posedge clk or negedge reset_n) begin
       if (reset_n == 0) 
         din_last <= (rst_value == 0)? 1'b0 : 1'b1;
       else
         din_last <= din;
   end

   always @(posedge clk or negedge reset_n) begin
       if (reset_n == 0) 
         din_s1 <= (rst_value == 0)? 1'b0 : 1'b1;
       else
         din_s1 <= next_din_s1;
   end
   
`else 

   // synthesis translate_on   
   generate if (rst_value == 0)
       always @(posedge clk or negedge reset_n) begin
           if (reset_n == 0) 
             din_s1 <= 1'b0;
           else
             din_s1 <= din;
       end
   endgenerate
   
   generate if (rst_value == 1)
       always @(posedge clk or negedge reset_n) begin
           if (reset_n == 0) 
             din_s1 <= 1'b1;
           else
             din_s1 <= din;
       end
   endgenerate
   // synthesis translate_off      

`endif

`ifdef __ALTERA_STD__METASTABLE_SIM_VERBOSE
   always @(*) begin
      if (reset_n && (din_last != din) && (random != din)) begin
         $display("%m: Verbose Info: metastable event @ time %t", $time);
         ->metastable_event;
      end
   end      
`endif

   // synthesis translate_on

   generate if (rst_value == 0)
      if (depth < 3) begin
         always @(posedge clk or negedge reset_n) begin
            if (reset_n == 0) 
              dreg <= {depth-1{1'b0}};            
            else
              dreg <= din_s1;
         end         
      end else begin
         always @(posedge clk or negedge reset_n) begin
            if (reset_n == 0) 
              dreg <= {depth-1{1'b0}};
            else
              dreg <= {dreg[depth-3:0], din_s1};
         end
      end
   endgenerate
   
   generate if (rst_value == 1)
      if (depth < 3) begin
         always @(posedge clk or negedge reset_n) begin
            if (reset_n == 0) 
              dreg <= {depth-1{1'b1}};            
            else
              dreg <= din_s1;
         end         
      end else begin
         always @(posedge clk or negedge reset_n) begin
            if (reset_n == 0) 
              dreg <= {depth-1{1'b1}};
            else
              dreg <= {dreg[depth-3:0], din_s1};
         end
      end
   endgenerate

   assign dout = dreg[depth-2];
   
endmodule 


                        
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "EFp3MeAJX/lIDaqlP2bXklYrJ9H4kLxD18of/nu1/yvzD8WAeCSdgm842C29sY+u4jKW4cJhiBbRNxkoZOsJXr0Nl0UlJ2vNeyvx1FnvcIQJ1IOHvsnSV/sCIxLCk2lhGEl8PhdNJMALVPIbEBiGREMWXAMa9WmHpxw3xSZIzUU2Gt9VPV5HnzUgXy8dXsXSELTll6nsjuaaMkUcqpbujl9iNlYf5Wk78osDP8IQggThmGtLd+xzwjr3+ve3B9ac/joX2EH9yqH/FGAbO+hxRJJa76VZQBvKGiBqK9vF5VZ5op+qsPx+mnjjlcyu27cwtqxiRKnPytp3gKCmK3HL6VuCYeaVfA/++PhVjxH4egdIG+Iij3pffKfAonJYX8rd00U17q8yfc35/L4MoY18881MGglHftJ7Jk4FUCNK5l6IXjsHgh7QiFkCeXRuH5nNHxRs5HFphmEvr2TtnShv1ymn+itkbmbZQth3gPi2K1lHmGUxzkVkyhVM+mb3+2gnojnbF2+sKKtIiwHXCIBqVIW8wKTXV8t2Z5IbE1WWe365dI7qV2KnFB2eLYXXIIMJxaB/RqNMeH1edPQtOpRlvf4MotD6OxzbijrUlaUcRe7XyjhkkFJMC5pGeoK06mSIyGopmu6emcVy2S2G13hO2SxX5qM/8SN+qeAhTTMosR38/udbJ6lizVHpJrJ+H8od2RwzEqMG1JsNir4vv8fkHS0bbdD991D/99kqXmmMJQ6kNgOnhtEmTzkA9GZ0Ze6V2xxwbe+CWzCQtyqoG4UECOtRzpI73u2n2Lpcakn9I45Ekw3A9mqb053ssKX0p9FC+I33UMXhSaiPp51vL9MD08yBfo/uocB1oZXlULN0Gppraj/LqX2YzuiNCaSLQN7Ai3RwyJh+7aVjgmM3uAFU/zMq73l/BzjvxRL6JXYseBQ1wwhsP+i9PsrQZy8FZjEANKgGWSNt9pVebLTw7RjnXOOQsMjH0PhtRxTzF/b/hdjNCfrzdyMovMpGsY7WTFR7"
`endif