// ============================================================================
// Copyright (c) 2024 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Thu Oct 17 16:46:16 2024
// ============================================================================

//`define ENABLE_LPDDR4A
//`define ENABLE_LPDDR4B
//`define ENABLE_LPDDR4C
//`define ENABLE_HPS
//`define ENABLE_HDMI
//`define ENABLE_ENET
//`define ENABLE_FMCP
//`define ENABLE_PCIE
//`define ENABLE_QSFP
`define ENABLE_CAM1
//`define ENABLE_CAM2
//`define ENABLE_GTSR4C

module golden_top(

      ///////// CLOCK /////////
      input              CLK_100_B2A_p,
      input              CLK_50_B5B,
      input              CLK_50_B6A,
      input              CLK_50_B6C,

      ///////// Buttons /////////
      input              BUTTON, //BUTTON is Low-Active
      input              USER_BUTTON, //USER_BUTTON is Low-Active

      ///////// Swtiches /////////
      input    [ 1: 0]   USER_SW,

      ///////// LED /////////
      output             LED, //LED is Low-Active
      output             USER_LED, //USER_LED is Low-Active

      ///////// SD Card /////////
      inout              SD_MMC_SEL,

`ifdef ENABLE_LPDDR4A
      ///////// LPDDR4A /////////
      input              LPDDR4A_REFCLK_p,
      output             LPDDR4A_CS_n,
      output   [ 5: 0]   LPDDR4A_CA,
      output             LPDDR4A_CK,
      output             LPDDR4A_CKE,
      output             LPDDR4A_CK_n,
      inout    [ 3: 0]   LPDDR4A_DM,
      inout    [31: 0]   LPDDR4A_DQ,
      inout    [ 3: 0]   LPDDR4A_DQS,
      inout    [ 3: 0]   LPDDR4A_DQS_n,
      output             LPDDR4A_RESET_n,
      input              LPDDR4A_RZQ,
`endif /*ENABLE_LPDDR4A*/

`ifdef ENABLE_LPDDR4B
      ///////// LPDDR4B /////////
      input              LPDDR4B_REFCLK_p,
      output             LPDDR4B_CS_n,
      output   [ 5: 0]   LPDDR4B_CA,
      output             LPDDR4B_CK,
      output             LPDDR4B_CKE,
      output             LPDDR4B_CK_n,
      inout    [ 3: 0]   LPDDR4B_DM,
      inout    [31: 0]   LPDDR4B_DQ,
      inout    [ 3: 0]   LPDDR4B_DQS,
      inout    [ 3: 0]   LPDDR4B_DQS_n,
      output             LPDDR4B_RESET_n,
      input              LPDDR4B_RZQ,
`endif /*ENABLE_LPDDR4B*/

`ifdef ENABLE_LPDDR4C
      ///////// LPDDR4C /////////
      input              LPDDR4C_REFCLK_p,
      output             LPDDR4C_CS_n,
      output   [ 5: 0]   LPDDR4C_CA,
      output             LPDDR4C_CK,
      output             LPDDR4C_CKE,
      output             LPDDR4C_CK_n,
      inout    [ 3: 0]   LPDDR4C_DM,
      inout    [31: 0]   LPDDR4C_DQ,
      inout    [ 3: 0]   LPDDR4C_DQS,
      inout    [ 3: 0]   LPDDR4C_DQS_n,
      output             LPDDR4C_RESET_n,
      input              LPDDR4C_RZQ,
`endif /*ENABLE_LPDDR4C*/

`ifdef ENABLE_HDMI
      ///////// HDMI /////////
      output             HDMI_TX_CLK_p,
      output             HDMI_TX_CLK_n,
      output   [ 2: 0]   HDMI_TX_D_p,
      output   [ 2: 0]   HDMI_TX_D_n,
      input    [ 3: 0]   HDMI_RX_D_p,
      input    [ 3: 0]   HDMI_RX_D_n,
      input              HDMI_REFCLK_148M5_p, //GTSR4A_REFCLK_148M5_p
      input              HDMI_RX_CLK_p,
      inout              HDMI_TX_CSCL,
      inout              HDMI_TX_CSDA,
      input              HDMI_TX_CEC_IN_n,
      output             HDMI_TX_CEC_OUT_n,
      input              HDMI_TX_HPD_n,
      inout              HDMI_TX_IN_SCL,
      inout              HDMI_TX_IN_SDA,
      output             HDMI_TX_PD,
      input              HDMI_RX_5V_SENSE,
      input              HDMI_RX_CEC_IN_n,
      output             HDMI_RX_CEC_OUT_n,
      inout              HDMI_RX_CON_SCL,
      inout              HDMI_RX_CON_SDA,
      output             HDMI_RX_EN,
      inout              HDMI_RX_SCL,
      inout              HDMI_RX_SDA,
`endif /*ENABLE_HDMI*/

`ifdef ENABLE_ENET
      ///////// ENET /////////
      output             ENET_88E2110_TX_p,
      output             ENET_88E2110_TX_n,
      input              ENET_88E2110_RX_p,
      input              ENET_88E2110_RX_n,
      input              ENET_88E2110_REFCLK_125M_p, //GTSL1C_REFCLK_125M_p
      input              ENET_88E2110_INT_n,
      output             ENET_88E2110_MDC,
      inout              ENET_88E2110_MDIO,
      output             ENET_88E2110_RESET_n,
`endif /*ENABLE_ENET*/

      ///////// SI5332B /////////
      inout              SI5332B_I2C_SCL,
      inout              SI5332B_I2C_SDA,

      ///////// SI5340B /////////
      inout              SI5340B_I2C_SCL,
      inout              SI5340B_I2C_SDA,
      output             SI5340B_OE_n,
      output             SI5340B_RST_n,

      ///////// GPIO /////////
      inout    [35: 0]   GPIO,

`ifdef ENABLE_FMCP
      ///////// FMCP /////////
      output   [ 7: 0]   FMCP_DP_C2M_p,
      output   [ 7: 0]   FMCP_DP_C2M_n,
      input    [ 7: 0]   FMCP_DP_M2C_p,
      input    [ 7: 0]   FMCP_DP_M2C_n,
      inout              FMCP_HA_p0,
      inout              FMCP_HA_n0,
      inout              FMCP_HA_n1,
      inout    [33: 0]   FMCP_LA_p,
      inout    [33: 0]   FMCP_LA_n,
      input              FMCP_CLK_M2C_p0,
      input    [ 1: 0]   FMCP_GBTCLK_M2C_p,
      input    [ 1: 0]   FMCP_REFCLK_p, //GTSL1A_REFCLK_100M_p, GTSL1B_REFCLK_156M25_p
      inout    [ 1: 0]   FMCP_RES,
      inout              FMCP_SCL,
      inout              FMCP_SDA,
`endif /*ENABLE_FMCP*/

      ///////// SMA /////////
      input              SMA_CLKIN_p,

`ifdef ENABLE_PCIE
      ///////// PCIE /////////
      inout              PCIE_SMBCLK,
      inout              PCIE_SMBDAT,
      output   [ 3: 0]   PCIE_TX_p,
      output   [ 3: 0]   PCIE_TX_n,
      input    [ 3: 0]   PCIE_RX_p,
      input    [ 3: 0]   PCIE_RX_n,
      input              PCIE_REFCLK_p,
      input              PCIE_PERST_n,
`endif /*ENABLE_PCIE*/

`ifdef ENABLE_QSFP
      ///////// QSFP /////////
      output   [ 3: 0]   QSFP_TX_p,
      output   [ 3: 0]   QSFP_TX_n,
      input    [ 3: 0]   QSFP_RX_p,
      input    [ 3: 0]   QSFP_RX_n,
      input              CIPRI_REFCLK_p, //GTSR4B_REFCLK_184M32_p
      input              QSFP_REFCLK_p, //GTSR4B_REFCLK_156M25_p
      input              QSFP_INTERRUPT_n,
      output             QSFP_LP_MODE,
      input              QSFP_MOD_PRS_n,
      output             QSFP_MOD_SEL_n,
      output             QSFP_RST_n,
      inout              QSFP_SCL,
      inout              QSFP_SDA,
`endif /*ENABLE_QSFP*/

      ///////// CAM /////////
      input              CAM_RZQ1, //RZQ_B_2A_T

`ifdef ENABLE_CAM1
      ///////// CAM1 /////////
      input              CAM1_CLK_p,
      input              CAM1_CLK_n,
//      input    [ 3: 0]   CAM1_D_p,
//      input    [ 3: 0]   CAM1_D_n,
      input    [ 1: 0]   CAM1_D_p,
      input    [ 1: 0]   CAM1_D_n,
      inout              CAM1_I2C_SCL,
      inout              CAM1_I2C_SDA,
      inout              CAM1_GPIO,
`endif /*ENABLE_CAM1*/

`ifdef ENABLE_CAM2
      ///////// CAM2 /////////
      input              CAM2_CLK_p,
      input              CAM2_CLK_n,
      input    [ 3: 0]   CAM2_D_p,
      input    [ 3: 0]   CAM2_D_n,
      inout              CAM2_I2C_SCL,
      inout              CAM2_I2C_SDA,
      inout              CAM2_GPIO,
`endif /*ENABLE_CAM2*/

`ifdef ENABLE_GTSR4C
      ///////// GTSR4C /////////
      input              GTSR4C_REFCLK_100M_p,
`endif /*ENABLE_GTSR4C*/

`ifdef ENABLE_HPS
      ///////// HPS /////////
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      inout              HPS_IOA_10, //reserved for vendor test
      inout              HPS_IOA_11, //reserved for vendor test
      inout              HPS_IOA_12, //reserved for vendor test
      inout              HPS_IOA_5, //reserved for vendor test
      inout              HPS_IOA_6, //reserved for vendor test
      inout              HPS_IOA_9, //reserved for vendor test
      inout              HPS_IOB_10, //reserved for vendor test
      inout              HPS_IOB_11, //reserved for vendor test
      inout              HPS_IOB_12, //reserved for vendor test
      inout              HPS_IOB_9, //reserved for vendor test
      inout              HPS_KEY,
      inout    [ 1: 0]   HPS_LED,
      input              HPS_OSC_CLK,
      output             HPS_SDMMC_CLK,
      inout              HPS_SDMMC_CMD,
      inout    [ 3: 0]   HPS_SDMMC_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB3_REFCLK_100M_p, //GTSL1C_REFCLK_100M_p
      input              HPS_USB3_SS_RX_n,
      input              HPS_USB3_SS_RX_p,
      output             HPS_USB3_SS_TX_n,
      output             HPS_USB3_SS_TX_p,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_ID,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
      output             HPS_USB_VBUS_CTRL,
      input              HPS_USB_VBUS_DET,
      input              HPS_USB_VBUS_FLT_n,
`endif /*ENABLE_HPS*/

      ///////// INFO /////////
      output             INFO_SPI_SCLK,
      input              INFO_SPI_MISO,
      output             INFO_SPI_MOSI,
      output             INFO_SPI_CS_n,
		
		
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrSotHS,                  //                       csi2_rx_o_d0_ppi_rx_err.ErrSotHS
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrSotSyncHS,              //                                              .ErrSotSyncHS
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrEsc,                    //                                              .ErrEsc
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrSyncEsc,                //                                              .ErrSyncEsc
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrControl,                //                                              .ErrControl
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrContentionLP0,          //                                              .ErrContentionLP0
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrContentionLP1,          //                                              .ErrContentionLP1
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrSotHS,                  //                       csi2_rx_o_d1_ppi_rx_err.ErrSotHS
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrSotSyncHS,              //                                              .ErrSotSyncHS
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrEsc,                    //                                              .ErrEsc
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrSyncEsc,                //                                              .ErrSyncEsc
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrControl,                //                                              .ErrControl
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrContentionLP0,          //                                              .ErrContentionLP0
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrContentionLP1,          //                                              .ErrContentionLP1
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrSotHS,                  //                       csi2_rx_o_ck_ppi_rx_err.ErrSotHS
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrSotSyncHS,              //                                              .ErrSotSyncHS
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrEsc,                    //                                              .ErrEsc
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrSyncEsc,                //                                              .ErrSyncEsc
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrControl,                //                                              .ErrControl
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrContentionLP0,          //                                              .ErrContentionLP0
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrContentionLP1,          //                                              .ErrContentionLP1
		output wire [63:0] csi2_rx_video_streaming_interface_0_tdata,         //           csi2_rx_video_streaming_interface_0.tdata
		output wire        csi2_rx_video_streaming_interface_0_tvalid,        //                                              .tvalid
//		input  wire        csi2_rx_video_streaming_interface_0_tready,        //                                              .tready
		output wire        csi2_rx_video_streaming_interface_0_tlast,         //                                              .tlast
		output wire [7:0]  csi2_rx_video_streaming_interface_0_tuser,         //                                              .tuser
		input  wire        csi2_rx_avalon_mm_control_interface_write,         //           csi2_rx_avalon_mm_control_interface.write
		input  wire        csi2_rx_avalon_mm_control_interface_read,          //                                              .read
		input  wire [9:0]  csi2_rx_avalon_mm_control_interface_address,       //                                              .address
		input  wire [31:0] csi2_rx_avalon_mm_control_interface_writedata,     //                                              .writedata
		output wire [31:0] csi2_rx_avalon_mm_control_interface_readdata,      //                                              .readdata
		output wire        csi2_rx_avalon_mm_control_interface_readdatavalid, //                                              .readdatavalid
		output wire        csi2_rx_avalon_mm_control_interface_waitrequest,   //                                              .waitrequest
		input  wire [3:0]  csi2_rx_avalon_mm_control_interface_byteenable,    //                                              .byteenable
		output wire        csi2_rx_avalon_mm_control_interface_interrupt_irq, // csi2_rx_avalon_mm_control_interface_interrupt.irq
//		input  wire        mipi_dphy_rzq_rzq,                                 //                                 mipi_dphy_rzq.rzq
//		input  wire        mipi_dphy_ref_clk_0_clk,                           //                           mipi_dphy_ref_clk_0.clk
		output wire        mipi_dphy_LINK0_link_core_srst_reset_n,            //                mipi_dphy_LINK0_link_core_srst.reset_n
		output wire        mipi_dphy_LINK0_link_core_arst_reset_n,            //                mipi_dphy_LINK0_link_core_arst.reset_n
		input  wire [11:0] mipi_dphy_axi_lite_awaddr,                         //                            mipi_dphy_axi_lite.awaddr
		input  wire        mipi_dphy_axi_lite_awvalid,                        //                                              .awvalid
		output wire        mipi_dphy_axi_lite_awready,                        //                                              .awready
		input  wire [31:0] mipi_dphy_axi_lite_wdata,                          //                                              .wdata
		input  wire [3:0]  mipi_dphy_axi_lite_wstrb,                          //                                              .wstrb
		input  wire        mipi_dphy_axi_lite_wvalid,                         //                                              .wvalid
		output wire        mipi_dphy_axi_lite_wready,                         //                                              .wready
		output wire [1:0]  mipi_dphy_axi_lite_bresp,                          //                                              .bresp
		output wire        mipi_dphy_axi_lite_bvalid,                         //                                              .bvalid
		input  wire        mipi_dphy_axi_lite_bready,                         //                                              .bready
		input  wire [11:0] mipi_dphy_axi_lite_araddr,                         //                                              .araddr
		input  wire        mipi_dphy_axi_lite_arvalid,                        //                                              .arvalid
		output wire        mipi_dphy_axi_lite_arready,                        //                                              .arready
		output wire [31:0] mipi_dphy_axi_lite_rdata,                          //                                              .rdata
		output wire [1:0]  mipi_dphy_axi_lite_rresp,                          //                                              .rresp
		output wire        mipi_dphy_axi_lite_rvalid,                         //                                              .rvalid
		input  wire        mipi_dphy_axi_lite_rready,                         //                                              .rready
		input  wire [2:0]  mipi_dphy_axi_lite_arprot,                         //                                              .arprot
		input  wire [2:0]  mipi_dphy_axi_lite_awprot,                         //                                              .awprot
//		input  wire [1:0]  mipi_dphy_LINK0_dphy_io_dphy_link_dp,              //                       mipi_dphy_LINK0_dphy_io.dphy_link_dp
//		input  wire [1:0]  mipi_dphy_LINK0_dphy_io_dphy_link_dn,              //                                              .dphy_link_dn
//		input  wire        mipi_dphy_LINK0_dphy_io_dphy_link_cp,              //                                              .dphy_link_cp
//		input  wire        mipi_dphy_LINK0_dphy_io_dphy_link_cn,              //                                              .dphy_link_cn
		output wire        mipi_dphy_reg_bus_reg_wr_en_o,                     //                             mipi_dphy_reg_bus.reg_wr_en_o
		output wire        mipi_dphy_reg_bus_reg_rd_en_o,                     //                                              .reg_rd_en_o
		output wire [10:0] mipi_dphy_reg_bus_reg_raddr_o,                     //                                              .reg_raddr_o
		output wire [10:0] mipi_dphy_reg_bus_reg_waddr_o,                     //                                              .reg_waddr_o
		output wire [3:0]  mipi_dphy_reg_bus_reg_be_o,                        //                                              .reg_be_o
		output wire [31:0] mipi_dphy_reg_bus_reg_din_o,                       //                                              .reg_din_o
		input  wire [31:0] mipi_dphy_reg_bus_reg_dout_i                      //                                              .reg_dout_i
//		input  wire        rx_axi4s_clk_bridge_in_clk_clk                     //                    rx_axi4s_clk_bridge_in_clk.clk
		

);

//		wire        csi2_rx_o_d0_ppi_rx_err_ErrSotHS;                  //                       csi2_rx_o_d0_ppi_rx_err.ErrSotHS
//		wire        csi2_rx_o_d0_ppi_rx_err_ErrSotSyncHS;              //                                              .ErrSotSyncHS
//		wire        csi2_rx_o_d0_ppi_rx_err_ErrEsc;                    //                                              .ErrEsc
//		wire        csi2_rx_o_d0_ppi_rx_err_ErrSyncEsc;                //                                              .ErrSyncEsc
//		wire        csi2_rx_o_d0_ppi_rx_err_ErrControl;                //                                              .ErrControl
//		wire        csi2_rx_o_d0_ppi_rx_err_ErrContentionLP0;          //                                              .ErrContentionLP0
//		wire        csi2_rx_o_d0_ppi_rx_err_ErrContentionLP1;          //                                              .ErrContentionLP1
//		wire        csi2_rx_o_d1_ppi_rx_err_ErrSotHS;                  //                       csi2_rx_o_d1_ppi_rx_err.ErrSotHS
//		wire        csi2_rx_o_d1_ppi_rx_err_ErrSotSyncHS;              //                                              .ErrSotSyncHS
//		wire        csi2_rx_o_d1_ppi_rx_err_ErrEsc;                    //                                              .ErrEsc
//		wire        csi2_rx_o_d1_ppi_rx_err_ErrSyncEsc;                //                                              .ErrSyncEsc
//		wire        csi2_rx_o_d1_ppi_rx_err_ErrControl;                //                                              .ErrControl
//		wire        csi2_rx_o_d1_ppi_rx_err_ErrContentionLP0;          //                                              .ErrContentionLP0
//		wire        csi2_rx_o_d1_ppi_rx_err_ErrContentionLP1;          //                                              .ErrContentionLP1
//		wire        csi2_rx_o_ck_ppi_rx_err_ErrSotHS;                  //                       csi2_rx_o_ck_ppi_rx_err.ErrSotHS
//		wire        csi2_rx_o_ck_ppi_rx_err_ErrSotSyncHS;              //                                              .ErrSotSyncHS
//		wire        csi2_rx_o_ck_ppi_rx_err_ErrEsc;                    //                                              .ErrEsc
//		wire        csi2_rx_o_ck_ppi_rx_err_ErrSyncEsc;                //                                              .ErrSyncEsc
//		wire        csi2_rx_o_ck_ppi_rx_err_ErrControl;                //                                              .ErrControl
//		wire        csi2_rx_o_ck_ppi_rx_err_ErrContentionLP0;          //                                              .ErrContentionLP0
//		wire        csi2_rx_o_ck_ppi_rx_err_ErrContentionLP1;          //                                              .ErrContentionLP1
//		wire [63:0] csi2_rx_video_streaming_interface_0_tdata;         //           csi2_rx_video_streaming_interface_0.tdata
//		wire        csi2_rx_video_streaming_interface_0_tvalid;        //                                              .tvalid
//		wire        csi2_rx_video_streaming_interface_0_tready;        //                                              .tready
//		wire        csi2_rx_video_streaming_interface_0_tlast;         //                                              .tlast
//		wire [7:0]  csi2_rx_video_streaming_interface_0_tuser;         //                                              .tuser
//		wire        csi2_rx_avalon_mm_control_interface_write;         //           csi2_rx_avalon_mm_control_interface.write
//		wire        csi2_rx_avalon_mm_control_interface_read;          //                                              .read
//		wire [9:0]  csi2_rx_avalon_mm_control_interface_address;       //                                              .address
//		wire [31:0] csi2_rx_avalon_mm_control_interface_writedata;     //                                              .writedata
//		wire [31:0] csi2_rx_avalon_mm_control_interface_readdata;      //                                              .readdata
//		wire        csi2_rx_avalon_mm_control_interface_readdatavalid; //                                              .readdatavalid
//		wire        csi2_rx_avalon_mm_control_interface_waitrequest;   //                                              .waitrequest
//		wire [3:0]  csi2_rx_avalon_mm_control_interface_byteenable;    //                                              .byteenable
//		wire        csi2_rx_avalon_mm_control_interface_interrupt_irq; // csi2_rx_avalon_mm_control_interface_interrupt.irq
//		wire        mipi_dphy_rzq_rzq;                                 //                                 mipi_dphy_rzq.rzq
//		wire        mipi_dphy_ref_clk_0_clk;                           //                           mipi_dphy_ref_clk_0.clk
//		wire        mipi_dphy_LINK0_link_core_srst_reset_n;            //                mipi_dphy_LINK0_link_core_srst.reset_n
//		wire        mipi_dphy_LINK0_link_core_arst_reset_n;            //                mipi_dphy_LINK0_link_core_arst.reset_n
//		wire [11:0] mipi_dphy_axi_lite_awaddr;                         //                            mipi_dphy_axi_lite.awaddr
//		wire        mipi_dphy_axi_lite_awvalid;                        //                                              .awvalid
//		wire        mipi_dphy_axi_lite_awready;                        //                                              .awready
//		wire [31:0] mipi_dphy_axi_lite_wdata;                          //                                              .wdata
//		wire [3:0]  mipi_dphy_axi_lite_wstrb;                          //                                              .wstrb
//		wire        mipi_dphy_axi_lite_wvalid;                         //                                              .wvalid
//		wire        mipi_dphy_axi_lite_wready;                         //                                              .wready
//		wire [1:0]  mipi_dphy_axi_lite_bresp;                          //                                              .bresp
//		wire        mipi_dphy_axi_lite_bvalid;                         //                                              .bvalid
//		wire        mipi_dphy_axi_lite_bready;                         //                                              .bready
//		wire [11:0] mipi_dphy_axi_lite_araddr;                         //                                              .araddr
//		wire        mipi_dphy_axi_lite_arvalid;                        //                                              .arvalid
//		wire        mipi_dphy_axi_lite_arready;                        //                                              .arready
//		wire [31:0] mipi_dphy_axi_lite_rdata;                          //                                              .rdata
//		wire [1:0]  mipi_dphy_axi_lite_rresp;                          //                                              .rresp
//		wire        mipi_dphy_axi_lite_rvalid;                         //                                              .rvalid
//		wire        mipi_dphy_axi_lite_rready;                         //                                              .rready
//		wire [2:0]  mipi_dphy_axi_lite_arprot;                         //                                              .arprot
//		wire [2:0]  mipi_dphy_axi_lite_awprot;                         //                                              .awprot
//		//wire [1:0]  mipi_dphy_LINK0_dphy_io_dphy_link_dp,              //                       mipi_dphy_LINK0_dphy_io.dphy_link_dp
//		//wire [1:0]  mipi_dphy_LINK0_dphy_io_dphy_link_dn,              //                                              .dphy_link_dn
//		//wire        mipi_dphy_LINK0_dphy_io_dphy_link_cp,              //                                              .dphy_link_cp
//		//wire        mipi_dphy_LINK0_dphy_io_dphy_link_cn,              //                                              .dphy_link_cn
//		wire        mipi_dphy_reg_bus_reg_wr_en_o;                     //                             mipi_dphy_reg_bus.reg_wr_en_o
//		wire        mipi_dphy_reg_bus_reg_rd_en_o;                     //                                              .reg_rd_en_o
//		wire [10:0] mipi_dphy_reg_bus_reg_raddr_o;                     //                                              .reg_raddr_o
//		wire [10:0] mipi_dphy_reg_bus_reg_waddr_o;                     //                                              .reg_waddr_o
//		wire [3:0]  mipi_dphy_reg_bus_reg_be_o;                        //                                              .reg_be_o
//		wire [31:0] mipi_dphy_reg_bus_reg_din_o;                       //                                              .reg_din_o
//		wire [31:0] mipi_dphy_reg_bus_reg_dout_i;                      //                                              .reg_dout_i
//		wire        rx_axi4s_clk_bridge_in_clk_clk;                     //                    rx_axi4s_clk_bridge_in_clk.clk
		 


//=======================================================
//  REG/WIRE declarations
//=======================================================

//wire csi2_axi4_clock;
//wire mipi_dphy_ref_clk;


assign SI5340B_OE_n = 1'bZ;
assign SI5340B_RST_n = 1'bZ;



//=======================================================
//  Structural coding
//=======================================================

/////////////////////////
// Camera System: DPHY + CSI-2

wire mipi_dphy_ref_clk_0_clk;
wire rx_axi4s_clk_bridge_in_clk_clk;

////////////////////////
// reset

wire ninit_done;
wire sys_reset_n;
	reset_release reset_release_inst (
		.ninit_done (ninit_done)  //  output,  width = 1, ninit_done.ninit_done
	);
	
assign sys_reset_n = ~ninit_done;


////////////////////////
// system pll


//wire pll_locked;
//wire axi4_clk100;
//	system_pll system_pll_inst (
//		.refclk   (CLK_50_B5B),   //   input,  width = 1,  refclk.clk
//		.locked   (pll_locked),   //  output,  width = 1,  locked.export
//		.rst      (~ninit_done),      //   input,  width = 1,   reset.reset
//		.outclk_0 (axi4_clk100)  //  output,  width = 1, outclk0.clk
//	);
//	
//	
//assign sys_reset_n = ~ninit_done & pll_locked;		
//	
////////////////////////
// mipi csi2 qsys
	

//assign rx_axi4s_clk_bridge_in_clk_clk = axi4_clk100;

	wire axi4_clk;



	csi2_dphy_sys csi2_dphy_sys_cam (
		.reset_n_bridge_in_reset_reset_n                   (sys_reset_n),                   //   input,   width = 1,                       reset_n_bridge_in_reset.reset_n
		.rx_axi4s_clk_bridge_in_clk_clk                    (axi4_clk),                     //   input,   width = 1,                    rx_axi4s_clk_bridge_in_clk.clk
	
		// cSI2
		.csi2_rx_o_d0_ppi_rx_err_ErrSotHS                  (csi2_rx_o_d0_ppi_rx_err_ErrSotHS),                  //  output,   width = 1,                       csi2_rx_o_d0_ppi_rx_err.ErrSotHS
		.csi2_rx_o_d0_ppi_rx_err_ErrSotSyncHS              (csi2_rx_o_d0_ppi_rx_err_ErrSotSyncHS),              //  output,   width = 1,                                              .ErrSotSyncHS
		.csi2_rx_o_d0_ppi_rx_err_ErrEsc                    (csi2_rx_o_d0_ppi_rx_err_ErrEsc),                    //  output,   width = 1,                                              .ErrEsc
		.csi2_rx_o_d0_ppi_rx_err_ErrSyncEsc                (csi2_rx_o_d0_ppi_rx_err_ErrSyncEsc),                //  output,   width = 1,                                              .ErrSyncEsc
		.csi2_rx_o_d0_ppi_rx_err_ErrControl                (csi2_rx_o_d0_ppi_rx_err_ErrControl),                //  output,   width = 1,                                              .ErrControl
		.csi2_rx_o_d0_ppi_rx_err_ErrContentionLP0          (csi2_rx_o_d0_ppi_rx_err_ErrContentionLP0),          //  output,   width = 1,                                              .ErrContentionLP0
		.csi2_rx_o_d0_ppi_rx_err_ErrContentionLP1          (csi2_rx_o_d0_ppi_rx_err_ErrContentionLP1),          //  output,   width = 1,                                              .ErrContentionLP1
		.csi2_rx_o_d1_ppi_rx_err_ErrSotHS                  (csi2_rx_o_d1_ppi_rx_err_ErrSotHS),                  //  output,   width = 1,                       csi2_rx_o_d1_ppi_rx_err.ErrSotHS
		.csi2_rx_o_d1_ppi_rx_err_ErrSotSyncHS              (csi2_rx_o_d1_ppi_rx_err_ErrSotSyncHS),              //  output,   width = 1,                                              .ErrSotSyncHS
		.csi2_rx_o_d1_ppi_rx_err_ErrEsc                    (csi2_rx_o_d1_ppi_rx_err_ErrEsc),                    //  output,   width = 1,                                              .ErrEsc
		.csi2_rx_o_d1_ppi_rx_err_ErrSyncEsc                (csi2_rx_o_d1_ppi_rx_err_ErrSyncEsc),                //  output,   width = 1,                                              .ErrSyncEsc
		.csi2_rx_o_d1_ppi_rx_err_ErrControl                (csi2_rx_o_d1_ppi_rx_err_ErrControl),                //  output,   width = 1,                                              .ErrControl
		.csi2_rx_o_d1_ppi_rx_err_ErrContentionLP0          (csi2_rx_o_d1_ppi_rx_err_ErrContentionLP0),          //  output,   width = 1,                                              .ErrContentionLP0
		.csi2_rx_o_d1_ppi_rx_err_ErrContentionLP1          (csi2_rx_o_d1_ppi_rx_err_ErrContentionLP1),          //  output,   width = 1,                                              .ErrContentionLP1
		.csi2_rx_o_ck_ppi_rx_err_ErrSotHS                  (csi2_rx_o_ck_ppi_rx_err_ErrSotHS),                  //  output,   width = 1,                       csi2_rx_o_ck_ppi_rx_err.ErrSotHS
		.csi2_rx_o_ck_ppi_rx_err_ErrSotSyncHS              (csi2_rx_o_ck_ppi_rx_err_ErrSotSyncHS),              //  output,   width = 1,                                              .ErrSotSyncHS
		.csi2_rx_o_ck_ppi_rx_err_ErrEsc                    (csi2_rx_o_ck_ppi_rx_err_ErrEsc),                    //  output,   width = 1,                                              .ErrEsc
		.csi2_rx_o_ck_ppi_rx_err_ErrSyncEsc                (csi2_rx_o_ck_ppi_rx_err_ErrSyncEsc),                //  output,   width = 1,                                              .ErrSyncEsc
		.csi2_rx_o_ck_ppi_rx_err_ErrControl                (csi2_rx_o_ck_ppi_rx_err_ErrControl),                //  output,   width = 1,                                              .ErrControl
		.csi2_rx_o_ck_ppi_rx_err_ErrContentionLP0          (csi2_rx_o_ck_ppi_rx_err_ErrContentionLP0),          //  output,   width = 1,                                              .ErrContentionLP0
		.csi2_rx_o_ck_ppi_rx_err_ErrContentionLP1          (csi2_rx_o_ck_ppi_rx_err_ErrContentionLP1),          //  output,   width = 1,                                              .ErrContentionLP1
		.csi2_rx_video_streaming_interface_0_tdata         (csi2_rx_video_streaming_interface_0_tdata),         //  output,  width = 64,           csi2_rx_video_streaming_interface_0.tdata
		.csi2_rx_video_streaming_interface_0_tvalid        (csi2_rx_video_streaming_interface_0_tvalid),        //  output,   width = 1,                                              .tvalid
		.csi2_rx_video_streaming_interface_0_tready        (csi2_rx_video_streaming_interface_0_tready),        //   input,   width = 1,                                              .tready
		.csi2_rx_video_streaming_interface_0_tlast         (csi2_rx_video_streaming_interface_0_tlast),         //  output,   width = 1,                                              .tlast
		.csi2_rx_video_streaming_interface_0_tuser         (csi2_rx_video_streaming_interface_0_tuser),         //  output,   width = 8,                                              .tuser
		.csi2_rx_avalon_mm_control_interface_write         (csi2_rx_avalon_mm_control_interface_write),         //   input,   width = 1,           csi2_rx_avalon_mm_control_interface.write
		.csi2_rx_avalon_mm_control_interface_read          (csi2_rx_avalon_mm_control_interface_read),          //   input,   width = 1,                                              .read
		.csi2_rx_avalon_mm_control_interface_address       (csi2_rx_avalon_mm_control_interface_address),       //   input,  width = 10,                                              .address
		.csi2_rx_avalon_mm_control_interface_writedata     (csi2_rx_avalon_mm_control_interface_writedata),     //   input,  width = 32,                                              .writedata
		.csi2_rx_avalon_mm_control_interface_readdata      (csi2_rx_avalon_mm_control_interface_readdata),      //  output,  width = 32,                                              .readdata
		.csi2_rx_avalon_mm_control_interface_readdatavalid (csi2_rx_avalon_mm_control_interface_readdatavalid), //  output,   width = 1,                                              .readdatavalid
		.csi2_rx_avalon_mm_control_interface_waitrequest   (csi2_rx_avalon_mm_control_interface_waitrequest),   //  output,   width = 1,                                              .waitrequest
		.csi2_rx_avalon_mm_control_interface_byteenable    (csi2_rx_avalon_mm_control_interface_byteenable),    //   input,   width = 4,                                              .byteenable
		.csi2_rx_avalon_mm_control_interface_interrupt_irq (csi2_rx_avalon_mm_control_interface_interrupt_irq), //  output,   width = 1, csi2_rx_avalon_mm_control_interface_interrupt.irq
		
		// MIPI PHY
		.mipi_dphy_rzq_rzq                                 (CAM_RZQ1),                                 //   input,   width = 1,                                 mipi_dphy_rzq.rzq
		.mipi_dphy_ref_clk_0_clk                           (CLK_100_B2A_p),                           //   input,   width = 1,                           mipi_dphy_ref_clk_0.clk
		.mipi_dphy_LINK0_link_core_srst_reset_n            (mipi_dphy_LINK0_link_core_srst_reset_n),            //  output,   width = 1,                mipi_dphy_LINK0_link_core_srst.reset_n
		.mipi_dphy_LINK0_link_core_arst_reset_n            (mipi_dphy_LINK0_link_core_arst_reset_n),            //  output,   width = 1,                mipi_dphy_LINK0_link_core_arst.reset_n
		.mipi_dphy_axi_lite_awaddr                         (mipi_dphy_axi_lite_awaddr),                         //   input,  width = 12,                            mipi_dphy_axi_lite.awaddr
		.mipi_dphy_axi_lite_awvalid                        (mipi_dphy_axi_lite_awvalid),                        //   input,   width = 1,                                              .awvalid
		.mipi_dphy_axi_lite_awready                        (mipi_dphy_axi_lite_awready),                        //  output,   width = 1,                                              .awready
		.mipi_dphy_axi_lite_wdata                          (mipi_dphy_axi_lite_wdata),                          //   input,  width = 32,                                              .wdata
		.mipi_dphy_axi_lite_wstrb                          (mipi_dphy_axi_lite_wstrb),                          //   input,   width = 4,                                              .wstrb
		.mipi_dphy_axi_lite_wvalid                         (mipi_dphy_axi_lite_wvalid),                         //   input,   width = 1,                                              .wvalid
		.mipi_dphy_axi_lite_wready                         (mipi_dphy_axi_lite_wready),                         //  output,   width = 1,                                              .wready
		.mipi_dphy_axi_lite_bresp                          (mipi_dphy_axi_lite_bresp),                          //  output,   width = 2,                                              .bresp
		.mipi_dphy_axi_lite_bvalid                         (mipi_dphy_axi_lite_bvalid),                         //  output,   width = 1,                                              .bvalid
		.mipi_dphy_axi_lite_bready                         (mipi_dphy_axi_lite_bready),                         //   input,   width = 1,                                              .bready
		.mipi_dphy_axi_lite_araddr                         (mipi_dphy_axi_lite_araddr),                         //   input,  width = 12,                                              .araddr
		.mipi_dphy_axi_lite_arvalid                        (mipi_dphy_axi_lite_arvalid),                        //   input,   width = 1,                                              .arvalid
		.mipi_dphy_axi_lite_arready                        (mipi_dphy_axi_lite_arready),                        //  output,   width = 1,                                              .arready
		.mipi_dphy_axi_lite_rdata                          (mipi_dphy_axi_lite_rdata),                          //  output,  width = 32,                                              .rdata
		.mipi_dphy_axi_lite_rresp                          (mipi_dphy_axi_lite_rresp),                          //  output,   width = 2,                                              .rresp
		.mipi_dphy_axi_lite_rvalid                         (mipi_dphy_axi_lite_rvalid),                         //  output,   width = 1,                                              .rvalid
		.mipi_dphy_axi_lite_rready                         (mipi_dphy_axi_lite_rready),                         //   input,   width = 1,                                              .rready
		.mipi_dphy_axi_lite_arprot                         (mipi_dphy_axi_lite_arprot),                         //   input,   width = 3,                                              .arprot
		.mipi_dphy_axi_lite_awprot                         (mipi_dphy_axi_lite_awprot),                         //   input,   width = 3,                                              .awprot
		.mipi_dphy_LINK0_dphy_io_dphy_link_dp              (CAM1_D_p),              //   input,   width = 2,                       mipi_dphy_LINK0_dphy_io.dphy_link_dp
		.mipi_dphy_LINK0_dphy_io_dphy_link_dn              (CAM1_D_n),              //   input,   width = 2,                                              .dphy_link_dn
		.mipi_dphy_LINK0_dphy_io_dphy_link_cp              (CAM1_CLK_p),              //   input,   width = 1,                                              .dphy_link_cp
		.mipi_dphy_LINK0_dphy_io_dphy_link_cn              (CAM1_CLK_n),              //   input,   width = 1,                                              .dphy_link_cn
		.mipi_dphy_reg_bus_reg_wr_en_o                     (mipi_dphy_reg_bus_reg_wr_en_o),                     //  output,   width = 1,                             mipi_dphy_reg_bus.reg_wr_en_o
		.mipi_dphy_reg_bus_reg_rd_en_o                     (mipi_dphy_reg_bus_reg_rd_en_o),                     //  output,   width = 1,                                              .reg_rd_en_o
		.mipi_dphy_reg_bus_reg_raddr_o                     (mipi_dphy_reg_bus_reg_raddr_o),                     //  output,  width = 11,                                              .reg_raddr_o
		.mipi_dphy_reg_bus_reg_waddr_o                     (mipi_dphy_reg_bus_reg_waddr_o),                     //  output,  width = 11,                                              .reg_waddr_o
		.mipi_dphy_reg_bus_reg_be_o                        (mipi_dphy_reg_bus_reg_be_o),                        //  output,   width = 4,                                              .reg_be_o
		.mipi_dphy_reg_bus_reg_din_o                       (mipi_dphy_reg_bus_reg_din_o),                       //  output,  width = 32,                                              .reg_din_o
		.mipi_dphy_reg_bus_reg_dout_i                      (mipi_dphy_reg_bus_reg_dout_i)                      //   input,  width = 32,                                              .reg_dout_i
	);

///////////////////////////////////
//

wire camera_i2c_serial_sda_in;
wire camera_i2c_serial_scl_in;
wire camera_i2c_serial_sda_oe;
wire camera_i2c_serial_scl_oe;
		
assign camera_i2c_serial_scl_in = CAM1_I2C_SCL;
assign camera_i2c_serial_sda_in = CAM1_I2C_SDA;
assign CAM1_I2C_SCL = camera_i2c_serial_scl_oe ? 1'b0 : 1'bz;
assign CAM1_I2C_SDA = camera_i2c_serial_sda_oe ? 1'b0 : 1'bz;

// power on Camera
assign CAM1_GPIO = 1;

	//wire csi2_axi4_clk_clk;
	wire dphy_clk_clk; // not used now
	wire hdmi_clk_clk; // not used now
    system u0 (
        .clk_clk                               (CLK_50_B6A),                               //   input,   width = 1,                            clk.clk
        .i2c_camera_i2c_serial_sda_in          (camera_i2c_serial_sda_in),          //   input,   width = 1,          i2c_camera_i2c_serial.sda_in
        .i2c_camera_i2c_serial_scl_in          (camera_i2c_serial_scl_in),          //   input,   width = 1,                               .scl_in
        .i2c_camera_i2c_serial_sda_oe          (camera_i2c_serial_sda_oe),          //  output,   width = 1,                               .sda_oe
        .i2c_camera_i2c_serial_scl_oe          (camera_i2c_serial_scl_oe),          //  output,   width = 1,                               .scl_oe
        .csi2_axi4_clk_clk                     (axi4_clk /* 60MHz */),                     //  output,   width = 1,                  csi2_axi4_clk.clk
        .dphy_clk_clk                          (dphy_clk_clk /* 100MHz */),                          //  output,   width = 1,                       dphy_clk.clk
        .hdmi_clk_clk                          (hdmi_clk_clk /* 148.5MHz */),                          //  output,   width = 1,                       hdmi_clk.clk
        .pio_key_external_connection_export    (),    //   input,   width = 4,    pio_key_external_connection.export
        .pio_led_external_connection_export    (),    //  output,   width = 4,    pio_led_external_connection.export
        .pio_switch_external_connection_export (), //   input,  width = 10, pio_switch_external_connection.export
        .reset_n_reset_n                       (sys_reset_n),                       //   input,   width = 1,                        reset_n.reset_n
        .reset_in_vvp_in_reset_reset_n         (sys_reset_n)          //   input,   width = 1,          reset_in_vvp_in_reset.reset_n
    );

	

///////////////////////////////////
 //Optional, Analysis CSI-2 AXI4 video stream 
 
wire video_clk; 

wire   csi2_rx_video_streaming_interface_0_tready;
assign csi2_rx_video_streaming_interface_0_tready = 1'b1; // !!!!!!! always ready for camera continue to send video out

AXI_Stream_Analyze AXI_Stream_Analyze_inst(
	.reset_n    (sys_reset_n),
//	.axi_clock  (csi2_axi4_clock),
	.axi_clock  (axi4_clk),
	
	.axi_tdata  (csi2_rx_video_streaming_interface_0_tdata),
	.axi_tvalid (csi2_rx_video_streaming_interface_0_tvalid),
	.axi_tready (csi2_rx_video_streaming_interface_0_tready),
	.axi_tlast  (csi2_rx_video_streaming_interface_0_tlast),
	.axi_tuser  (csi2_rx_video_streaming_interface_0_tuser),
	
	//
	.o_video_clk(video_clk)
	
);

// override default value
defparam AXI_Stream_Analyze_inst.TICK_PER_SEC = 60000000;


reg [15:0] cnt;
always @(posedge video_clk)
begin
	cnt <= cnt + 1;
end

assign LED[0] = cnt[15];



endmodule
