// http://jhubei.terasic.com.tw:8248/redmine/projects/ageilx5_soc/wiki/CSI2_video_frame_Decode
// https://www.intel.com/content/www/us/en/docs/programmable/683397/current/video-packets.html

// video stream:
//   1.metapacket,  image info
//   2. video packet, line 0 data (tuser[1:0] = 01 for first pixel, tlast assert for last pixel)
//   3. video packet, line 1 data (tuser[1:0] = 00 for first pixel, tlast assert for last pixel)
//   ...
//   1081. video packet, line 1079  data (tuser[1:0] = 00 for first pixel, tlast assert for last pixel)
//   1082. meta packet, end of field



module AXI_Stream_Analyze(
	input 			reset_n,
	input 			axi_clock,
	input [63:0]	axi_tdata,
	input 			axi_tvalid,
	input 			axi_tready,
	input 			axi_tlast,
	input [7:0]		axi_tuser,
	
	// video out
	output				      o_video_clk,
	output	reg [9:0]		o_video_pix3,
	output	reg [9:0]	   o_video_pix2,	
	output	reg [9:0]		o_video_pix1,
	output	reg [9:0]	   o_video_pix0,
	
	output	reg 		      o_video_valid,
	output	reg			   o_video_frame_start,
	output	[31:0]	      o_video_pix_cnt,
	output	reg [31:0]	   o_video_pix_cnt_m,

	// result
	output	[2:0]		o_pkt_input,	
	output	[31:0]	o_pkt_beat_cnt,	
	output	[31:0]	o_pixel_cnt   ,	
	output	[31:0]	o_line_cnt   ,	
	output   [31:0]   o_frame_cnt  ,
	output	[15:0]	o_frame_width,	
	output	[15:0]	o_frame_heigh,	
	output	[15:0]	o_frame_per_sec
	

);

always @( negedge o_video_clk)
if (axi_tvalid & (axi_tuser == 2'b01))  o_video_pix_cnt_m<=0;
else if (o_video_valid) o_video_pix_cnt_m<=o_video_pix_cnt_m + 1 ;



assign o_pkt_input = pkg_input;
assign o_pkt_beat_cnt = beat_cnt;
assign o_pixel_cnt = pixel_cnt;
assign o_line_cnt = line_cnt;
assign o_frame_cnt = frame_cnt;
assign o_frame_width = frame_width;
assign o_frame_heigh = frame_height;
assign o_frame_per_sec = frame_cnt/sec_cnt;


parameter PIXEL_PER_BEAT = 4;

///////////////////////////////////////////////////////////////////////////
// event
wire pkg_video_start;
wire pkg_meta_start;
wire pkg_data;

assign pkg_video_start = (axi_tuser == 2'b01)?1'b1:1'b0;
assign pkg_meta_start  = (axi_tuser == 2'b10)?1'b1:1'b0;
assign pkg_data        = (axi_tuser == 2'b00)?1'b1:1'b0;


///////////////////////////////////////////////////////////////////////////
// Tick per second

//parameter TICK_PER_SEC = 150000000;
parameter TICK_PER_SEC = 60000000;



reg tick_sec /*synthesis noprune*/;
reg [31:0]	sec_cnt /*synthesis noprune*/;

reg [31:0]	tick_cnt;
always @(posedge axi_clock or negedge reset_n)
begin
	if (~reset_n)
	begin
		tick_cnt <= 0;
		tick_sec <= 1'b0;
		sec_cnt <= 0;
	end
	else if (tick_cnt < TICK_PER_SEC)
	begin
		tick_cnt <= tick_cnt + 1;
		tick_sec <= 1'b0;
	end
	else
	begin
		tick_cnt <= 0;
		tick_sec <= 1'b1;
		sec_cnt <= sec_cnt + 1;
	end
end

///////////////////////////////////////////////////////////////////////////
// parsing video stream
reg [2:0] pkg_input;

`define PKG_NONE		   			3'd0
`define PKG_VIDEO						3'd1 // TUSER[1:0] = 01
`define PKG_META_IMG_INFO			3'd2 // TUSER[1:0] = 10
`define PKG_META_END_OF_FIELD		3'd3
`define PKG_OTHER    	   		3'd4


//assign axi_tready = 1'b1; // always ready

wire [15:0]	axi_tdata16;
wire [4:0]	meta_id;

assign axi_tdata16 = axi_tdata[15:0];
assign meta_id     = axi_tdata[4:0];


reg [31:0] beat_cnt;
reg [6:0] frame_cnt7;



// detect start of package
always @(posedge axi_clock or negedge reset_n)
begin
	if (~reset_n)
	begin
		pkg_input <= `PKG_NONE;
		beat_cnt <= 0;
		frame_cnt7 <= 0;
	end
	else if (axi_tvalid & axi_tready)
	begin
		if (pkg_meta_start) // metapacket
		begin
			case(meta_id)
				0: 
					begin
					pkg_input <= `PKG_META_IMG_INFO;
					frame_cnt7 <= axi_tdata16[15:8];
					end
				1: pkg_input <= `PKG_META_END_OF_FIELD;
				default:  pkg_input <= `PKG_OTHER;
			endcase;
			beat_cnt <= 1;
		end
		else if (pkg_video_start) // video packet start
		begin
			pkg_input <= `PKG_VIDEO;
			beat_cnt <= 1;
		end
		else if (pkg_data) 
		begin
			beat_cnt <= beat_cnt + 1;
			pkg_input <= (axi_tlast && (pkg_input != `PKG_VIDEO))?`PKG_NONE:pkg_input;
		end
	end
end 

/////////////////////////
// parsing packege

reg [15:0] frame_width;
reg [15:0] frame_height;
reg [4:0] frame_bps;
reg [1:0] frame_subsa;
reg [1:0] frame_cosite;
reg [6:0] frame_color_space;

reg [15:0] field_cnt;
reg [31:0] pixel_cnt;
reg [31:0] line_cnt;
reg [31:0] frame_cnt;

always @(posedge axi_clock or negedge reset_n)
if (~reset_n) pixel_cnt <=0;
	 else if (axi_tvalid & (axi_tuser == 2'b01) ) pixel_cnt <=0; 
	 else if ( axi_tvalid ) pixel_cnt <= pixel_cnt + PIXEL_PER_BEAT;
	

				// video in
				//if (o_video_frame_start ) pixel_cnt <=0; 
				//else pixel_cnt <= pixel_cnt + PIXEL_PER_BEAT;



always @(posedge axi_clock or negedge reset_n)
begin
	if (~reset_n)
	begin
		frame_width <= 0;
		frame_height <= 0;
		frame_bps <= 0;
		frame_subsa <= 0;
		frame_cosite <= 0;
		frame_color_space <= 0;
	
		field_cnt <= 0;
		//pixel_cnt <= 0;
		frame_cnt <= 0;
	end
	else if (axi_tvalid & axi_tready)
	begin
		if (pkg_video_start) // video start
		begin
			//pixel_cnt <= PIXEL_PER_BEAT;
			line_cnt <= 0;
		end
		else if (pkg_data)
		begin
			if (pkg_input == `PKG_META_IMG_INFO) // image info package
			begin
				case(beat_cnt)
					1: frame_width <= axi_tdata16 + 1;
					2: frame_height <= axi_tdata16 + 1;
					3: {frame_color_space, frame_cosite, frame_subsa, frame_bps} <= axi_tdata16 + 1;
				endcase;
			end
			else if (pkg_input == `PKG_META_END_OF_FIELD) // end of filed pakcet
			begin
				if (beat_cnt == 1)
					field_cnt <= axi_tdata16;
			end
			else if (pkg_input == `PKG_VIDEO) // video
			begin
				// video in
				//if (o_video_frame_start ) pixel_cnt <=0; 
				//else pixel_cnt <= pixel_cnt + PIXEL_PER_BEAT;
				if (axi_tlast)
					line_cnt <= line_cnt + 1;
					
//				if ((pixel_cnt+PIXEL_PER_BEAT) == frame_width * frame_height) // last pixel
				if ((pixel_cnt+PIXEL_PER_BEAT+PIXEL_PER_BEAT) == frame_width * frame_height) // last pixel. modify to consitent to joy pixel_cnt
					frame_cnt <= frame_cnt + 1;
			end
		end
	end
end 


/////////////////////////
// output video
assign o_video_clk       = axi_clock;


//assign o_video_pix3        =axi_tdata[48+9:48];
//assign o_video_pix2        =axi_tdata[32+9:32];
//assign o_video_pix1        =axi_tdata[16+9:16];
//assign o_video_pix0        =axi_tdata[ 0+9: 0];
//assign o_video_frame_start = axi_tvalid & (axi_tuser == 2'b01) ;//axi_tready & (axi_tuser == 2'b01) ;//pkg_video_start;
//assign o_video_valid       = axi_tvalid ;//& axi_tready & is_video_data;






always @(posedge axi_clock)  begin 
o_video_pix3        <=axi_tdata[48+9:48];
o_video_pix2        <=axi_tdata[32+9:32];
o_video_pix1        <=axi_tdata[16+9:16];
o_video_pix0        <=axi_tdata[ 0+9: 0];
o_video_frame_start <= axi_tvalid & (axi_tuser == 2'b01) ;
o_video_valid       <= axi_tvalid ;
end 




wire is_video_data;
assign is_video_data   = (pkg_video_start || (pkg_data && (pkg_input == `PKG_VIDEO)))?1'b1:1'b0;

assign o_video_pix_cnt =pixel_cnt;// pkg_video_start?0:pixel_cnt;

// packet count
reg	[15:0]	video_packet_cnt /*synthesis noprune*/;
reg	[15:0]	meta_info_packet_cnt /*synthesis noprune*/;	
reg	[15:0]	meta_end_packet_cnt /*synthesis noprune*/;	
reg	[15:0]	meta_other_packet_cnt /*synthesis noprune*/;	

wire [4:0] meta_id;
assign meta_id = axi_tdata[4:0];

always @(posedge axi_clock or negedge reset_n)
begin
	if (~reset_n)
	begin
		video_packet_cnt <= 0;
		meta_info_packet_cnt <= 0;
		meta_end_packet_cnt <= 0;
		meta_other_packet_cnt <= 0;
	end
	else if (tick_cnt == TICK_PER_SEC)
	begin
		video_packet_cnt <= 0;
		meta_info_packet_cnt <= 0;
		meta_end_packet_cnt <= 0;
		meta_other_packet_cnt <= 0;
	end
	else if (axi_tvalid & axi_tready)
	begin
		if (axi_tuser[1:0] == 2'b01)
			video_packet_cnt <= video_packet_cnt + 1;
		else if (axi_tuser[1:0] == 2'b10)
		begin
		
			if (meta_id == 0)
				meta_info_packet_cnt <= meta_info_packet_cnt + 1;
			else if (meta_id == 1)
				meta_end_packet_cnt <= meta_end_packet_cnt + 1;
			else
				meta_other_packet_cnt <= meta_other_packet_cnt + 1;
		end
	end
	
end

// valid count
reg	[31:0]	valid_cnt /*synthesis noprune*/;
always @(posedge axi_clock or negedge reset_n)
begin
	if (~reset_n)
		valid_cnt <= 0;
	else if (tick_cnt == TICK_PER_SEC)
		valid_cnt <= 0;
	else if (axi_tvalid & axi_tready)
		valid_cnt <= valid_cnt + 1;
	
end


endmodule
