#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <linux/i2c-dev.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "lis2dw12_test.h"
#include "lis2dw12_regs.h"

int32_t i2c_init();
int32_t i2c_write(void *handle, uint8_t reg, uint8_t *pbuf, uint16_t len);
int32_t i2c_read(void *handle, uint8_t reg, uint8_t *pbuf, uint16_t len);

int main(int argc, char *argv[]){
    int file;
    bool ret;
	uint8_t id;
	float_t f_xyz[3],temp;
	int cnt=0, max_cnt=0;
	
	printf("===== gsensor test =====\r\n");
	
	if (argc == 2){
		max_cnt = atoi(argv[1]);
	}
	
    file = i2c_init();
    if (file == -1){
        exit(1);
    }
    
    lis2dw12_dev_t lis2dw12_dev;
    lis2dw12_dev.handle = &file;
    lis2dw12_dev.read_reg = i2c_read;
    lis2dw12_dev.write_reg = i2c_write;

    // reset device 
    ret = lis2dw12_reset(&lis2dw12_dev);
	if (!ret){
        printf("Reset device failed!");
        exit(1);
    }

	// init	device
    ret = lis2dw12_init(&lis2dw12_dev);
    if (ret){
        // dump chip id
        if (lis2dw12_device_id_get(&lis2dw12_dev, &id)==0)
            printf("Device ID=%02xh,Read ID=%02Xh\r\n", LIS2DW12_ID,id);
    }
    
    // read xyz and temprature, then print
    while(ret && (max_cnt == 0 || cnt < max_cnt)){
        if (lis2dw12_is_data_ready(&lis2dw12_dev) && lis2dw12_is_temp_ready(&lis2dw12_dev)){
            ret = lis2dw12_xyz_read(&lis2dw12_dev, f_xyz);
            ret = lis2dw12_temp_read(&lis2dw12_dev, &temp);
            if (ret){
                printf("[%d]X=%f mg, Y=%f mg, Z=%f mg, T=%f ℃\r\n", cnt, f_xyz[0], f_xyz[1], f_xyz[2], temp);
                usleep(1000*1000);
            }
            cnt++;
        }
        usleep(1000*1000);
    }
    
    if (!ret) printf("Failed to access accelerometer\r\n");

    if (file) close(file);
			
	printf("gsensor, bye!\r\n");			

	return 0;
}

int i2c_init(){
    int file=-1;    
    const char *filename = "/dev/i2c-0";
    int i2c_addr = 0b0011001; 
    
    // open bus
	if ((file = open(filename, O_RDWR)) < 0) {
        /* ERROR HANDLING: you can check errno to see what went wrong */
        perror("Failed to open the i2c bus of gsensor");
        return -1;
    }

	if (ioctl(file, I2C_SLAVE, i2c_addr) < 0) {
  	    printf("Failed to acquire bus access and/or talk to slave.\n");
	    /* ERROR HANDLING; you can check errno to see what went wrong */
        return -1;
	}
    
    return file;
}

int32_t i2c_write(void *handle, uint8_t reg, uint8_t *pbuf, uint16_t len){
    int fd = *(int*)handle;
    uint8_t buf[len + 1];
    buf[0] = reg;
    memcpy(&buf[1], pbuf, len);

    if (write(fd, &buf, len+1) != len+1){
    	perror("I2C write failed");
		return -1;
	}
	usleep(5000); // delay 5ms after write
	return 0;		
}

int32_t i2c_read(void *handle, uint8_t reg, uint8_t *pbuf, uint16_t len){
	int fd = *(int*)handle;
	
    if (write(fd, &reg, 1) != 1) {
    	perror("Register select failed");
        return -1;
    }
    
    if (read(fd, pbuf, len) != len) {
    	perror("I2C read failed");
        return -1;
    }
    
    return 0;
}
