#ifndef __LIS2DW12_TYPES_H__
#define __LIS2DW12_TYPES_H__

#include <stdint.h>
#include <stddef.h>
#include <math.h>

typedef int32_t (*dev_write_ptr)(void *, uint8_t, uint8_t *, uint16_t);
typedef int32_t (*dev_read_ptr)(void *, uint8_t, uint8_t *, uint16_t);
typedef void (*dev_mdelay_ptr)(uint32_t millisec);

typedef struct{
    dev_write_ptr  write_reg;
    dev_read_ptr   read_reg;
    dev_mdelay_ptr mdelay;
    void *handle;
} lis2dw12_dev_t;

// data type define
typedef struct{
    uint8_t lp_mode : 2;
    uint8_t mode    : 2;
    uint8_t odr     : 4;
} lis2dw12_ctrl1_t;

typedef struct{
    uint8_t sim         : 1;
    uint8_t i2c_disable : 1;
    uint8_t if_add_inc  : 1;
    uint8_t bdu         : 1;
    uint8_t cs_pu_disc  : 1;
    uint8_t reserved    : 1;
    uint8_t soft_reset  : 1;
    uint8_t boot        : 1;
} lis2dw12_ctrl2_t;

typedef struct{
    uint8_t slp_mode    : 2; 
    uint8_t reserved    : 1;
    uint8_t h_l_active  : 1;
    uint8_t latch_int   : 1;
    uint8_t pp_od       : 1;
    uint8_t self_test   : 2;
} lis2dw12_ctrl3_t;

typedef struct{
    uint8_t int1_dat_rdy_xyz : 1;
    uint8_t int1_fifo_thsh   : 1;
    uint8_t int1_fifo_full   : 1;
    uint8_t int1_double_tap  : 1;
    uint8_t int1_freefall    : 1;
    uint8_t int1_wake_up     : 1;
    uint8_t int1_single_tap  : 1;
    uint8_t int1_6d          : 1;
} lis2dw12_ctrl4_int1_pad_ctrl_t;

typedef struct{
    uint8_t int2_dat_rdy_xyz  : 1;
    uint8_t int2_fifo_thsh    : 1;
    uint8_t int2_fifo_full    : 1;
    uint8_t int2_fifo_overrun : 1;
    uint8_t int2_dat_rdy_temp : 1;
    uint8_t int2_boot         : 1;
    uint8_t int2_sleep_chg    : 1;
    uint8_t int2_sleep_state  : 1;
} lis2dw12_ctrl5_int2_pad_ctrl_t;

typedef struct{
    uint8_t reserved       : 2;
    uint8_t low_noise      : 1;
    uint8_t filt_path_sel  : 1;
    uint8_t full_scale_sel : 2;
    uint8_t bnadwidth_filt : 2;
} lis2dw12_ctrl6_t;

typedef struct{
    uint8_t dat_rdy_xyz    : 1;
    uint8_t freefall_event : 1;
    uint8_t _6d_event      : 1;
    uint8_t single_tap     : 1;
    uint8_t double_tap     : 1;
    uint8_t sleep_state    : 1;
    uint8_t wakeup_event   : 1;
    uint8_t fifo_thsh      : 1;
} lis2dw12_status_t;

typedef struct{
    uint8_t fifo_thsh   : 5;
    uint8_t fifo_mode   : 3;
} lis2dw12_fifo_ctrl_t;

typedef struct{
    uint8_t unread_nums    : 6;
    uint8_t fifo_overrun   : 1;
    uint8_t fifo_thsh_flag : 1;
} lis2dw12_fifo_samples_t;

typedef struct{
    uint8_t tap_x_thsh : 5;
    uint8_t _6d_thsh   : 2;
    uint8_t _4d_en     : 1;
} lis2dw12_tap_ths_x_t;

typedef struct{
    uint8_t tap_y_thsh : 5;
    uint8_t tap_prior  : 3;
} lis2dw12_tap_ths_y_t;

typedef struct{
    uint8_t tap_z_thsh : 5;
    uint8_t tap_z_en   : 1;
    uint8_t tap_y_en   : 1;
    uint8_t tap_x_en   : 1;
} lis2dw12_tap_ths_z_t;

typedef struct{
    uint8_t shock   : 2;
    uint8_t quiet   : 2;
    uint8_t latency : 4;
} lis2dw12_int_dur_t;

typedef struct{
    uint8_t wakeup_thsh       : 6;
    uint8_t sleep_on          : 1;
    uint8_t single_double_tap : 1;
} lis2dw12_wake_up_ths_t;

typedef struct{
    uint8_t sleep_dur    : 4;
    uint8_t stationary   : 1;
    uint8_t wakeup_dur   : 2;
    uint8_t freefall_dur5: 1;
} lis2dw12_wake_up_dur_t;

typedef struct{
    uint8_t freefall_thsh    : 3;
    uint8_t freefall_dur4_0  : 5;
} lis2dw12_free_fall_t;

typedef struct{
    uint8_t dat_rdy_xyz    : 1;
    uint8_t freefall_event : 1;
    uint8_t _6d_event      : 1;
    uint8_t single_tap     : 1;
    uint8_t double_tap     : 1;
    uint8_t sleep_event    : 1;
    uint8_t dat_rdy_temp   : 1;
    uint8_t fifo_overrun   : 1;
} lis2dw12_status_dup_t;

typedef struct{
    uint8_t z_wakeup       : 1;
    uint8_t y_wakeup       : 1;
    uint8_t x_wakeup       : 1;
    uint8_t wakeup_event   : 1;
    uint8_t sleep_event    : 1;
    uint8_t freefall_event : 1;
    uint8_t reserved       : 2;
} lis2dw12_wake_up_src_t;

typedef struct{
    uint8_t z_tap      : 1;
    uint8_t y_tap      : 1;
    uint8_t x_tap      : 1;
    uint8_t tap_sign   : 1;
    uint8_t double_tap : 1;
    uint8_t single_tap : 1;
    uint8_t tap_event  : 1;
    uint8_t reserved   : 1;
} lis2dw12_tap_src_t;

typedef struct{
    uint8_t xl        : 1;
    uint8_t xh        : 1;
    uint8_t yl        : 1;
    uint8_t yh        : 1;
    uint8_t zl        : 1;
    uint8_t zh        : 1;
    uint8_t _6d_event : 1;
    uint8_t reserved  : 1;
} lis2dw12_sixd_src_t;

typedef struct{
    uint8_t freefall_event  : 1;
    uint8_t wakeup_event    : 1;
    uint8_t single_tap      : 1;
    uint8_t double_tap      : 1;
    uint8_t _6d_event       : 1;
    uint8_t sleep_chg_event : 1;
    uint8_t reserved        : 2;
} lis2dw12_all_int_src_t;

typedef struct{
    uint8_t lpass_on6d        : 1;
    uint8_t hp_ref_mode       : 1;
    uint8_t usr_off_w         : 1;
    uint8_t usr_off_on_wu     : 1;
    uint8_t usr_off_on_out    : 1;
    uint8_t interrupts_enable : 1;
    uint8_t int2_on_int1      : 1;
    uint8_t dat_rdy_pulsed    : 1;
} lis2dw12_ctrl7_t;

// value define
typedef enum{ // low_noise,bdu,mode[1:0],lp_mode[1:0],
    LIS2DW12_CONTINUE_HIGH_PERFORMANCE           = 0x04,
    LIS2DW12_CONTINUE_LOW_PWR_4                  = 0x03,
    LIS2DW12_CONTINUE_LOW_PWR_3                  = 0x02,
    LIS2DW12_CONTINUE_LOW_PWR_2                  = 0x01,
    LIS2DW12_CONTINUE_LOW_PWR_12bit              = 0x00,
    LIS2DW12_SINGLE_LOW_PWR_4                    = 0x0B,
    LIS2DW12_SINGLE_LOW_PWR_3                    = 0x0A,
    LIS2DW12_SINGLE_LOW_PWR_2                    = 0x09,
    LIS2DW12_SINGLE_LOW_PWR_12bit                = 0x08,
    LIS2DW12_HIGH_PERFORMANCE_LOW_NOISE          = 0x14,
    LIS2DW12_CONTINUE_LOW_PWR_LOW_NOISE_4        = 0x13,
    LIS2DW12_CONTINUE_LOW_PWR_LOW_NOISE_3        = 0x12,
    LIS2DW12_CONTINUE_LOW_PWR_LOW_NOISE_2        = 0x11,
    LIS2DW12_CONTINUE_LOW_PWR_LOW_NOISE_12bit    = 0x10,
    LIS2DW12_SINGLE_LOW_PWR_LOW_NOISE_4          = 0x1B,
    LIS2DW12_SINGLE_LOW_PWR_LOW_NOISE_3          = 0x1A,
    LIS2DW12_SINGLE_LOW_PWR_LOW_NOISE_2          = 0x19,
    LIS2DW12_SINGLE_LOW_LOW_NOISE_PWR_12bit      = 0x18,
} lis2dw12_mode_t;

typedef enum{ //slp_mode_sel,slp_mode_1,odr[3:0]
    LIS2DW12_XL_ODR_OFF            = 0x00,
    LIS2DW12_XL_ODR_1p6Hz_LP_ONLY  = 0x01, 
    LIS2DW12_XL_ODR_12p5Hz         = 0x02,
    LIS2DW12_XL_ODR_25Hz           = 0x03,
    LIS2DW12_XL_ODR_50Hz           = 0x04,
    LIS2DW12_XL_ODR_100Hz          = 0x05,
    LIS2DW12_XL_ODR_200Hz          = 0x06,
    LIS2DW12_XL_ODR_400Hz          = 0x07,  /* Use this only in high performance */
    LIS2DW12_XL_ODR_800Hz          = 0x08,  /* Use this only in high performance */
    LIS2DW12_XL_ODR_1p6KHz         = 0x09,  /* Use this only in high performance */
    LIS2DW12_XL_SET_SW_TRIG        = 0x32,  /* Use this only in SINGLE mode */
    LIS2DW12_XL_SET_PIN_TRIG       = 0x12,  /* Use this only in SINGLE mode */
} lis2dw12_slp_and_odr_t;

typedef enum{
    LIS2DW12_SPI_4_WIRE   = 0,
    LIS2DW12_SPI_3_WIRE   = 1,
} lis2dw12_spi_mode_t;
  
typedef enum{
    LIS2DW12_I2C_ENABLE    = 0,
    LIS2DW12_I2C_DISABLE   = 1,
} lis2dw12_i2c_disable_t;

typedef enum{
    LIS2DW12_PULL_UP_CONNECT     = 0,
    LIS2DW12_PULL_UP_DISCONNECT  = 1,
} lis2dw12_cs_pullup_disc_t;

typedef enum{
    LIS2DW12_ACTIVE_HIGH  = 0,
    LIS2DW12_ACTIVE_LOW   = 1,
} lis2dw12_h_l_active_t;
  
typedef enum{
    LIS2DW12_INT_PULSED   = 0,
    LIS2DW12_INT_LATCHED  = 1,
} lis2dw12_latch_int_req_t;

typedef enum{
    LIS2DW12_PUSH_PULL   = 0,
    LIS2DW12_OPEN_DRAIN  = 1,
} lis2dw12_pp_od_t;

typedef enum{
    LIS2DW12_XL_ST_DISABLE      = 0,
    LIS2DW12_XL_ST_POSITIVE     = 1,
    LIS2DW12_XL_ST_NEGATIVE     = 2,
} lis2dw12_selftest_t;

typedef enum{ // fds,usr_off_on_out
    LIS2DW12_LPF_ON_OUT         = 0x00,
    LIS2DW12_USER_OFFSET_ON_OUT  = 0x01,
    LIS2DW12_HIGH_PASS_ON_OUT    = 0x10,
} lis2dw12_filt_dat_type_t;

typedef enum{
    LIS2DW12_2g     = 0,
    LIS2DW12_4g     = 1,
    LIS2DW12_8g     = 2,
    LIS2DW12_16g    = 3,
} lis2dw12_fullscale_t;

typedef enum{
    LIS2DW12_ODR_DIV_2     = 0,
    LIS2DW12_ODR_DIV_4     = 1,
    LIS2DW12_ODR_DIV_10    = 2,
    LIS2DW12_ODR_DIV_20    = 3,
} lis2dw12_bw_filt_t;

typedef enum{
    LIS2DW12_FF_TSH_5LSB_FS2g  = 0,
    LIS2DW12_FF_TSH_7LSB_FS2g  = 1,
    LIS2DW12_FF_TSH_8LSB_FS2g  = 2,
    LIS2DW12_FF_TSH_10LSB_FS2g = 3,
    LIS2DW12_FF_TSH_11LSB_FS2g = 4,
    LIS2DW12_FF_TSH_13LSB_FS2g = 5,
    LIS2DW12_FF_TSH_15LSB_FS2g = 6,
    LIS2DW12_FF_TSH_16LSB_FS2g = 7,
} lis2dw12_freefall_thsh_t;
  
typedef enum{
    LIS2DW12_BYPASS_MODE             = 0,
    LIS2DW12_FIFO_MODE               = 1,
    LIS2DW12_STREAM_TO_FIFO_MODE     = 3,
    LIS2DW12_BYPASS_TO_STREAM_MODE   = 4,
    LIS2DW12_STREAM_MODE             = 6,
} lis2dw12_fifo_mode_t;

typedef enum{
    LIS2DW12_XYZ    = 0,
    LIS2DW12_YXZ    = 1,
    LIS2DW12_XZY    = 2,
    LIS2DW12_ZYX    = 3,
    LIS2DW12_YZX    = 5,
    LIS2DW12_ZXY    = 6,
} lis2dw12_tap_prior_t;

typedef enum{
    LIS2DW12_NO_DETECTION        = 0,
    LIS2DW12_DETECT_ACT_INACT    = 1,
    LIS2DW12_DETECT_STAT_MOTION  = 3,
} lis2dw12_sleep_on_t;

typedef enum{
    LIS2DW12_ONLY_SINGLE          = 0,
    LIS2DW12_BOTH_SINGLE_DOUBLE   = 1,
} lis2dw12_single_double_tap_t;

typedef struct{
    lis2dw12_status_dup_t   status_dup;
    lis2dw12_wake_up_src_t  wake_up_src;
    lis2dw12_tap_src_t      tap_src;
    lis2dw12_sixd_src_t     sixd_src;
    lis2dw12_all_int_src_t  all_int_src;
} lis2dw12_all_sources_t;

typedef enum{
    LIS2DW12_ODR_DIV_2_FEED   = 0,
    LIS2DW12_LPF2_FEED        = 1,
} lis2dw12_lpass_on6d_t;

typedef enum{
    LIS2DW12_LSB_977ug    = 0,
    LIS2DW12_LSB_15p6mg   = 1,
} lis2dw12_usr_offset_weight_t;

typedef enum{
    LIS2DW12_HP_FEED           = 0,
    LIS2DW12_USER_OFFSET_FEED  = 1,
} lis2dw12_usr_offset_on_wakeup_t;

typedef enum{
    LIS2DW12_DRDY_LATCHED   = 0,
    LIS2DW12_DRDY_PULSED    = 1,
} lis2dw12_dat_rdy_pulsed_t;


#endif