#include "lis2dw12_regs.h"
#include "lis2dw12_test.h"
#include <stdio.h>

bool lis2dw12_init(lis2dw12_dev_t *pdev){
    int32_t ret=0;

    // Enable Block Data Update 
    ret = lis2dw12_block_data_update_set(pdev, PROPERTY_ENABLE);

    // set fullscale to +- 2g
    if (ret == 0){
        ret = lis2dw12_full_scale_set(pdev,LIS2DW12_2g);
    }

    // Configure filtering chain 
    // Accelerometer - filter path / bandwidth
    if (ret == 0){
        ret = lis2dw12_filter_path_set(pdev, LIS2DW12_LPF_ON_OUT);
    }
    if (ret == 0){     
        ret = lis2dw12_filter_bandwidth_set(pdev, LIS2DW12_ODR_DIV_4);
    }
    
    // Set power mode to high performance with continue data 14bit
    if (ret == 0){ 
        ret = lis2dw12_power_mode_set(pdev,LIS2DW12_CONTINUE_HIGH_PERFORMANCE);
    }
    
    // Set output date rate: 50Hz
    if (ret == 0){
        ret = lis2dw12_data_rate_set(pdev,LIS2DW12_XL_ODR_50Hz);
    }

    return (ret==0)?true:false;
}

bool lis2dw12_reset(lis2dw12_dev_t *pdev){
    uint8_t rst;
    int32_t ret;

    // Reset device
    ret = lis2dw12_reset_set(pdev, PROPERTY_ENABLE);
    if (ret == 0){
        do {
            ret = lis2dw12_reset_get(pdev, &rst);
        } while (rst);
    }
    
    return (ret==0)?true:false;
}

bool lis2dw12_is_data_ready(lis2dw12_dev_t *pdev){
    int32_t ret;
    uint8_t reg;

    ret = lis2dw12_flag_data_ready_get(pdev, &reg);
    //printf("in is_data_ready function:\n");
    //printf("ret = %d,reg = %d, %s\n",ret,reg,(ret == 0 && reg == 1)?"xyz data is ready":"xyz data is not ready");
	
    return (ret == 0 && reg == 1)?true:false;
}

bool lis2dw12_xyz_read(lis2dw12_dev_t *pdev, float data[3]){
    int32_t ret;
    int16_t data_raw_acceleration[3];

    ret = lis2dw12_acceleration_raw_get(pdev, data_raw_acceleration);
    //printf("in xyz_read function:\n");
    //printf("ret = %d, %s\n",ret,(ret == 0)?"xyz read data ok":"xyz read data not ok");
	
    data[0] = lis2dw12_from_fs2_to_mg(data_raw_acceleration[0]);
    data[1] = lis2dw12_from_fs2_to_mg(data_raw_acceleration[1]);
    data[2] = lis2dw12_from_fs2_to_mg(data_raw_acceleration[2]);
    
    return (ret==0)?true:false;
}

bool lis2dw12_is_temp_ready(lis2dw12_dev_t *pdev){
    int32_t ret;
    lis2dw12_all_sources_t all_src;

    ret = lis2dw12_all_sources_get(pdev, &all_src);
    //printf("in is_temp_ready function:\n");
    //printf("ret = %d,dat_rdy_temp = %d, %s\n",ret,all_src.status_dup.dat_rdy_temp,(ret == 0 && all_src.status_dup.dat_rdy_temp == 1)?"temp data is ready":"temp data is not ready");

    return (ret == 0 && all_src.status_dup.dat_rdy_temp == 1)?true:false;
}

bool lis2dw12_temp_read(lis2dw12_dev_t *pdev, float_t *pdata){
    int32_t ret;
    int16_t temp_raw;

    ret = lis2dw12_temperature_raw_get(pdev, &temp_raw);
    //printf("in temp_read function:\n");
    //printf("ret = %d, %s\n",ret,(ret == 0)?"temp read data ok":"temp read data not ok");
    *pdata = lis2dw12_from_lsb_to_celsius(temp_raw);
    
    return (ret==0)?true:false;
}
