#ifndef __LIS2DW12_REGS_H__
#define __LIS2DW12_REGS_H__

// Register List
#define REG_OUT_T_L      0x0D // Temp sensor output
#define REG_OUT_T_H      0x0E  
#define REG_WHO_AM_I     0x0F // Who am I ID 44h
#define REG_CTRL1        0x20 // Control registers
#define REG_CTRL2        0x21 
#define REG_CTRL3        0x22 
#define REG_CTRL4        0x23 // INT1_PAD_CTRL
#define REG_CTRL5        0x24 // INT2_PAD_CTRL
#define REG_CTRL6        0x25 
#define REG_OUT_T        0x26 // Temp sensor output
#define REG_STATUS       0x27 // Status data register
#define REG_OUT_X_L      0x28 // Output registers
#define REG_OUT_X_H      0x29 
#define REG_OUT_Y_L      0x2A 
#define REG_OUT_Y_H      0x2B 
#define REG_OUT_Z_L      0x2C 
#define REG_OUT_Z_H      0x2D 
#define REG_FIFO_CTRL    0x2E // FIFO control register
#define REG_FIFO_SAMPLES 0x2F // Unread samples stored in FIFO
#define REG_TAP_THS_X    0x30 // Tap thresholds
#define REG_TAP_THS_Y    0x31 
#define REG_TAP_THS_Z    0x32 
#define REG_INT_DUR      0x33 // Interrupt duration
#define REG_WAKE_UP_THS  0x34 // Tap/double-tap selection,inactivity enable,wake-up threshold
#define REG_WAKE_UP_DUR  0x35 // Wake-up duration
#define REG_FREE_FALL    0x36 // Free-fall configuration
#define REG_STATUS_DUP   0x37 // Status register
#define REG_WAKE_UP_SRC  0x38 // Wake-up source
#define REG_TAP_SRC      0x39 // Tap source
#define REG_SIXD_SRC     0x3A // 6D source
#define REG_ALL_INT_SRC  0x3B 
#define REG_X_OFS_USR    0x3C
#define REG_Y_OFS_USR    0x3D 
#define REG_Z_OFS_USR    0x3E 
#define REG_CTRL7        0x3F 

// fix value
#define LIS2DW12_ID         0x44
#define PROPERTY_DISABLE    0x00
#define PROPERTY_ENABLE     0x01

#endif

