#ifndef __LIS2DW12_API_H__
#define __LIS2DW12_API_H__

#include "lis2dw12_types.h"

// stub apis
int32_t lis2dw12_read_reg(lis2dw12_dev_t *pdev, uint8_t reg,uint8_t *data,uint16_t len);
int32_t lis2dw12_write_reg(lis2dw12_dev_t *pdev, uint8_t reg,uint8_t *data,uint16_t len);

// base apis
float_t lis2dw12_from_fs2_to_mg(int16_t lsb);
float_t lis2dw12_from_fs4_to_mg(int16_t lsb);
float_t lis2dw12_from_fs8_to_mg(int16_t lsb);
float_t lis2dw12_from_fs16_to_mg(int16_t lsb);

float_t lis2dw12_from_fs2_lp1_to_mg(int16_t lsb);
float_t lis2dw12_from_fs4_lp1_to_mg(int16_t lsb);
float_t lis2dw12_from_fs8_lp1_to_mg(int16_t lsb);
float_t lis2dw12_from_fs16_lp1_to_mg(int16_t lsb);

float_t lis2dw12_from_lsb_to_celsius(int16_t lsb);

int32_t lis2dw12_power_mode_set(lis2dw12_dev_t *pdev,lis2dw12_mode_t val);
int32_t lis2dw12_power_mode_get(lis2dw12_dev_t *pdev,lis2dw12_mode_t *val);

int32_t lis2dw12_data_rate_set(lis2dw12_dev_t *pdev,lis2dw12_slp_and_odr_t val);
int32_t lis2dw12_data_rate_get(lis2dw12_dev_t *pdev,lis2dw12_slp_and_odr_t *val);

int32_t lis2dw12_block_data_update_set(lis2dw12_dev_t *pdev,uint8_t val);
int32_t lis2dw12_block_data_update_get(lis2dw12_dev_t *pdev,uint8_t *val);

int32_t lis2dw12_full_scale_set(lis2dw12_dev_t *pdev, lis2dw12_fullscale_t val);
int32_t lis2dw12_full_scale_get(lis2dw12_dev_t *pdev,lis2dw12_fullscale_t *val);

int32_t lis2dw12_status_reg_get(lis2dw12_dev_t *pdev,lis2dw12_status_t *val);

int32_t lis2dw12_flag_data_ready_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_all_sources_get(lis2dw12_dev_t *pdev,lis2dw12_all_sources_t *val);

int32_t lis2dw12_usr_offset_x_set(lis2dw12_dev_t *pdev, uint8_t *buff);
int32_t lis2dw12_usr_offset_x_get(lis2dw12_dev_t *pdev, uint8_t *buff);

int32_t lis2dw12_usr_offset_y_set(lis2dw12_dev_t *pdev, uint8_t *buff);
int32_t lis2dw12_usr_offset_y_get(lis2dw12_dev_t *pdev, uint8_t *buff);

int32_t lis2dw12_usr_offset_z_set(lis2dw12_dev_t *pdev, uint8_t *buff);
int32_t lis2dw12_usr_offset_z_get(lis2dw12_dev_t *pdev, uint8_t *buff);

int32_t lis2dw12_offset_weight_set(lis2dw12_dev_t *pdev,lis2dw12_usr_offset_weight_t val);
int32_t lis2dw12_offset_weight_get(lis2dw12_dev_t *pdev,lis2dw12_usr_offset_weight_t *val);

int32_t lis2dw12_temperature_raw_get(lis2dw12_dev_t *pdev, int16_t *val);

int32_t lis2dw12_acceleration_raw_get(lis2dw12_dev_t *pdev,int16_t *val);

int32_t lis2dw12_device_id_get(lis2dw12_dev_t *pdev, uint8_t *buff);

int32_t lis2dw12_auto_increment_set(lis2dw12_dev_t *pdev, uint8_t val);
int32_t lis2dw12_auto_increment_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_reset_set(lis2dw12_dev_t *pdev, uint8_t val);
int32_t lis2dw12_reset_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_boot_set(lis2dw12_dev_t *pdev, uint8_t val);
int32_t lis2dw12_boot_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_self_test_set(lis2dw12_dev_t *pdev, lis2dw12_selftest_t val);
int32_t lis2dw12_self_test_get(lis2dw12_dev_t *pdev, lis2dw12_selftest_t *val);

int32_t lis2dw12_data_ready_mode_set(lis2dw12_dev_t *pdev,lis2dw12_dat_rdy_pulsed_t val);
int32_t lis2dw12_data_ready_mode_get(lis2dw12_dev_t *pdev,lis2dw12_dat_rdy_pulsed_t *val);

int32_t lis2dw12_filter_path_set(lis2dw12_dev_t *pdev,lis2dw12_filt_dat_type_t val);
int32_t lis2dw12_filter_path_get(lis2dw12_dev_t *pdev,lis2dw12_filt_dat_type_t *val);

int32_t lis2dw12_filter_bandwidth_set(lis2dw12_dev_t *pdev,lis2dw12_bw_filt_t val);
int32_t lis2dw12_filter_bandwidth_get(lis2dw12_dev_t *pdev,lis2dw12_bw_filt_t *val);

int32_t lis2dw12_reference_mode_set(lis2dw12_dev_t *pdev, uint8_t val);
int32_t lis2dw12_reference_mode_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_spi_mode_set(lis2dw12_dev_t *pdev, lis2dw12_spi_mode_t val);
int32_t lis2dw12_spi_mode_get(lis2dw12_dev_t *pdev, lis2dw12_spi_mode_t *val);

int32_t lis2dw12_i2c_interface_set(lis2dw12_dev_t *pdev,lis2dw12_i2c_disable_t val);
int32_t lis2dw12_i2c_interface_get(lis2dw12_dev_t *pdev,lis2dw12_i2c_disable_t *val);

int32_t lis2dw12_cs_mode_set(lis2dw12_dev_t *pdev,lis2dw12_cs_pullup_disc_t val);
int32_t lis2dw12_cs_mode_get(lis2dw12_dev_t *pdev,lis2dw12_cs_pullup_disc_t *val);

int32_t lis2dw12_pin_polarity_set(lis2dw12_dev_t *pdev,lis2dw12_h_l_active_t val);
int32_t lis2dw12_pin_polarity_get(lis2dw12_dev_t *pdev,lis2dw12_h_l_active_t *val);

int32_t lis2dw12_int_notification_set(lis2dw12_dev_t *pdev,lis2dw12_latch_int_req_t val);
int32_t lis2dw12_int_notification_get(lis2dw12_dev_t *pdev,lis2dw12_latch_int_req_t *val);

int32_t lis2dw12_pin_mode_set(lis2dw12_dev_t *pdev,lis2dw12_pp_od_t val);
int32_t lis2dw12_pin_mode_get(lis2dw12_dev_t *pdev,lis2dw12_pp_od_t *val);

int32_t lis2dw12_pin_int1_route_set(lis2dw12_dev_t *pdev,lis2dw12_ctrl4_int1_pad_ctrl_t *val);
int32_t lis2dw12_pin_int1_route_get(lis2dw12_dev_t *pdev,lis2dw12_ctrl4_int1_pad_ctrl_t *val);

int32_t lis2dw12_pin_int2_route_set(lis2dw12_dev_t *pdev,lis2dw12_ctrl5_int2_pad_ctrl_t *val);
int32_t lis2dw12_pin_int2_route_get(lis2dw12_dev_t *pdev,lis2dw12_ctrl5_int2_pad_ctrl_t *val);

int32_t lis2dw12_all_on_int1_set(lis2dw12_dev_t *pdev, uint8_t val);
int32_t lis2dw12_all_on_int1_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_wkup_threshold_set(lis2dw12_dev_t *pdev, uint8_t val);
int32_t lis2dw12_wkup_threshold_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_wkup_dur_set(lis2dw12_dev_t *pdev, uint8_t val);
int32_t lis2dw12_wkup_dur_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_wkup_feed_data_set(lis2dw12_dev_t *pdev,lis2dw12_usr_offset_on_wakeup_t val);
int32_t lis2dw12_wkup_feed_data_get(lis2dw12_dev_t *pdev,lis2dw12_usr_offset_on_wakeup_t *val);

int32_t lis2dw12_act_mode_set(lis2dw12_dev_t *pdev,lis2dw12_sleep_on_t val);
int32_t lis2dw12_act_mode_get(lis2dw12_dev_t *pdev,lis2dw12_sleep_on_t *val);

int32_t lis2dw12_act_sleep_dur_set(lis2dw12_dev_t *pdev, uint8_t val);
int32_t lis2dw12_act_sleep_dur_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_tap_threshold_x_set(lis2dw12_dev_t *pdev, uint8_t val);
int32_t lis2dw12_tap_threshold_x_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_tap_threshold_y_set(lis2dw12_dev_t *pdev, uint8_t val);
int32_t lis2dw12_tap_threshold_y_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_tap_axis_priority_set(lis2dw12_dev_t *pdev,lis2dw12_tap_prior_t val);
int32_t lis2dw12_tap_axis_priority_get(lis2dw12_dev_t *pdev,lis2dw12_tap_prior_t *val);

int32_t lis2dw12_tap_threshold_z_set(lis2dw12_dev_t *pdev, uint8_t val);
int32_t lis2dw12_tap_threshold_z_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_tap_detection_on_z_set(lis2dw12_dev_t *pdev,uint8_t val);
int32_t lis2dw12_tap_detection_on_z_get(lis2dw12_dev_t *pdev,uint8_t *val);

int32_t lis2dw12_tap_detection_on_y_set(lis2dw12_dev_t *pdev,uint8_t val);
int32_t lis2dw12_tap_detection_on_y_get(lis2dw12_dev_t *pdev,uint8_t *val);

int32_t lis2dw12_tap_detection_on_x_set(lis2dw12_dev_t *pdev,uint8_t val);
int32_t lis2dw12_tap_detection_on_x_get(lis2dw12_dev_t *pdev,uint8_t *val);

int32_t lis2dw12_tap_shock_set(lis2dw12_dev_t *pdev, uint8_t val);
int32_t lis2dw12_tap_shock_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_tap_quiet_set(lis2dw12_dev_t *pdev, uint8_t val);
int32_t lis2dw12_tap_quiet_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_tap_dur_set(lis2dw12_dev_t *pdev, uint8_t val);
int32_t lis2dw12_tap_dur_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_tap_mode_set(lis2dw12_dev_t *pdev,lis2dw12_single_double_tap_t val);
int32_t lis2dw12_tap_mode_get(lis2dw12_dev_t *pdev,lis2dw12_single_double_tap_t *val);

int32_t lis2dw12_tap_src_get(lis2dw12_dev_t *pdev,lis2dw12_tap_src_t *val);

int32_t lis2dw12_6d_threshold_set(lis2dw12_dev_t *pdev, uint8_t val);
int32_t lis2dw12_6d_threshold_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_4d_mode_set(lis2dw12_dev_t *pdev, uint8_t val);
int32_t lis2dw12_4d_mode_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_6d_src_get(lis2dw12_dev_t *pdev,lis2dw12_sixd_src_t *val);

int32_t lis2dw12_6d_feed_data_set(lis2dw12_dev_t *pdev,lis2dw12_lpass_on6d_t val);
int32_t lis2dw12_6d_feed_data_get(lis2dw12_dev_t *pdev,lis2dw12_lpass_on6d_t *val);

int32_t lis2dw12_freefall_dur_set(lis2dw12_dev_t *pdev, uint8_t val);
int32_t lis2dw12_freefall_dur_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_freefall_threshold_set(lis2dw12_dev_t *pdev,lis2dw12_freefall_thsh_t val);
int32_t lis2dw12_freefall_threshold_get(lis2dw12_dev_t *pdev,lis2dw12_freefall_thsh_t *val);

int32_t lis2dw12_fifo_watermark_set(lis2dw12_dev_t *pdev, uint8_t val);
int32_t lis2dw12_fifo_watermark_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_fifo_mode_set(lis2dw12_dev_t *pdev,lis2dw12_fifo_mode_t val);
int32_t lis2dw12_fifo_mode_get(lis2dw12_dev_t *pdev,lis2dw12_fifo_mode_t *val);

int32_t lis2dw12_fifo_data_level_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_fifo_overrun_flag_get(lis2dw12_dev_t *pdev, uint8_t *val);

int32_t lis2dw12_fifo_wtm_flag_get(lis2dw12_dev_t *pdev, uint8_t *val);


#endif