source [file join [file dirname [info script]] ./../../../ip/system/system_pio_2/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_pio_3/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_pio_0/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_pio_1/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_timer_0/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_intel_onchip_memory_0/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_i2c_0/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_iopll_1/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_sysid_qsys_0/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_iopll_0/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../vvp_system/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_pio_5/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_pio_4/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_reset_in/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_reset_in_0/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_intel_niosv_g_0/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_jtag_uart_0/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_clock_in/sim/common/modelsim_files.tcl]

namespace eval system {
  proc get_design_libraries {} {
    set libraries [dict create]
    set libraries [dict merge $libraries [system_pio_2::get_design_libraries]]
    set libraries [dict merge $libraries [system_pio_3::get_design_libraries]]
    set libraries [dict merge $libraries [system_pio_0::get_design_libraries]]
    set libraries [dict merge $libraries [system_pio_1::get_design_libraries]]
    set libraries [dict merge $libraries [system_timer_0::get_design_libraries]]
    set libraries [dict merge $libraries [system_intel_onchip_memory_0::get_design_libraries]]
    set libraries [dict merge $libraries [system_i2c_0::get_design_libraries]]
    set libraries [dict merge $libraries [system_iopll_1::get_design_libraries]]
    set libraries [dict merge $libraries [system_sysid_qsys_0::get_design_libraries]]
    set libraries [dict merge $libraries [system_iopll_0::get_design_libraries]]
    set libraries [dict merge $libraries [vvp_system::get_design_libraries]]
    set libraries [dict merge $libraries [system_pio_5::get_design_libraries]]
    set libraries [dict merge $libraries [system_pio_4::get_design_libraries]]
    set libraries [dict merge $libraries [system_reset_in::get_design_libraries]]
    set libraries [dict merge $libraries [system_reset_in_0::get_design_libraries]]
    set libraries [dict merge $libraries [system_intel_niosv_g_0::get_design_libraries]]
    set libraries [dict merge $libraries [system_jtag_uart_0::get_design_libraries]]
    set libraries [dict merge $libraries [system_clock_in::get_design_libraries]]
    dict set libraries altera_merlin_axi_translator_1981    1
    dict set libraries altera_merlin_slave_translator_191   1
    dict set libraries altera_merlin_axi_master_ni_19112    1
    dict set libraries altera_merlin_slave_agent_1930       1
    dict set libraries altera_avalon_sc_fifo_1932           1
    dict set libraries altera_merlin_router_1921            1
    dict set libraries altera_merlin_traffic_limiter_1921   1
    dict set libraries altera_avalon_st_pipeline_stage_1930 1
    dict set libraries altera_merlin_burst_adapter_1940     1
    dict set libraries altera_merlin_demultiplexer_1921     1
    dict set libraries altera_merlin_multiplexer_1922       1
    dict set libraries altera_mm_interconnect_1920          1
    dict set libraries altera_irq_mapper_2001               1
    dict set libraries altera_reset_controller_1924         1
    dict set libraries system                               1
    return $libraries
  }
  
  proc get_memory_files {QSYS_SIMDIR QUARTUS_INSTALL_DIR} {
    set memory_files [list]
    set memory_files [concat $memory_files [system_pio_2::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_pio_2/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_pio_3::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_pio_3/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_pio_0::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_pio_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_pio_1::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_pio_1/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_timer_0::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_timer_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_intel_onchip_memory_0::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_intel_onchip_memory_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_i2c_0::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_i2c_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_iopll_1::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_iopll_1/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_sysid_qsys_0::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_sysid_qsys_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_iopll_0::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_iopll_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [vvp_system::get_memory_files "$QSYS_SIMDIR/../../vvp_system/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_pio_5::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_pio_5/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_pio_4::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_pio_4/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_reset_in::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_reset_in/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_reset_in_0::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_reset_in_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_intel_niosv_g_0::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_intel_niosv_g_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_jtag_uart_0::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_jtag_uart_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_clock_in::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_clock_in/sim/" "$QUARTUS_INSTALL_DIR"]]
    return $memory_files
  }
  
  proc get_common_design_files {QSYS_SIMDIR} {
    set design_files [dict create]
    set design_files [dict merge $design_files [system_pio_2::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_pio_2/sim/"]]
    set design_files [dict merge $design_files [system_pio_3::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_pio_3/sim/"]]
    set design_files [dict merge $design_files [system_pio_0::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_pio_0/sim/"]]
    set design_files [dict merge $design_files [system_pio_1::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_pio_1/sim/"]]
    set design_files [dict merge $design_files [system_timer_0::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_timer_0/sim/"]]
    set design_files [dict merge $design_files [system_intel_onchip_memory_0::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_intel_onchip_memory_0/sim/"]]
    set design_files [dict merge $design_files [system_i2c_0::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_i2c_0/sim/"]]
    set design_files [dict merge $design_files [system_iopll_1::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_iopll_1/sim/"]]
    set design_files [dict merge $design_files [system_sysid_qsys_0::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_sysid_qsys_0/sim/"]]
    set design_files [dict merge $design_files [system_iopll_0::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_iopll_0/sim/"]]
    set design_files [dict merge $design_files [vvp_system::get_common_design_files "$QSYS_SIMDIR/../../vvp_system/sim/"]]
    set design_files [dict merge $design_files [system_pio_5::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_pio_5/sim/"]]
    set design_files [dict merge $design_files [system_pio_4::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_pio_4/sim/"]]
    set design_files [dict merge $design_files [system_reset_in::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_reset_in/sim/"]]
    set design_files [dict merge $design_files [system_reset_in_0::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_reset_in_0/sim/"]]
    set design_files [dict merge $design_files [system_intel_niosv_g_0::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_intel_niosv_g_0/sim/"]]
    set design_files [dict merge $design_files [system_jtag_uart_0::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_jtag_uart_0/sim/"]]
    set design_files [dict merge $design_files [system_clock_in::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_clock_in/sim/"]]
    return $design_files
  }
  
  proc get_design_files {QSYS_SIMDIR QUARTUS_INSTALL_DIR} {
    set design_files [list]
    set design_files [concat $design_files [system_pio_2::get_design_files "$QSYS_SIMDIR/../../ip/system/system_pio_2/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_pio_3::get_design_files "$QSYS_SIMDIR/../../ip/system/system_pio_3/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_pio_0::get_design_files "$QSYS_SIMDIR/../../ip/system/system_pio_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_pio_1::get_design_files "$QSYS_SIMDIR/../../ip/system/system_pio_1/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_timer_0::get_design_files "$QSYS_SIMDIR/../../ip/system/system_timer_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_intel_onchip_memory_0::get_design_files "$QSYS_SIMDIR/../../ip/system/system_intel_onchip_memory_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_i2c_0::get_design_files "$QSYS_SIMDIR/../../ip/system/system_i2c_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_iopll_1::get_design_files "$QSYS_SIMDIR/../../ip/system/system_iopll_1/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_sysid_qsys_0::get_design_files "$QSYS_SIMDIR/../../ip/system/system_sysid_qsys_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_iopll_0::get_design_files "$QSYS_SIMDIR/../../ip/system/system_iopll_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [vvp_system::get_design_files "$QSYS_SIMDIR/../../vvp_system/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_pio_5::get_design_files "$QSYS_SIMDIR/../../ip/system/system_pio_5/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_pio_4::get_design_files "$QSYS_SIMDIR/../../ip/system/system_pio_4/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_reset_in::get_design_files "$QSYS_SIMDIR/../../ip/system/system_reset_in/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_reset_in_0::get_design_files "$QSYS_SIMDIR/../../ip/system/system_reset_in_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_intel_niosv_g_0::get_design_files "$QSYS_SIMDIR/../../ip/system/system_intel_niosv_g_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_jtag_uart_0::get_design_files "$QSYS_SIMDIR/../../ip/system/system_jtag_uart_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_clock_in::get_design_files "$QSYS_SIMDIR/../../ip/system/system_clock_in/sim/" "$QUARTUS_INSTALL_DIR"]]
    lappend design_files "-makelib altera_merlin_axi_translator_1981 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_translator_1981/sim/system_altera_merlin_axi_translator_1981_d6vgxmy.sv"]\"   -end"                            
    lappend design_files "-makelib altera_merlin_slave_translator_191 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_slave_translator_191/sim/system_altera_merlin_slave_translator_191_xg7rzxi.sv"]\"   -end"                         
    lappend design_files "-makelib altera_merlin_axi_master_ni_19112 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_master_ni_19112/sim/altera_merlin_address_alignment.sv"]\"   -end"                                             
    lappend design_files "-makelib altera_merlin_axi_master_ni_19112 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_master_ni_19112/sim/system_altera_merlin_axi_master_ni_19112_2jrcixq.sv"]\"   -end"                            
    lappend design_files "-makelib altera_merlin_slave_agent_1930 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_slave_agent_1930/sim/system_altera_merlin_slave_agent_1930_jxauz3i.sv"]\"   -end"                                     
    lappend design_files "-makelib altera_merlin_slave_agent_1930 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_slave_agent_1930/sim/altera_merlin_burst_uncompressor.sv"]\"   -end"                                                  
    lappend design_files "-makelib altera_avalon_sc_fifo_1932 \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_sc_fifo_1932/sim/system_altera_avalon_sc_fifo_1932_22gxxgi.v"]\"   -end"                                                  
    lappend design_files "-makelib altera_merlin_router_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/system_altera_merlin_router_1921_msn2duq.sv"]\"   -end"                                                    
    lappend design_files "-makelib altera_merlin_router_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/system_altera_merlin_router_1921_2sn5mzy.sv"]\"   -end"                                                    
    lappend design_files "-makelib altera_merlin_router_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/system_altera_merlin_router_1921_b474yva.sv"]\"   -end"                                                    
    lappend design_files "-makelib altera_merlin_router_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/system_altera_merlin_router_1921_jc4kquq.sv"]\"   -end"                                                    
    lappend design_files "-makelib altera_merlin_traffic_limiter_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/system_altera_merlin_traffic_limiter_altera_avalon_sc_fifo_1921_te3kfhq.v"]\"   -end"    
    lappend design_files "-makelib altera_merlin_traffic_limiter_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/altera_merlin_reorder_memory.sv"]\"   -end"                                              
    lappend design_files "-makelib altera_merlin_traffic_limiter_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/altera_avalon_st_pipeline_base.v"]\"   -end"                                             
    lappend design_files "-makelib altera_merlin_traffic_limiter_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/system_altera_merlin_traffic_limiter_1921_5pm4apa.sv"]\"   -end"                         
    lappend design_files "-makelib altera_avalon_st_pipeline_stage_1930 \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_st_pipeline_stage_1930/sim/system_altera_avalon_st_pipeline_stage_1930_oiupeiq.sv"]\"   -end"                   
    lappend design_files "-makelib altera_avalon_st_pipeline_stage_1930 \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_st_pipeline_stage_1930/sim/altera_avalon_st_pipeline_base.v"]\"   -end"                                         
    lappend design_files "-makelib altera_merlin_burst_adapter_1940 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_burst_adapter_1940/sim/system_altera_merlin_burst_adapter_altera_avalon_st_pipeline_stage_1940_uacegay.v"]\"   -end"
    lappend design_files "-makelib altera_merlin_burst_adapter_1940 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_burst_adapter_1940/sim/system_altera_merlin_burst_adapter_1940_ud3zdoi.sv"]\"   -end"                               
    lappend design_files "-makelib altera_merlin_burst_adapter_1940 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_burst_adapter_1940/sim/altera_merlin_burst_adapter_uncmpr.sv"]\"   -end"                                            
    lappend design_files "-makelib altera_merlin_burst_adapter_1940 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_burst_adapter_1940/sim/altera_merlin_burst_adapter_13_1.sv"]\"   -end"                                              
    lappend design_files "-makelib altera_merlin_burst_adapter_1940 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_burst_adapter_1940/sim/altera_merlin_burst_adapter_new.sv"]\"   -end"                                               
    lappend design_files "-makelib altera_merlin_burst_adapter_1940 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_burst_adapter_1940/sim/altera_incr_burst_converter.sv"]\"   -end"                                                   
    lappend design_files "-makelib altera_merlin_burst_adapter_1940 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_burst_adapter_1940/sim/altera_wrap_burst_converter.sv"]\"   -end"                                                   
    lappend design_files "-makelib altera_merlin_burst_adapter_1940 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_burst_adapter_1940/sim/altera_default_burst_converter.sv"]\"   -end"                                                
    lappend design_files "-makelib altera_merlin_burst_adapter_1940 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_burst_adapter_1940/sim/altera_merlin_address_alignment.sv"]\"   -end"                                               
    lappend design_files "-makelib altera_merlin_demultiplexer_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/system_altera_merlin_demultiplexer_1921_4lqkvty.sv"]\"   -end"                               
    lappend design_files "-makelib altera_merlin_demultiplexer_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/system_altera_merlin_demultiplexer_1921_ner7txy.sv"]\"   -end"                               
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/system_altera_merlin_multiplexer_1922_p7s7ejy.sv"]\"   -end"                                     
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"   -end"                                                          
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/system_altera_merlin_multiplexer_1922_yd3cc2a.sv"]\"   -end"                                     
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"   -end"                                                          
    lappend design_files "-makelib altera_merlin_demultiplexer_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/system_altera_merlin_demultiplexer_1921_gzzvvlq.sv"]\"   -end"                               
    lappend design_files "-makelib altera_merlin_demultiplexer_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/system_altera_merlin_demultiplexer_1921_vmr3mli.sv"]\"   -end"                               
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/system_altera_merlin_multiplexer_1922_ae4rffy.sv"]\"   -end"                                     
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"   -end"                                                          
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/system_altera_merlin_multiplexer_1922_ip4y54q.sv"]\"   -end"                                     
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"   -end"                                                          
    lappend design_files "-makelib altera_mm_interconnect_1920 \"[normalize_path "$QSYS_SIMDIR/../altera_mm_interconnect_1920/sim/system_altera_mm_interconnect_1920_e2mwh5q.v"]\"   -end"                                               
    lappend design_files "-makelib altera_irq_mapper_2001 \"[normalize_path "$QSYS_SIMDIR/../altera_irq_mapper_2001/sim/system_altera_irq_mapper_2001_xbnlxwy.sv"]\"   -end"                                                             
    lappend design_files "-makelib altera_reset_controller_1924 \"[normalize_path "$QSYS_SIMDIR/../altera_reset_controller_1924/sim/altera_reset_controller.v"]\"   -end"                                                                
    lappend design_files "-makelib altera_reset_controller_1924 \"[normalize_path "$QSYS_SIMDIR/../altera_reset_controller_1924/sim/altera_reset_synchronizer.v"]\"   -end"                                                              
    lappend design_files "-makelib system \"[normalize_path "$QSYS_SIMDIR/system.v"]\"   -end"                                                                                                                                           
    return $design_files
  }
  
  proc get_non_duplicate_elab_option {ELAB_OPTIONS NEW_ELAB_OPTION} {
    set IS_DUPLICATE [string first $NEW_ELAB_OPTION $ELAB_OPTIONS]
    if {$IS_DUPLICATE == -1} {
      return $NEW_ELAB_OPTION
    } else {
      return ""
    }
  }
  
  
  proc get_elab_options {SIMULATOR_TOOL_BITNESS} {
    set ELAB_OPTIONS ""
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_pio_2::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_pio_3::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_pio_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_pio_1::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_timer_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_intel_onchip_memory_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_i2c_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_iopll_1::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_sysid_qsys_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_iopll_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [vvp_system::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_pio_5::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_pio_4::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_reset_in::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_reset_in_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_intel_niosv_g_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_jtag_uart_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_clock_in::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ELAB_OPTIONS
  }
  
  
  proc get_sim_options {SIMULATOR_TOOL_BITNESS} {
    set SIM_OPTIONS ""
    append SIM_OPTIONS [system_pio_2::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_pio_3::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_pio_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_pio_1::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_timer_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_intel_onchip_memory_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_i2c_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_iopll_1::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_sysid_qsys_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_iopll_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [vvp_system::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_pio_5::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_pio_4::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_reset_in::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_reset_in_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_intel_niosv_g_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_jtag_uart_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_clock_in::get_sim_options $SIMULATOR_TOOL_BITNESS]
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $SIM_OPTIONS
  }
  
  
  proc get_env_variables {SIMULATOR_TOOL_BITNESS} {
    set ENV_VARIABLES [dict create]
    set LD_LIBRARY_PATH [dict create]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_pio_2::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_pio_3::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_pio_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_pio_1::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_timer_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_intel_onchip_memory_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_i2c_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_iopll_1::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_sysid_qsys_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_iopll_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [vvp_system::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_pio_5::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_pio_4::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_reset_in::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_reset_in_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_intel_niosv_g_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_jtag_uart_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_clock_in::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    dict set ENV_VARIABLES "LD_LIBRARY_PATH" $LD_LIBRARY_PATH
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ENV_VARIABLES
  }
  
  
  proc normalize_path {FILEPATH} {
      if {[catch { package require fileutil } err]} { 
          return $FILEPATH 
      } 
      set path [fileutil::lexnormalize [file join [pwd] $FILEPATH]]  
      if {[file pathtype $FILEPATH] eq "relative"} { 
          set path [fileutil::relative [pwd] $path] 
      } 
      return $path 
  } 
  proc get_dpi_libraries {QSYS_SIMDIR} {
    set libraries [dict create]
    set libraries [dict merge $libraries [system_pio_2::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_pio_2/sim/"]]
    set libraries [dict merge $libraries [system_pio_3::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_pio_3/sim/"]]
    set libraries [dict merge $libraries [system_pio_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_pio_0/sim/"]]
    set libraries [dict merge $libraries [system_pio_1::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_pio_1/sim/"]]
    set libraries [dict merge $libraries [system_timer_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_timer_0/sim/"]]
    set libraries [dict merge $libraries [system_intel_onchip_memory_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_intel_onchip_memory_0/sim/"]]
    set libraries [dict merge $libraries [system_i2c_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_i2c_0/sim/"]]
    set libraries [dict merge $libraries [system_iopll_1::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_iopll_1/sim/"]]
    set libraries [dict merge $libraries [system_sysid_qsys_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_sysid_qsys_0/sim/"]]
    set libraries [dict merge $libraries [system_iopll_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_iopll_0/sim/"]]
    set libraries [dict merge $libraries [vvp_system::get_dpi_libraries "$QSYS_SIMDIR/../../vvp_system/sim/"]]
    set libraries [dict merge $libraries [system_pio_5::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_pio_5/sim/"]]
    set libraries [dict merge $libraries [system_pio_4::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_pio_4/sim/"]]
    set libraries [dict merge $libraries [system_reset_in::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_reset_in/sim/"]]
    set libraries [dict merge $libraries [system_reset_in_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_reset_in_0/sim/"]]
    set libraries [dict merge $libraries [system_intel_niosv_g_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_intel_niosv_g_0/sim/"]]
    set libraries [dict merge $libraries [system_jtag_uart_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_jtag_uart_0/sim/"]]
    set libraries [dict merge $libraries [system_clock_in::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_clock_in/sim/"]]
    
    return $libraries
  }
  
}
