/*
 * VPP_TPG.h
 *
 *  Created on: Aug 23, 2024
 *      Author: User
 */

#ifndef VVP_TPG_H_
#define VVP_TPG_H_


#include <stdint.h>
#include <stdbool.h>
#include "intel_vvp_tpg_regs.h"
#include "intel_vvp_tpg.h"
#include "VVP_CORE.h"

// https://www.intel.com/content/www/us/en/docs/programmable/683329/24-2/test-pattern-generator-ip-registers.html
#define TPG_IMG_INFO_WIDTH			0x0120
#define TPG_IMG_INFO_HEIGHT			0x0124
#define TPG_IMG_INFO_INTERLACE		0x0128
#define TPG_STATUS					0x0140 //RO (read only)
#define TPG_FIELD_COUNT				0x0144 //RO
#define TPG_CONTROL					0x0148
#define TPG_COMMIT					0x014c
#define TPG_PATTERN_SELECT			0x0150

#define TPG_C0						0x015c
#define TPG_C1						0x0160
#define TPG_C2						0x0164
#define TPG_BARS_SELECT				0x0168
#define TPG_ZONE_X_ORIGIN			0x016c
#define TPG_ZONE_Y_ORIGIN			0x0170
#define TPG_ZONE_COARSE_FACTOR		0x0174 //Intel suggests a value of 14 for 1920x1080, or 20 for a 4k display.
#define TPG_ZONE_FINE_FACTOR		0x0178
#define TPG_CLOCK_B_BACKGROUND		0x017C
#define TPG_CLOCK_G_BACKGROUND		0x0180
#define TPG_CLOCK_R_BACKGROUND		0x0184
#define TPG_CLOCK_B_FONT			0x0188
#define TPG_CLOCK_G_FONT			0x018C
#define TPG_CLOCK_R_FONT			0x0190
#define TPG_CLOCK_LOCATION_X		0x0194
#define TPG_CLOCK_LOCATION_Y		0x0198
#define TPG_CLOCK_SCALE_FACTOR		0x019C
#define TPG_CLOCK_FPS				0x01A0
// more...

class VVP_TPG : public VVP_CORE {
	intel_vvp_tpg_instance  m_instance;
public:
	VVP_TPG(uint32_t BaseAddr);
	virtual ~VVP_TPG();

	bool IsLiteMode();
	void ShowStatus();
	bool Run(bool Start=true);
	bool Config(int nWidth=1920, int nHeight = 1080);
};

#endif /* VVP_TPG_H_ */
