/*
 * VVP_SW.h
 *
 *  Created on: Aug 23, 2024
 *      Author: User
 */

#ifndef VVP_SW_H_
#define VVP_SW_H_

#include <stdint.h>
#include <stdbool.h>
#include "intel_vvp_switch_regs.h"
#include "intel_vvp_switch.h"
#include "VVP_Core.h"

#define SW_LITE_MODE			0x0008

class VVP_SW : public VVP_CORE {
protected:
	intel_vvp_switch_instance  m_instance;
	int m_nInputChannel;
	int m_nOutputChannel;
public:
	VVP_SW(uint32_t BaseAddr);
	virtual ~VVP_SW();

	bool IsLiteMode();
	void ShowStatus();
	bool Config(int nInputChannel, int nOutputChannel=0);
};

#endif /* VVP_SW_H_ */
