/*
 * VVP_SW.cpp
 *
 *  Created on: Aug 23, 2024
 *      Author: Richard
 */

#include <stdio.h>
#include <stdlib.h> // malloc, free
#include <unistd.h>  // usleep (unix standard?)
#include "system.h"
#include "io.h"
#include "VVP_SW.h"


VVP_SW::VVP_SW(uint32_t BaseAddr):
		VVP_CORE(BaseAddr),
//		m_BaseAddr(BaseAddr),
	//	m_bValidInstance(false),
		m_nInputChannel(0),
		m_nOutputChannel(0)
		{
	// TODO Auto-generated destructor stub
	int result;
	result =  intel_vvp_switch_init(&m_instance, (intel_vvp_core_base)BaseAddr);
	if (result != 0){
		printf("intel_vvp_switch_init failed\r\n");
	}else{
		m_bValidInstance = true;
	}
}

VVP_SW::~VVP_SW() {
	// TODO Auto-generated destructor stub
}

bool VVP_SW::IsLiteMode(){
	bool bYes;
	uint32_t  value32;

	if (!m_bValidInstance){
		printf("TPG invalid instance\r\n");
		return false;
	}
#if 0
	bYes = intel_vvp_switch_get_lite_mode(&m_instance);
#else
	//value32 = INTEL_VVP_SWITCH_REG_IORD(&m_instance, SW_LITE_MODE);
	value32 = IORD_32DIRECT(m_BaseAddr, SW_LITE_MODE);
	bYes = (value32 & 0x01)?true:false;
#endif
	return bYes;
}

void VVP_SW::ShowStatus(){
	bool bYes, bRunning;
	uint32_t  value32;
	uint8_t value8;
	int result;

	if (!m_bValidInstance){
		printf("SW invalid instance\r\n");
		return;
	}

	printf("=========== Switch Status =============\r\n");


	// read status
	bYes = intel_vvp_switch_get_commit_status(&m_instance);
	printf("SW vvp intel_vvp_switch_get_commit_status: %s\r\n", bYes?"in full mode":"contains uncommitted write");

	bYes = intel_vvp_switch_is_running(&m_instance);
	printf("SW vvp switch: %s\r\n", bYes?"running":"stop");

	value32 = intel_vvp_switch_get_status(&m_instance);
	printf("SW intel_vvp_switch_get_status = %xh\r\n", value32);

	value8 = intel_vvp_switch_get_num_inputs(&m_instance);
	printf("SW intel_vvp_switch_get_num_inputs = %d\r\n", value8);

	value8 = intel_vvp_switch_get_num_outputs(&m_instance);
	printf("SW intel_vvp_switch_get_num_outputs = %d\r\n", value8);

	result = intel_vvp_switch_get_input_config(&m_instance, m_nInputChannel);
	printf("SW intel_vvp_switch_get_input_config for input port %d: %d (0: disabled; 1: enabled; 3 consumed) \r\n", m_nInputChannel, result);

	result = intel_vvp_switch_get_output_config(&m_instance, m_nOutputChannel);
	printf("SW intel_vvp_switch_get_output_config for output port %d: %d (-1 if disable) \r\n", m_nOutputChannel, result);


#if 0
	//
	result = intel_vvp_switch_set_input_config(&instance, nActiveChannel, kIntelVvpSwitchInputEnabled); // kIntelVvpSwitchInputConsumed
	if (result != 0)
		printf("intel_vvp_switch_set_input_config failed\r\n");

#endif

	printf("\r\n");

}

bool VVP_SW::Config(int nInputChannel, int nOutputChannel){
// software API: https://www.intel.com/content/www/us/en/docs/programmable/683329/23-1/switch-ip-software-api.html
	int result;
	bool bRunning, bPass, bSuccess = true;
	uint32_t  status;

	if (!m_bValidInstance){
		printf("SW invalid instance\r\n");
		return false;
	}

	///////////////////
	// config
	result = intel_vvp_switch_set_input_config(&m_instance, nInputChannel, kIntelVvpSwitchInputEnabled);//kIntelVvpSwitchInputConsumed);//kIntelVvpSwitchInputEnabled); //kIntelVvpSwitchInputConsumed
	if (result != kIntelVvpCoreOk)
		bSuccess = false;
	//printf("SW intel_vvp_switch_set_input_config %s\r\n", bSuccess?"success":"failed");



	if (bSuccess){
		result = intel_vvp_switch_set_output_config(&m_instance, nOutputChannel, true /* enable */ , nInputChannel);
		if (result != kIntelVvpCoreOk)
			bSuccess = false;
		//printf("SW intel_vvp_switch_set_output_config %s\r\n", bSuccess?"success":"failed");
	}



	if (bSuccess){
		result = intel_vvp_switch_commit_writes(&m_instance);
		if (result != kIntelVvpCoreOk)
			bSuccess = false;
		//printf("SW intel_vvp_switch_commit_writes %s\r\n", bSuccess?"success":"failed");
	//	usleep(2*1000*1000);
	}

	if (bSuccess){
		m_nInputChannel = nInputChannel;
		m_nOutputChannel = nOutputChannel;
	}



	return bSuccess;
}


