/*
 * VVP_Demosaic.h
 *
 *  Created on: Aug 23, 2024
 *      Author: User
 */


#ifndef VVP_DEMOSAIC_H_
#define VVP_DEMOSAIC_H_

#include <stdint.h>
#include <stdbool.h>
#include "intel_vvp_demosaic_regs.h"
#include "intel_vvp_demosaic.h"
#include "VVP_Core.h"


#define DEMOSAIC_IMG_INFO_WIDTH	    0x0120
#define DEMOSAIC_IMG_INFO_HEIGHT	0x0124
#define DEMOSAIC_STATUS				0x0140
#define DEMOSAIC_FRAME_STAT			0x0144
#define DEMOSAIC_CONTROL			0x014C

class VVP_Demosaic : public VVP_CORE {
	intel_vvp_demosaic_instance  m_instance;
public:
	VVP_Demosaic(uint32_t BaseAddr);
	virtual ~VVP_Demosaic();

	bool IsLiteMode();
	void ShowStatus();
	bool Run(bool Start = true, int color_filter_index=0);
	bool Config(int nWidth=1920, int nHeight = 1080);
};

#endif /* VVP_DEMOSAIC_H_ */
