// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



import dphy_pkg::*;


module dphy_pcs_data_timing_rx # (
        parameter DIN_PIPE_DEPTH = 2
   ) (
        input wire   rx_clk, 
        input wire   srst_rx_n,
        input wire   arst_rx_n, 
        input wire   fr_clk,
        input wire   srst_fr_n, 
        input wire   fr_clk_1024,
        input wire   enable,
        input wire   is_ulps,
        input wire   ulps_wake_cnt, 
        
        input wire   lpctrl_hs_req_fr,
        input wire   lpctrl_hs_stop_fr,
        input wire   lpctrl_hs_diff_fr,
        input wire   lpctrl_lp_req_fr,
        input wire   fast_stop,

        input [7:0]  t_hs_settle, 
        input [7:0]  t_hs_skip, 
        input [7:0]  t_init,
        input [7:0]  t_wake_ulps,

        output logic ulps_wake_done,
        output logic init_done,
        output logic din_valid           

    );
    
    localparam FR_TIMER_WIDTH = 16;
    localparam DIN_VALID_PIPE_LEN = DIN_PIPE_DEPTH > 2 ? DIN_PIPE_DEPTH - 2 : 0;
    
   logic             fr_ld_timer;   
   logic [FR_TIMER_WIDTH-1:0] fr_ld_val; 
   logic                      fr_timer_out;
   
   logic                      din_valid_fr;
   logic                      din_valid_rx;
   logic                      din_valid_int;
   logic                      fast_stop_rx;
   logic                      enable_q;


   
   
   assign ulps_wake_done = is_ulps & fr_timer_out;
    
    always @(posedge fr_clk)
    begin
        if(srst_fr_n == 1'b0)
        begin
                din_valid_fr <= 1'b0;
                init_done <= 1'b0;
                enable_q <= 1'b0;
        end
        else 
        begin
            din_valid_fr <= (init_done & fr_timer_out) | (din_valid_fr & lpctrl_hs_diff_fr);
            init_done <= ( init_done & ( enable === 1'b1) )  | (fr_timer_out === 1'b1);
            enable_q <= enable;
        end
    end

    assign fr_timer_en = (init_done == 1'b0) || (ulps_wake_cnt == 1'b1) ? fr_clk_1024 : lpctrl_hs_diff_fr;
    assign fr_ld_timer = init_done == 1'b1 ? ( is_ulps == 1'b1 ? ~ulps_wake_cnt : lpctrl_hs_req_fr ) : lpctrl_hs_stop_fr === 1'b1 && enable_q === 1'b1 ? 1'b0 : 1'b1;
    assign fr_ld_val = init_done == 1'b1 ? (is_ulps == 1'b1 ? { 8'h0, t_wake_ulps } : { 8'h0, t_hs_settle }) : { 8'h0, t_init }  ;

    dphy_timer #(
        .WIDTH(FR_TIMER_WIDTH)
   ) rx_timer_fr
   (
        .clk(fr_clk),     
        .srst_n(srst_fr_n),     
        .timer_en(fr_timer_en), 
        .ld_timer(fr_ld_timer),   
        .ld_val(fr_ld_val), 
        .timer_out(fr_timer_out)   
    );

    altera_std_synchronizer_nocut # (
        .depth(3)
    ) cdc_sync_din_valid (
        .clk(rx_clk),
        .reset_n(arst_rx_n),
        .din(din_valid_fr),
        .dout(din_valid_rx)
    );

    altera_std_synchronizer_nocut # (
        .depth(3)
    ) cdc_sync_fast_stop (
        .clk(rx_clk),
        .reset_n(arst_rx_n),
        .din(fast_stop),
        .dout(fast_stop_rx)
    );

    assign din_valid_int = din_valid_rx & ~fast_stop_rx;
    hyperpipe # (.WIDTH(1), .CYCLES(DIN_VALID_PIPE_LEN)) din_valid_pipe (.clk(rx_clk), .din(din_valid_int), .dout(din_valid) );

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "k1LH1RcWqBqQ76v8cfULmmlV9sW1nnbJaS2wcLgqGwqBhLWK73DmouWbV7pbibS7IH130sZk+lXZ9U2UpRjei+a4GXqGhMMc9IMzMkgIDLbmlHj0N0nMSI9TMo4z5CKT4okwkd1gkpoJ98r//fD7kKG+O0v6X7LJGK2BQC+3s5gBj2lSsro8UaDW99uGAXd1ozPUFOiI9DO+P2Bl903Ke20T6b0d5clKKvtf117o8GlNyjFSdUvcb2lGG8Z1R5RQTgOaZqHFG+z+YsdhVJfq/n+BXaJoo041hFli2ZgreiRq5lJmcK5gjvXB1AsGudeM8UZoZ3JoDciiTl4TKFJnwOm6pDDadI6zvN5EGzKUQMvjKf6WRnMT1uBY5f6PFvRuLAGwouAwEX5790eHSa7fZcrzC0+upByh8WJlk1z+EhhyyY735/x5SY90+VlVX9UHawUFpcrgPgr0rJFilGUTMdyCyeysXcT4ED9ZN0CL7fJInYnCg3sst6g+rVweHXq48zxSrClfCyI33I8CjWsohYFUTbEvuB/SLSOOk43814DFe+QuzFc9LXuvyJMttOE/RLYkJJ11QUvxn0CjozWiEWobjo+SDq4ZCNGoHvvMU2l4t2/Dqg+oEtUvm63QBYG6O4lxgqE1LSwDQtExPUchIVcPSXPzY6Yic4PeUw7DkXg+GfKg8L3shBvSCndh4nP3aft26h7IQ9Ssi7ZsuacLZzuQJt17BNSySYBbWF1idJHjzduK+/MF16nKr8Tlx64D+nlxMSbU3dCkx6GtfNHzj7oIfqwf67FsKqnrW7VyH7MsYPZO6P+3FNqY/MDr1ZblII69CJaTe1eLbB2m3nMMniamNUtInMF99R6cTJHeiRZer95umoU+IJSvyyGG8UYwjQfD/6gInW9sm8Z/bUL6vWyTjelcyHrfECZ8/AlI+By2a9U4R+1t4E947awpi0zwXt+doqif+k+tgtYL2EVtRNR94mZ9kFmxuegAJGxn5kyUfWG87TIoH9WFqEXb/HTr"
`endif