// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.





// synthesis translate_off   

`ifdef DPHY_BHV_SIM
`define BHV_CPA 1
`endif

`ifdef BHV_CPA
`define cpa_name dphy_cpa_bhv
`endif

`define SIM 1

// synthesis translate_on

`ifndef cpa_name
`define cpa_name tennm_clkgen
`endif

module dphy_cpa_wrap #(
    parameter CPA_ID = 0,
    parameter PHY_CLK_DIV = 1,
    parameter VCO_CLK_DIV_EXPONENT = 2,
    parameter VCO_CLK_FREQ = 36'h00000000
) ( 
    input  wire            i_core_clk_in,                  
    input  wire            i_phyclk,                       
    input  wire            i_phyclk_sync,                  
    output logic           o_core_clk_out,                 
    input  wire  [7:0]     i_vco8ph,                       
    output logic           o_lock,                         
    input  wire            i_pll_lock                      
);

localparam PROTOCOL_MODE = 1'b0
// synthesis translate_off
                           | 1'b1
// synthesis translate_on
                           ? "PROTOCOL_MODE_NON_EMIF"
                           : "PROTOCOL_MODE_EMIF";

   
    `cpa_name #(
        .base_address( (16'h3<<8) | (16'h1a<<1) | CPA_ID ),
        .feedback_dly_sel( "FEEDBACK_DLY_SEL_DLY_PHY" ),
        .feedback_dly_steps( 7'h00 ),
        .phy_clk_div( PHY_CLK_DIV ),
        .protocol_mode( PROTOCOL_MODE ),
        .vco_clk_div_exponent( VCO_CLK_DIV_EXPONENT ),
        .vco_clk_div_mantissa( 5'h00 ),
        .vco_clk_freq( VCO_CLK_FREQ )
    ) cpa_inst (
        .i_core_clk_in( i_core_clk_in ),                              
        .i_phyclk( i_phyclk ),                                        
        .i_phyclk_sync( i_phyclk_sync ),                              
        .o_core_clk_out( o_core_clk_out ),                            
        .i_vco8ph( i_vco8ph ),                                        
        .o_lock( o_lock ),                                            
        .i_avl_clk(),                                                 
        .i_avl_rst_n(),                                               
        .i_avl_write(),                                               
        .i_avl_read(),                                                
        .i_avl_address(),                                             
        .i_avl_writedata(),                                           
        .o_avl_readdata(  ),                                          
        .i_pll_lock( i_pll_lock )                                     
    );
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5DJczsF9atg9xY2Lu7vRbCWS7BK6nHHaGGZ8cHYYeb24jL9K/PiP9WW+/NTg7OmI+XGUIAyfJ187cb4mrRdDLjM3i8jJlsHt6WcPPEqP/JosRrnp8vxcRnF3wcWIWvyBiKf/nY4xaqnXB6ep7ANhdky3mbGdUeS/nMCt5E+ZFilhZTBRsM7aIbfLQ5dAC0Hd6cSRBSn/E1ZputlRNk7lFRTlNyckl0tcWlIjp7UX61Q9AOnhPX/EJjvaZZ/xmaXTD70IZPtgToVcS0kfAnwtU10j1mML0w/6ycTR8foTG1GaRqtleoSflPZI0/v7ikha5Mw++uNHjcxq1da+rqd+Aq7eM5FB445cRsaHWy6PHm3NFYYXE+m83qpMN4x5uFmCNG8Dt6Ad7SkhSlq27vhq3ybii+X4Jg2OmCMGIjg/ngEW+Bm9lyqd2TUZTz/cJAVQ8aEutR79o9DLUJry3FN4WaSbn+zCcXDtZWkeHRXkqn2q96Zfz9ic7Kmxq+WUyiiMu60y9K/6UBxNDvHqMPvZCmrKbbIkj+WpMw5f61GRekzfh9+vAqhGlE12vRPIJjM6M8pLDY/qAcWtmrtdmloacN2UqOLcvX4ms2iE9U+ZqtRfXHHgdZvtKzar7zwM3wS3OVa/qbz6cFZI1ifLFSxv6cTdqAIiLzbFmUjvlFQdNYMDi/xZNQHaWxaZPlNgNDMWV2IfWzExZsULDXkv5GWZ7e5r948H99yBZh+xrwnuEKHSHuq8HuNT6m6Yct39alITQNGmp/T1VLIeIQxHkrh5F7AM9w79R2D47PHGcYgk8w8e8HZrj7b5NHV+H12gX3I7mfTNW1i0+bP95+v2H+gFOTQdgBod3dYvx47BG8BkJypXAFAxrR7aFKb6E8vdr31nAnPUKLcRrrt3w10P8Fcw2EkBtG68827quPd7tqmR52MC9TBpZ96qkSu4SzKKTCqPuyWY5eo6BvI1QK7xd53flBBBpQkh1hoSqznxU9e4Rq6lFb8p0Qs55TLZ0DDXPU/w"
`endif