// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.





// synthesis translate_off        

`ifdef DPHY_BHV_SIM
`define BHV_OBUF 1
`endif

`ifdef BHV_OBUF
`define obuf_name dphy_obuf_bhv
`endif

`define SIM 1

// synthesis translate_on  


`ifndef obuf_name
`define obuf_name tennm_ph2_io_obuf
`endif

module dphy_obuf_wrap #(
    parameter BYTE_LOC = 0,
    parameter PIN_ID = 0,
    parameter RZQ_ID = "RZQ0",
    parameter TX_CAP_EQ_MODE = 0,
    parameter BIT_RATE = 36'd3200000000, 
    parameter TOGGLE_SPEED = "TOGGLE_SPEED_SLOW"                   
) ( 
    input wire 	inp, 
    input wire 	negbuf_in,
    input wire 	oe, 
    output wire obar,
    output wire posbuf_out,
    output wire outp                            
);

   `obuf_name #(
                .buffer_usage( "REGULAR" ),
                .io_standard( "IO_STANDARD_IOSTD_DPHY" ),
                .usage_mode( "USAGE_MODE_DPHY" ),
                .termination( "TERMINATION_SERIES_45_OHM_CAL" ),
                .rzq_id( RZQ_ID == "RZQ0" ? "RZQ_ID_RZQ0" : "RZQ_ID_RZQ1" ),
                .slew_rate( BIT_RATE < 1500000000 ? "SLEW_RATE_FAST" : "SLEW_RATE_FASTEST"),
                .equalization( TX_CAP_EQ_MODE == 1 ? "EQUALIZATION_2TAPS_MEDIUM_LP" : 
                               TX_CAP_EQ_MODE == 2 ? "EQUALIZATION_2TAPS_HIGH_LP"   :
                               TX_CAP_EQ_MODE == 3 ? "EQUALIZATION_2TAPS_MEDIUM_CZ" : "EQUALIZATION_OFF"),
                .open_drain( "OPEN_DRAIN_OFF" ),
                .toggle_speed( TOGGLE_SPEED ),
                .dynamic_pull_up_enabled( "FALSE" )
    ) obuf_inst (
                 .i( inp ),                                                    
                 .negbuf_in (negbuf_in),
                 .oe( oe ),                                                    
                 .obar(obar),
                 .posbuf_out(posbuf_out),
                 .o( outp )                                                    
                 );
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5DJczsF9atg9xY2Lu7vRbCWS7BK6nHHaGGZ8cHYYeb24jL9K/PiP9WW+/NTg7OmI+XGUIAyfJ187cb4mrRdDLjM3i8jJlsHt6WcPPEqP/JosRrnp8vxcRnF3wcWIWvyBiKf/nY4xaqnXB6ep7ANhdky3mbGdUeS/nMCt5E+ZFilhZTBRsM7aIbfLQ5dAC0Hd6cSRBSn/E1ZputlRNk7lFRTlNyckl0tcWlIjp7UX61TveWlhTuEfcwChJ9bGhJWup4kAA65JKQ7bFhcNXYMqkaP2/2QnEHozgDJRKptxdo8q5DinBN2UXInWAQXiFVbCrVVYRtOUHSNS16thq3x4SzqYVfYBSeJAD1viU4ssyRgW8yt4zOTptICRNbgDpKRUF9wKeq0JEi7v+eB5RLVuNmBU50Jo6AfVV3Fid9AjOOPG0yNaGJCOsYSAzt/rYWoc4E8uKchqquSxqPsyij4HE3G9lWIq1LjKyCkBQn9fzlKAKrxP9hm+vmTZdyaIPTeo6q5YhswqdxBzObKgg0qWsK3IBzVts1N6vslIODIJNAPgu7l+4nY58YZS+qeD5sdCiTdbhE81naHFKjjngUgvP3H3LvMRkpyz8AKxb8dXQpA4LqbwfQrELzZlIEYYXWOqYoYStY6D71pC4ixxscnG6DxtMfDvRF6TJ4SKuT/fxKljlPd4fiWD/OE8uoxIgZbdCjJ9V6z5qBuxnJGrI3u3dMHMpzhxveY3gouh6yLrmc2kL8sNOLRPlosEm+ABpXb3ZAX1HqgLWkAwTjaqf+Y7LH9akVRt6uWr3AbKvBqD18mq4vCYleJOD7OBTb0S+xkiE5F2BsCmBIVUSSO1TX7kh+PM1F1238T8UjSMhHrCGz4e8xAmsu6o1poIwssd/A863DsJvEdXnjNO9h7KPY7fMT56MugzWTnkLjF1oD1Wko4SlkfsffUfpfnt1O/APHVc20P1EfVjjF23nXTYSy/N7haAWTGmPxa/2LfWsDyFXqmG1sLwzLw6GmEhbWMo1Xm1"
`endif