// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.





module dphy_prbs9 #(
        WIDTH = 8,                                  
        LOOKAHEAD = 0                               
        )
(
    input                       clk,
    input                       srst_n,
    input                       enable,
    input                       skip,
    input                       pause,
    input  [8:0]                init_val,
    output logic                out_valid,
    output logic [WIDTH-1:0]    prbs_out,
    output logic [15:0]         prbs_next
);

    logic [8:0] q_0;
    logic [8:0] q_1;
    logic [8:0] q_2;
    logic [8:0] q_3;

    logic [8:0] init_val_int;
    int i;
    logic [8:0] init_val_tmp;
    assign init_val_tmp = 9'h02;   
    
    `ifdef VIP
        always @(*)
        begin
            for (i = 1; i < 9; i++)
                init_val_int[9-i] <= init_val_tmp[i];
            init_val_int[0] <= init_val_tmp[0];
        end
    `else
        assign init_val_int = init_val; 
    `endif

`ifdef DEBUG_ALT_CAL

    logic [WIDTH-1:0] cnt;

    always @(posedge clk)
        begin
            if(enable == 1'b0)
                cnt <= 'hc3;
            else
                cnt <= cnt + 1'b1 + skip;
            prbs_out <= { ~cnt[7:0] , cnt[7:0] };
        end        



`else
    always @(posedge clk)
        out_valid <= enable;
    
    if(WIDTH == 16)
    begin
        
        always @(posedge clk)
        begin
            logic [8:0] q_tmp;
            if(enable == 1'b0)
            begin
                q_tmp = init_val_int;
                q_0 <= q_tmp;
                for(i=0; i<8; i++)
                    q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                q_1 <= q_tmp;
                if(LOOKAHEAD == 1)
                begin
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_2 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_3 <= q_tmp;
                end
            end                                                     
            else
            begin
                if(LOOKAHEAD == 1 && skip == 'b1 && pause == 'b0)
                begin
                    q_tmp = q_3;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_0 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_1 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_2 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_3 <= q_tmp;
                end            
                else if(LOOKAHEAD == 0 && skip == 'b1 && pause == 'b0)
                begin
                    q_tmp = q_1;
                    for(i=0; i<24; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_0 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_1 <= q_tmp;
                end
                else if(LOOKAHEAD == 1 & skip == pause)
                begin
                    q_0 <= q_2;
                    q_1 <= q_3;
                    q_tmp = q_3;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_2 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_3 <= q_tmp;
                    
                end
                else if(LOOKAHEAD == 0 && pause == skip)
                begin
                    q_tmp = q_1;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_0 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_1 <= q_tmp;
                end
		else
		begin
		    q_tmp <= q_tmp;
		    q_0 <= q_0;
		    q_1 <= q_1;
		end
            end
        end
        
        always @(posedge clk)
        begin
        `ifdef VIP
            for (i = 1; i < 9; i++)
            begin
                prbs_out[8-i]    <= q_0[i];
                prbs_out[16-i]   <= q_1[i];
                prbs_next[8-i]   <= (LOOKAHEAD == 1) ? q_2[i] : 'h0;
                prbs_next[16-i]  <= (LOOKAHEAD == 1) ? q_3[i] : 'h0;
            end
        `else
            prbs_out <= { q_1[8:1] , q_0[8:1] };
            prbs_next <= (LOOKAHEAD == 1) ? {  q_3[8:1] , q_2[8:1] } : 'h0;
        `endif
        end

    end
    else
    begin
        always @(posedge clk)
        begin
            logic [8:0] q_tmp;
            if(enable == 1'b0)
            begin
                q_tmp = init_val_int;
                q_0 <= q_tmp;
                if(LOOKAHEAD == 1)
                begin
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_1 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_2 <= q_tmp;
                end                
            end
            else
            begin
                if(LOOKAHEAD == 1 && skip == 'b1 && pause == 'b0)
                begin
                    q_tmp = q_2;
                    q_0 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_1 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_2 <= q_tmp;
                end
                if(LOOKAHEAD == 0 && skip == 'b1 && pause == 'b0)
                begin
                    q_tmp = q_0;
                    for(i=0; i<16; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_0 <= q_tmp;
                end
                else if(LOOKAHEAD == 1 && skip == pause)
                begin
                    q_0 <= q_1;
                    q_tmp = q_2;
                    q_1 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_2 <= q_tmp;
                end 
                else if(LOOKAHEAD == 0 && pause == skip)
                begin
                    q_tmp = q_0;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_0 <= q_tmp;
                end
	       	else
		begin
		    q_tmp <= q_tmp;
		    q_0 <= q_0;
		    q_1 <= q_1;
		end
            end
        end

        always @(posedge clk)
        begin
        `ifdef VIP
            for (i = 1; i < 9; i++)
            begin
                prbs_out[8-i]    <= q_0[i];
                prbs_next[8-i]    <= (LOOKAHEAD == 1) ? q_1[i] : 'h0;
                prbs_next[16-i]   <= (LOOKAHEAD == 1) ? q_2[i] : 'h0;
            end
        `else
            prbs_out <= q_0[8:1];
            prbs_next <= LOOKAHEAD == 1 ? {q_2[8:1], q_1[8:1]} : 'h0;
        `endif
        end

    end

`endif    

 

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "k1LH1RcWqBqQ76v8cfULmmlV9sW1nnbJaS2wcLgqGwqBhLWK73DmouWbV7pbibS7IH130sZk+lXZ9U2UpRjei+a4GXqGhMMc9IMzMkgIDLbmlHj0N0nMSI9TMo4z5CKT4okwkd1gkpoJ98r//fD7kKG+O0v6X7LJGK2BQC+3s5gBj2lSsro8UaDW99uGAXd1ozPUFOiI9DO+P2Bl903Ke20T6b0d5clKKvtf117o8GmGOKshR7i3brLjbBoe56kLTt9V137KAdXjZpsD2Zql2UCoV5EcvxzsNFaV8f/b9xKeyb7nBeMK1XIBeM58Hnoi8rn5EqMASEjbnXmDAMvWrTyLem08qMzC0Zwe17j5ut1oUPQl18nXr9rTH3yjvJdmGKcSs56Ic+7w8Fbr6V52/iN3LKF+qdNLLtoztDC2pUv+Z4hXru0FzgCkDysQ1hEge51ZcvurppU6ooYnWmTKWN9Xar5+LUV5hE5sUeRNmZzJTCIhHF3kZGGfVeZbBuvoaR5/BZTieqy+R7N1v35Qb1eAXd3xfNrX+to7vuZJu96rcL7NRbeffCvbxTUaGk+vuIIhPUEZwBmrahwSuu66g5KdaiE95oEWqg8ukSar++wxvN3cZt2enGWyPDK3/l5CJtT2TnMoeuRaZUdFIZbX5fGNjMH/buxpPROhV5uaDXNXxqAvzjWY8vmGbnP7+GC1ZtS28Pq8w3dyP0+HogjxSIbZG2V5+8tC060zJpnQgs1tLD9/HZg/36GP8EgXsJYekx+S0qHkQere4I30xwza8NRyPqu3q4to8SwKLh0L1HoPg9+TbX94F856SPnW7AxDwIt8ZUPdnB7O1KYYfEorzP51csaSWGAJCkOFw1F6Ec3IaYUo7fF8MaBXxiHj1Hg9/ivY+GXSiRSES1MI5x70GFk16KAw+9HKQHlg0T/MZ1LI8kymGvawX/m0BGzmm/pNHQctzbd/APoprGA6Ycvp5a6q3eNVKYJZtNJA5bzeYPuD5gv6h80Y79ZG33HeInRL"
`endif