// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




import dphy_pkg::*;
module dphy_pcx_tx #(        
	parameter IO_CONVERT_RATIO = 16,     
	parameter VCO_FREQ_MULT = 1,     
	parameter NUM_LANES = 4,                                    
    parameter SKEW_CAL_EN = 1,                                  
    parameter SKEW_CAL_LEN = 32768,
    parameter ALT_CAL_EN = 1,                                   
    parameter ALT_CAL_LEN = 32768,                                   
	parameter PREAMBLE_EN = 1,                                  
	parameter CONTINUOUS_CLK = 0,                                  
	parameter TM_EN = 0,                                        
	parameter TM_LOOPBACK_MODE = 0
    )
   (
        input  wire             fr_clk,         
        input  wire             fr_clk_1024,    
        input  wire             core_clk,       
        input  wire             arst_fr_n,      
        input  wire             srst_fr_n,      
        input  wire             arst_core_n,    
        input  wire             srst_core_n,    
        input sig_DPHY_CSR_Enable,
        input sig_CLK_CSR_CLK_LANE_EN,
        output logic [NUM_LANES-1:0] sig_DLANE_STATUS_INIT_DONE,
        output logic  sig_CLK_STATUS_INIT_DONE,
        input [NUM_LANES-1:0] sig_DLANE_CSR_EN,             
        input [NUM_LANES*8-1:0] sig_PRBS_INIT,              
        input sig_TX_PREAMBLE_LEN_PREAMBLE_EN,
        input [3:0] sig_TX_PREAMBLE_LEN_PREAMLBE_LEN,
        input [6:0] sig_TX_LPX,
        input [7:0] sig_TX_HS_EXIT,
        input [7:0] sig_TX_LP_EXIT,
        input [5:0] sig_TX_CLK_PREPARE,
        input [6:0] sig_TX_CLK_TRAIL,
        input [6:0] sig_TX_CLK_ZERO,
        input [7:0] sig_TX_CLK_POST,
        input [3:0] sig_TX_CLK_PRE,
        input [5:0] sig_TX_HS_PREPARE,
        input [7:0] sig_TX_HS_ZERO,
        input [7:0] sig_TX_HS_TRAIL,
        input [7:0] sig_TX_INIT,
        input [7:0] sig_TX_WAKE,
        input sig_TX_TM_CONTROL_TX_TM_EN,
        input sig_TX_TM_CONTROL_TX_TM_LOOPBACK_MODE,
        input sig_TX_TM_CONTROL_TX_TST_CNT_RST_pulse,
        input [IO_CONVERT_RATIO-1:0] tm_loopback_in,
        input [7:0] sig_TX_HS_TM_DESKEW_P,
        output logic [NUM_LANES*8-1:0] sig_TX_WORD_COUNT_B0,
    
        output logic [NUM_LANES*8-1:0] sig_TX_WORD_COUNT_B1,
    
        output logic [NUM_LANES*8-1:0] sig_TX_WORD_COUNT_B2,
    
        output logic [NUM_LANES*8-1:0] sig_TX_WORD_COUNT_B3,
        
        dphy_io_if              dphy_port,    
        dphy_dbg_dlane          dphy_dbg_dlane[7:0],
        dphy_dbg_clane          dphy_dbg_clane,
        ppi_if                  ppi_tx      
    );
    
        
    int i;
    genvar j;
    
    logic sig_DPHY_CSR_Enable_fr;
    logic sig_DPHY_CSR_Enable_core;
    logic [NUM_LANES-1:0] hs_done;
    logic [NUM_LANES-1:0] in_cal;
    logic [NUM_LANES-1:0] data_lane_en;
    logic [NUM_LANES:0] ppi_enable_fr;
    logic esc_pulse;
    logic srst_esc_n;
    logic clk_pre_done;


    logic [NUM_LANES-1:0] sig_DLANE_STATUS_INIT_DONE_int;
    logic sig_CLK_STATUS_INIT_DONE_int;
    logic auto_cal_done;
    logic auto_skew_cal;
    logic auto_alt_cal;
    logic clk_in_stop;


    altera_std_synchronizer_nocut # ( .depth(3) ) cdc_DPHY_CSR_Enable_fr (
        .clk(fr_clk), .reset_n(arst_fr_n), .din(sig_DPHY_CSR_Enable), .dout(sig_DPHY_CSR_Enable_fr) );               
    
    
    genvar nlane;
    for(nlane = 0; nlane < NUM_LANES+1; nlane++)
    begin : ppi_enable_sync
        altera_std_synchronizer_nocut # ( .depth(3) ) cdc_PPI_Enable (
            .clk(fr_clk), .reset_n(arst_fr_n), .din(ppi_tx.Enable[nlane]), .dout(ppi_enable_fr[nlane]) );               
    end

    assign data_lane_en = ppi_enable_fr[NUM_LANES-1:0] & sig_DLANE_CSR_EN;
    
    

    for(j=0; j<NUM_LANES; j++)
    begin : dphy_pcs_dlanes
    
        dphy_pcx_data_tx #(
                .IO_CONVERT_RATIO(IO_CONVERT_RATIO),     
                .SKEW_CAL_EN(SKEW_CAL_EN),               
                .ALT_CAL_EN(ALT_CAL_EN),                 
                .PREAMBLE_EN(PREAMBLE_EN),               
                .TM_EN(TM_EN),                           
                .TM_LOOPBACK_MODE(TM_LOOPBACK_MODE),     
                .LANE_ID(j),
                .VCO_FREQ_MULT(VCO_FREQ_MULT)
            ) pcs_data_tx
        (
                .fr_clk(fr_clk),    
                .fr_clk_1024(fr_clk_1024),    
                .core_clk(core_clk),
                .srst_fr_n(srst_fr_n),
                .srst_core_n(srst_core_n),    
                .srst_esc_n(srst_esc_n),
                .enable(sig_DPHY_CSR_Enable_fr & data_lane_en[j]),  
                .t_init(sig_TX_INIT),   
                .t_hs_prepare({2'h0, sig_TX_HS_PREPARE}),
                .t_hs_zero(sig_TX_HS_ZERO),
                .t_hs_trail(sig_TX_HS_TRAIL),
                .t_wake(sig_TX_WAKE),
                .t_hs_exit(sig_TX_HS_EXIT),   
                .t_lp_exit(sig_TX_LP_EXIT),   
                .reg_preamble_en(sig_TX_PREAMBLE_LEN_PREAMBLE_EN),
                .reg_preamble_len({4'h0, sig_TX_PREAMBLE_LEN_PREAMLBE_LEN}),
                .cal_prbs_init(sig_PRBS_INIT[j*8+:8]),
                .hs_done(hs_done[j]),
                .init_done(sig_DLANE_STATUS_INIT_DONE_int[j]),
                .clk_pre_done(clk_pre_done),
                .esc_pulse(esc_pulse),
                .auto_skew_cal(auto_skew_cal),
                .auto_alt_cal(auto_alt_cal),
                .auto_cal_done(auto_cal_done),
                .in_cal(in_cal[j]),
                .in_tm(sig_TX_TM_CONTROL_TX_TM_EN),
                .tm_loopback(sig_TX_TM_CONTROL_TX_TM_LOOPBACK_MODE),
                .tm_cnt_rst_p(sig_TX_TM_CONTROL_TX_TST_CNT_RST_pulse),
                .tm_loopback_in(tm_loopback_in),
                .tm_hs_deskew(sig_TX_HS_TM_DESKEW_P),
                
                .word_cnt({sig_TX_WORD_COUNT_B3[j*8+:8], sig_TX_WORD_COUNT_B2[j*8+:8], sig_TX_WORD_COUNT_B1[j*8+:8], sig_TX_WORD_COUNT_B0[j*8+:8]}),
                .dphy_port(dphy_port),         
                .dphy_dbg_dlane(dphy_dbg_dlane[j]),
               .ppi_tx(ppi_tx)  
            );    


    end    
    assign clk_lane_enable = sig_CLK_CSR_CLK_LANE_EN & sig_DPHY_CSR_Enable_fr & ppi_enable_fr[NUM_LANES];
    assign dlanes_hs_done = &hs_done;

    dphy_pcx_clk_tx  # (
            .NUM_LANES(NUM_LANES),
            .IO_CONVERT_RATIO(IO_CONVERT_RATIO),
            .CONTINUOUS_CLK(CONTINUOUS_CLK),
            .VCO_FREQ_MULT(VCO_FREQ_MULT)
        ) pcs_clk_tx (
            .arst_fr_n(arst_fr_n),                  
            .fr_clk(fr_clk),                        
            .fr_clk_1024(fr_clk_1024),              
            .core_clk(core_clk),                    
            .srst_fr_n(srst_fr_n),                  
            .enable(clk_lane_enable),               
            .srst_esc_n(srst_esc_n),
            .t_init(sig_TX_INIT),                           
            .t_lpx({1'b0, sig_TX_LPX}),                     
            .t_clk_prepare({2'h0, sig_TX_CLK_PREPARE}),   
            .t_clk_zero({1'b0, sig_TX_CLK_ZERO}),           
            .t_clk_pre({4'h0, sig_TX_CLK_PRE}),                     
            .t_clk_trail({1'b0, sig_TX_CLK_TRAIL}),         
            .t_clk_post(sig_TX_CLK_POST),                   
            .t_wake(sig_TX_WAKE),                           
            .t_hs_exit(sig_TX_HS_EXIT),                     
            .t_lp_exit(sig_TX_LP_EXIT),                     
            .dlanes_hs_done(dlanes_hs_done),        
            .clk_pre_done(clk_pre_done),            
            .esc_pulse(esc_pulse),
            .init_done(sig_CLK_STATUS_INIT_DONE_int),
            .auto_cal(auto_alt_cal | auto_skew_cal),
            .auto_cal_done(auto_cal_done),
            .clk_in_stop(clk_in_stop),
            .dphy_port(dphy_port),   
            .dphy_dbg_clane(dphy_dbg_clane),
            .ppi_tx(ppi_tx)  
        );    


    assign sig_DLANE_STATUS_INIT_DONE = sig_DLANE_STATUS_INIT_DONE_int & {NUM_LANES{auto_cal_done}};
    assign sig_CLK_STATUS_INIT_DONE = sig_CLK_STATUS_INIT_DONE_int & auto_cal_done;
 
    if(SKEW_CAL_EN == 1)
    begin: auto_cal_tx_on
            localparam SKEW_CAL_CNT = SKEW_CAL_LEN >> (IO_CONVERT_RATIO == 16 ? 4 : 3);
            localparam ALT_CAL_CNT = ALT_CAL_LEN >> (IO_CONVERT_RATIO == 16 ? 4 : 3);
            localparam SKEW_CAL_CNT_W = $clog2(SKEW_CAL_CNT + 1);
            localparam ALT_CAL_CNT_W = $clog2(ALT_CAL_CNT + 1);
            logic init_all_done, init_all_done_sync;
            logic [SKEW_CAL_CNT_W-1:0] skew_cntr;
            logic [ALT_CAL_CNT_W-1:0] alt_cntr;
            logic incr_skew_cnt;
            logic incr_alt_cnt;
            logic [NUM_LANES-1:0] data_lane_init_done;
            typedef enum  {     
                        IDLE,
                        SKEW,
                        PAUSE,
                        ALT,
                        DONE
                   } auto_sm_t;
            auto_sm_t cs, ns;
        
        assign data_lane_init_done = sig_DLANE_STATUS_INIT_DONE_int | ~data_lane_en;
        assign init_all_done = &data_lane_init_done & sig_CLK_STATUS_INIT_DONE_int;
        assign incr_skew_cnt = auto_skew_cal & &in_cal;
        assign incr_alt_cnt = auto_alt_cal & &in_cal;

        altera_std_synchronizer_nocut # ( .depth(3) ) init_done_sync_inst (
            .clk(core_clk), .reset_n(1'b1), .din(init_all_done), .dout(init_all_done_sync) ); 
        
        always @(posedge core_clk)
        begin
            if(srst_core_n & init_all_done_sync == 1'b0)
            begin
                cs <= IDLE;
                skew_cntr <= 0;
                alt_cntr <= 0;
            end
            else
            begin
                cs <= ns;
                skew_cntr <= (skew_cntr == SKEW_CAL_CNT) ? skew_cntr : skew_cntr + incr_skew_cnt;
                alt_cntr <= (alt_cntr == ALT_CAL_CNT) ? alt_cntr : alt_cntr + incr_alt_cnt;
            end
        end

        always @(*)
            case(cs)
                IDLE:       ns <= init_all_done_sync ? SKEW : cs;    
                SKEW:       ns <= (skew_cntr == SKEW_CAL_CNT) ? (ALT_CAL_EN ? PAUSE : DONE) : cs;   
                PAUSE:      ns <=  (CONTINUOUS_CLK == 0 ? clk_in_stop : dlanes_hs_done) ? ALT : cs;   
                ALT:        ns <= (alt_cntr == ALT_CAL_CNT) ? DONE : cs;
                default:    ns <= cs;                           
            endcase
            
        assign auto_cal_done = cs == DONE;
        assign auto_skew_cal = cs == SKEW;
        assign auto_alt_cal = cs == ALT;
        
    end
    else
    begin: auto_cal_tx_off
        assign auto_cal_done = 1'b1;
        assign auto_skew_cal = 1'b0;
        assign auto_alt_cal = 1'b0;
    end

 
    
 

endmodule 

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "k1LH1RcWqBqQ76v8cfULmmlV9sW1nnbJaS2wcLgqGwqBhLWK73DmouWbV7pbibS7IH130sZk+lXZ9U2UpRjei+a4GXqGhMMc9IMzMkgIDLbmlHj0N0nMSI9TMo4z5CKT4okwkd1gkpoJ98r//fD7kKG+O0v6X7LJGK2BQC+3s5gBj2lSsro8UaDW99uGAXd1ozPUFOiI9DO+P2Bl903Ke20T6b0d5clKKvtf117o8Gn8C70QLlih8pyscXykpWlL2Pvh9FKFemPO7t101YVrQlujGIwydU609Ns8RLiBvXfQZwVbszVPvDEyHn4liuEgeqZ6p0j0y2It+Iiq2m2Fj7t7MuhNcPkWMuBZomi7e9NgXIdLA41hhOEql096OdPoVchpG2phorrcRSnAPaeHaG5HHYThjvh78Ok9l92lBBiZXVnFMjsAxAgx6eBiiN28DFt/H2ipXVfn8VgfTvPQ2DhQjdKQXgSnOG3b82NAdX6j8m2MrA0aQkUndQ1kNQFnk+ND/rVc3zCALmVgBLcEK+fw6cU71w1Br/HKvCvDW2MHkDuCpeed9gbIryh2ZmfKanbnUKGvyHTegyD753sy5wMyYZXYkI1iA15dy24DHz91HoFh+GEj/auF+JVL1LexdDnYirgp1QLE3uhiCpdNt23tNeVOJtfDI4IqeJYjRBpQerkgemg8icyvJ4R/EI2GFe4EvYTLFC7DBu9nnpH8xVpen+3JZW0/aVv9aHajLTbIchDOZSC7d0iNMbXYq86imIK+RipbSROTwLUiGfbSyhB2Ixa9f3xUEycIh2IJhx5JkM6l8QSliLB+BEyG8lL6qSDerlKZQe6vW1BqSG3UPoAnvX7YTsMFK+Y6Y4Ah8awQ3Z3Tsd5E7W9m90bNgTnbw9VLGAeOgukgsiA/m9h8dNM4rrMQ3e/ejYN8lKkLlutXB+VGJA1YP+1F/LzWiulUUgDrh7WdyA0sjwiH9BNq7pev5tbMILpToUpHwWI62waFAwTPH9O9SYejaw4pe/zR"
`endif