// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




module toggle_synchronizer_2 (
    clk_src,
    clk_dst,
    reset_n_src,
    reset_n_dst,
    in_pulse,
    out_pulse
    
    );

    parameter depth = 3;        
    parameter rst_value = 0;    
        
    input   clk_src;
    input   clk_dst;
    input   reset_n_src;
    input   reset_n_dst;        
    input   in_pulse;
    output  out_pulse;

    logic in_level;
    logic in_level_ack;
    logic out_level;
    logic out_level_q;
    logic out_pulse;
    
    always @(posedge clk_src or negedge reset_n_src)
        if(reset_n_src == 1'b0)
            in_level <= 1'b0;
        else
            in_level <= ( ~(in_level ^ in_level_ack) & in_pulse ) ^ in_level;

    altera_std_synchronizer_nocut#(.depth(3), .rst_value(rst_value)) cdc_sync_ack (.clk(clk_src), .reset_n(reset_n_src), .din(out_level), .dout(in_level_ack));   
    altera_std_synchronizer_nocut#(.depth(3), .rst_value(rst_value)) cdc_sync (.clk(clk_dst), .reset_n(reset_n_dst), .din(in_level), .dout(out_level));
    
    always @(posedge clk_dst)
        out_level_q <= out_level;

    assign out_pulse = out_level_q ^ out_level;
   
 endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "9QgWcS4BAPM0ijhGxFMUlbGjnPppWaR0YyNAdZWTcmGrECrj4gvxvXQLdWaGUWx1flqhiB7hZArgo45zOL12QZTa//IH6WALqExWaaTGOBBf3xIcRMaO8DBqZIhy1HLpRPRmEOcNzcGmRGq+Q3v81HBA2YRjjmIypoU3QErFIzyIuSAHPdWq24/2dMSQPgP5vJP9/EepkjUbBBUcTbQYowR9S9a6LFSGsn1aoUnfU0PIGwD7BRlInFOm3HeGKOVNkm682JgeoBJjaPcrGPBGhLKTVpCrpvXAdm9Qa/PfHnoWDBtgoDSdjS7AE8rUMctu6n0K4mOMFe6HLq7EZ1+yKAEjFXZpXSWbkZmfB5MxxMKmw/dtmYvt6d4acIbYxewgW3gnH2jT+NW4E9EXP7695iYNdGiUICFoxyq8W4VlKVRzP68eqWNUbjancloGLVjezKqBGgGGfJvDXzCIktIwjpTPka9RFCctizBtMJB04b9OeMsEj3FcW+X3lQmlOkp3ZbAHkWOy1PQOl4bIKz55C20Av+U9Du3swu+tRPb9TyuBiPMpXZaLjvF6LWusFlgnlQ9DgAsJVW26WGHZLondCE4Nv/jc8tety87J2thz9GNt1TpRThctJ7VLhO2IoorWCFcsHbeWJPx0Jy6Q40xM4eYA0ThSr2wnsV4O1H26oDyUo0GyjYPpGkEEsR6rrA3Veylfl+WSfNUvXMRbRIxamg2IbG88NrFTy7Y0shffG1b3HfStdO7R7WobwrkI/+FZcIrM5yzRvVuNrHMaUch7j308ApdTHssJM/0uXf6VMSK2EZS0euO7FXYT/fb7X8xSBIyf9xCnhQkUoVrZStHSvgL8bSkjQ8ujC8rHQufOg3CyKkQMuwSHBOxX5zOmWaoLboPf62J28cuthyKsz6smkr6OvZp3eLNE3gz42CPPPJ/DYZFJxeDt8kdpRDrS2a+7nK+mA3Cg/QPGl9P08pTX0iuIgLZkhEvR8sr634hL+/TBvUXq8aHQ19m1OeC7fpmN"
`endif