// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




module toggle_synchronizer (
    clk_src,
    clk_dst,
    reset_n,    
    in_pulse,
    out_pulse
    
    );

    parameter depth = 3;        
    parameter rst_value = 0;    
        
    input   clk_src;
    input   clk_dst;
    input   reset_n;    
    input   in_pulse;
    output  out_pulse;

    logic in_level;
    logic in_level_ack;
    logic out_level;
    logic out_level_q;
    logic out_pulse;
    
    always @(posedge clk_src or negedge reset_n)
        if(reset_n == 1'b0)
            in_level <= 1'b0;
        else
            in_level <= ( ~(in_level ^ in_level_ack) & in_pulse ) ^ in_level;

    altera_std_synchronizer_nocut#(.depth(3), .rst_value(rst_value)) cdc_sync_ack (.clk(clk_src), .reset_n(reset_n), .din(out_level), .dout(in_level_ack));   
    altera_std_synchronizer_nocut#(.depth(3), .rst_value(rst_value)) cdc_sync (.clk(clk_dst), .reset_n(reset_n), .din(in_level), .dout(out_level));
    
    always @(posedge clk_dst)
        out_level_q <= out_level;

    assign out_pulse = out_level_q ^ out_level;
   
 endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "9QgWcS4BAPM0ijhGxFMUlbGjnPppWaR0YyNAdZWTcmGrECrj4gvxvXQLdWaGUWx1flqhiB7hZArgo45zOL12QZTa//IH6WALqExWaaTGOBBf3xIcRMaO8DBqZIhy1HLpRPRmEOcNzcGmRGq+Q3v81HBA2YRjjmIypoU3QErFIzyIuSAHPdWq24/2dMSQPgP5vJP9/EepkjUbBBUcTbQYowR9S9a6LFSGsn1aoUnfU0Oup36S9XL1y6xp42nmJJNY1SA7gyRK11gvNpSuCX3xnE87PKtk9omY4o2Sl5fYd0Hgd6KSgxAJBJsJ/qGaoTkT6urETerWd65oaFL6N9PJMuklXCVb7Gmhe/rDdvD8vTGplSZ4nqC+E4XJvF1aZak+vi0//tW/FgdC6iVJdkyQw+qsPYCjUaVc1+YIw6b5/uTJ9PxVXobQNnbzoUIVlH3jcIOrcGcKoZbvy4Kfan+Oet0TuYesitwBxGPN9PlawjB7U7grpREvWpFujHlW5pCzelboBhYMa4ZVfbU78fcn+vpt7awsUSplnnoHvKxSCvFjg9SlPNkl6BXuonYlpsppCQ0oVPRevE8QdSebrJyLciPwDsuygGVpZciqbFRz8geB19vJekNHSBnCMCFeDdX+w8RCiEMDmScBh0PVXL2MbdcFO7zXG3kxi7VVoxEk1+kCysio1zy7qFAo7CjyzZZx1ZUNZf45VP3fx5Uu+kvB7cDn8YoFzXJEYWHhmb9nFggjfvSyOgzdd+h7jzpKqXqtUqUcANcDVMZgdhg7ScjG9PVvLAg1ADJ8jdwWtlv/aWjnRqL2MwJBBwbQEaYPYHQuvB56lm1mK5glIOQ5Q7HRuwcczHzwRDy7ZrgwVKawmNMS8rUlcIu4uRyUZRFg+g4EaqsiU08zKgnYQRXSQraFjbLLJFV2QCx8WtSi+8DwyW/3MPF8BSGVY7lNVTO6lF4LI7B7QQrljR2iqKOBb6Q3Rbq5/YSNlC7uN9488kOQyl3uEl4ntQoy0mqGtumduMmf"
`endif