// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.





// synthesis translate_off        

`ifdef DPHY_BHV_SIM
`define BHV_OBUF 1
`endif

`ifdef BHV_OBUF
`define obuf_name dphy_obuf_bhv
`endif

`define SIM 1

// synthesis translate_on  


`ifndef obuf_name
`define obuf_name tennm_ph2_io_obuf
`endif

module dphy_obuf_wrap #(
    parameter BYTE_LOC = 0,
    parameter PIN_ID = 0,
    parameter RZQ_ID = "RZQ0",
    parameter TX_CAP_EQ_MODE = 0,
    parameter BIT_RATE = 36'd3200000000, 
    parameter TOGGLE_SPEED = "TOGGLE_SPEED_SLOW"                   
) ( 
    input wire 	inp, 
    input wire 	negbuf_in,
    input wire 	oe, 
    output wire obar,
    output wire posbuf_out,
    output wire outp                            
);

   `obuf_name #(
                .buffer_usage( "REGULAR" ),
                .io_standard( "IO_STANDARD_IOSTD_DPHY" ),
                .usage_mode( "USAGE_MODE_DPHY" ),
                .termination( "TERMINATION_SERIES_45_OHM_CAL" ),
                .rzq_id( RZQ_ID == "RZQ0" ? "RZQ_ID_RZQ0" : "RZQ_ID_RZQ1" ),
                .slew_rate( BIT_RATE < 1500000000 ? "SLEW_RATE_FAST" : "SLEW_RATE_FASTEST"),
                .equalization( TX_CAP_EQ_MODE == 1 ? "EQUALIZATION_2TAPS_MEDIUM_LP" : 
                               TX_CAP_EQ_MODE == 2 ? "EQUALIZATION_2TAPS_HIGH_LP"   :
                               TX_CAP_EQ_MODE == 3 ? "EQUALIZATION_2TAPS_MEDIUM_CZ" : "EQUALIZATION_OFF"),
                .open_drain( "OPEN_DRAIN_OFF" ),
                .toggle_speed( TOGGLE_SPEED ),
                .dynamic_pull_up_enabled( "FALSE" )
    ) obuf_inst (
                 .i( inp ),                                                    
                 .negbuf_in (negbuf_in),
                 .oe( oe ),                                                    
                 .obar(obar),
                 .posbuf_out(posbuf_out),
                 .o( outp )                                                    
                 );
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "9QgWcS4BAPM0ijhGxFMUlbGjnPppWaR0YyNAdZWTcmGrECrj4gvxvXQLdWaGUWx1flqhiB7hZArgo45zOL12QZTa//IH6WALqExWaaTGOBBf3xIcRMaO8DBqZIhy1HLpRPRmEOcNzcGmRGq+Q3v81HBA2YRjjmIypoU3QErFIzyIuSAHPdWq24/2dMSQPgP5vJP9/EepkjUbBBUcTbQYowR9S9a6LFSGsn1aoUnfU0PaXT5DCx/qOm3HfNmxFLOisv2ha4qj/TpNNQF+Obc4M5sgxqOrAZDA3bgM0J+0CUhqtBeuXUkn+AoYdP9pp51uIZGYjgff1Akugcl8mbebYM/WrEGHnQhFC93zEsjcvsF40L2zOLeVLmOdaH3ZwvNP2zsitped4xwHmvpBMe8frwyvz2GxeRJBacUPJZ2uCks12raa0Jr6cHwZf0mEFE/LgpVzyqj6lMbX9Pq1i62V7Svgd2aye734KDRIFMe7My1yoAIFj8G2/1wrW0JTH46aACj1HnbvxF4Bq0FEmZn3YLx+6whEIylnNWVQk+A0/wYWW2cupy7HwQUufxRH1vh79bDzOf3Umo6DQsnpbtg8YVh2A6lQKRMXprXJiq5VH9EaNpXdA11w9wq4Kd7frorQECFlaa3VwvLEPPff5r7VUcho66nj4UqP3+ZmgwxkBvPQLf+45XgMdgrXwc+pzFO8km0QK3gka+Zx/mae5n35jb3IZt2khvzctya/aksKimMxj9q6rnMcNMQTa3BNnuWaET5F+NlKIEymeDXyZImtuMrS9FayD5nSQCGvt1nc6C9Rea8c0Rg3Xk4WeprJZLvjxuXvpi+Ru9VhsRpK36RePyyP7TzBkLvgBNLsGJGe4oUnIhZJPpEVfwCE1maeEItUh78dmEXffC2jYPO1OCT+9ThSfngCdsMetyXb3qtiAOSoUEFFkDgVC3K3N+dBiAOOEHy0HugWOH+wuKoxYOqvYcVDQ0vn2dzSyDXHnTPjX+B3oDiF7s7YrmZdW7t729FN"
`endif