// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.





// synthesis translate_off        

`ifdef DPHY_BHV_SIM
`define BHV_IOPLL 1
`endif

`ifdef BHV_IOPLL
`define iopll_name dphy_iopll_bhv
`endif

`define SIM 1

// synthesis translate_on  


`ifndef iopll_name
`define iopll_name tennm_ph2_iopll
`endif

module dphy_iopll_wrap #(
    parameter PLL_ID = 0,
    parameter SPEED_GRADE = "SPEEDGRADE2",
    parameter REF_CLK_FREQ = 32'd0,
    parameter VCO_FREQ = 0
) ( 
    output logic           lock,                           
    input  wire            ref_clk0,                       
    input  wire            ref_clk1,                       
    input  wire            ref_clk_switch_n,               
    output logic [1:0]     ref_clk_bad,                    
    output logic           ref_clk_active,                 
    input  wire            fb_clk_in,                      
    input  wire            fb_clk_in_lvds,                 
    output logic [6:0]     out_clk,                        
    output logic           out_clk_external0,              
    output logic           out_clk_external1,              
    output logic           out_clk_periph0,                
    output logic           out_clk_periph1,                
    output logic           out_clk_cascade,                
    output logic           fb_clk_out,                     
    output logic [7:0]     vco_clk,                        
    output logic           vco_clk_periph                  
);
    localparam M_DIV_1 = int'(VCO_FREQ / REF_CLK_FREQ);
    localparam M_DIV_8 = int'(8 * VCO_FREQ / REF_CLK_FREQ);	
    localparam M_DIV = ((VCO_FREQ - M_DIV_1 * REF_CLK_FREQ) <= (VCO_FREQ - M_DIV_8 * REF_CLK_FREQ / 8)) ? M_DIV_1 : M_DIV_8;
    localparam N_DIV = ((VCO_FREQ - M_DIV_1 * REF_CLK_FREQ) <= (VCO_FREQ - M_DIV_8 * REF_CLK_FREQ / 8)) ? 1 : 8;
    localparam PFD_CLK = REF_CLK_FREQ / N_DIV;
    localparam SYNC_DIV = 16;

    
    `iopll_name #(
        .bandwidth_mode( "BANDWIDTH_MODE_AUTO" ),
        .base_address( (16'h3<<8) | (16'h3<<3) | PLL_ID ),
        .cascade_mode( "CASCADE_MODE_STANDALONE" ),
        .clk_switch_auto_en( "FALSE" ),
        .clk_switch_manual_en( "FALSE" ),
        .compensation_clk_source( "COMPENSATION_CLK_SOURCE_UNUSED" ),
        .compensation_mode( "COMPENSATION_MODE_DIRECT" ),
        .fb_clk_delay( 0 ),
        .fb_clk_fractional_div_den( 1 ),
        .fb_clk_fractional_div_num( 1 ),
        .fb_clk_fractional_div_value( 0 ),
        .fb_clk_m_div( M_DIV ),
        .out_clk_0_c_div( 2 ),
        .out_clk_0_core_en( "TRUE" ),
        .out_clk_0_delay( 0 ),
        .out_clk_0_dutycycle_den( 4 ),
        .out_clk_0_dutycycle_num( 2 ),
        .out_clk_0_dutycycle_percent( 50 ),
        .out_clk_0_freq( VCO_FREQ/2 ),
        .out_clk_0_phase_ps( 0 ),
        .out_clk_0_phase_shifts( 0 ),
        .out_clk_1_c_div( SYNC_DIV ),
        .out_clk_1_core_en( "TRUE" ),
        .out_clk_1_delay( 0 ),
        .out_clk_1_dutycycle_den( SYNC_DIV*2 ),
        .out_clk_1_dutycycle_num( SYNC_DIV ),
        .out_clk_1_dutycycle_percent( 50 ),
        .out_clk_1_freq( VCO_FREQ/SYNC_DIV ),
        .out_clk_1_phase_ps( 0 ),
        .out_clk_1_phase_shifts( 0 ),
        .out_clk_2_c_div( 1 ),
        .out_clk_2_core_en( "FALSE" ),
        .out_clk_2_delay( 0 ),
        .out_clk_2_dutycycle_den( 4 ),
        .out_clk_2_dutycycle_num( 2 ),
        .out_clk_2_dutycycle_percent( 0 ),
        .out_clk_2_freq( 0 ),
        .out_clk_2_phase_ps( 0 ),
        .out_clk_2_phase_shifts( 0 ),
        .out_clk_3_c_div( 1 ),
        .out_clk_3_core_en( "FALSE" ),
        .out_clk_3_delay( 0 ),
        .out_clk_3_dutycycle_den( 4 ),
        .out_clk_3_dutycycle_num( 2 ),
        .out_clk_3_dutycycle_percent( 0 ),
        .out_clk_3_freq( 0 ),
        .out_clk_3_phase_ps( 0 ),
        .out_clk_3_phase_shifts( 0 ),
        .out_clk_4_c_div( 1 ),
        .out_clk_4_core_en( "FALSE" ),
        .out_clk_4_delay( 0 ),
        .out_clk_4_dutycycle_den( 4 ),
        .out_clk_4_dutycycle_num( 2 ),
        .out_clk_4_dutycycle_percent( 0 ),
        .out_clk_4_freq( 0 ),
        .out_clk_4_phase_ps( 0 ),
        .out_clk_4_phase_shifts( 0 ),
        .out_clk_5_c_div( 1 ),
        .out_clk_5_core_en( "FALSE" ),
        .out_clk_5_delay( 0 ),
        .out_clk_5_dutycycle_den( 4 ),
        .out_clk_5_dutycycle_num( 2 ),
        .out_clk_5_dutycycle_percent( 0 ),
        .out_clk_5_freq( 0 ),
        .out_clk_5_phase_ps( 0 ),
        .out_clk_5_phase_shifts( 0 ),
        .out_clk_6_c_div( 1 ),
        .out_clk_6_core_en( "FALSE" ),
        .out_clk_6_delay( 0 ),
        .out_clk_6_dutycycle_den( 4 ),
        .out_clk_6_dutycycle_num( 2 ),
        .out_clk_6_dutycycle_percent( 0 ),
        .out_clk_6_freq( 0 ),
        .out_clk_6_phase_ps( 0 ),
        .out_clk_6_phase_shifts( 0 ),
        .out_clk_cascading_source( "OUT_CLK_CASCADING_SOURCE_UNUSED" ),
        .out_clk_external_0_source( "OUT_CLK_EXTERNAL_0_SOURCE_UNUSED" ),
        .out_clk_external_1_source( "OUT_CLK_EXTERNAL_1_SOURCE_UNUSED" ),
        .out_clk_periph_0_delay( 0 ),
        .out_clk_periph_0_en( "TRUE" ),
        .out_clk_periph_1_delay( 0 ),
        .out_clk_periph_1_en( "TRUE" ),
        .pfd_clk_freq( PFD_CLK ),
        .protocol_mode( "PROTOCOL_MODE_EMIF_MODE" ),
        .ref_clk_0_freq( REF_CLK_FREQ ),
        .ref_clk_1_freq( 0 ),
        .ref_clk_delay( 0 ),
        .ref_clk_n_div( N_DIV ),
        .self_reset_en( "TRUE" ),
        .set_dutycycle( "SET_DUTYCYCLE_FRACTION" ),
        .set_fractional( "SET_FRACTIONAL_FRACTION" ),
        .set_freq( "SET_FREQ_DIVISION_VERIFY" ),
        .set_phase( "SET_PHASE_NUM_SHIFTS" ),
        .vco_clk_freq( VCO_FREQ )
    ) iopll_inst (
        .permit_cal( 1'h1 ),                                          
        .lock( lock ),                                                
        .ref_clk0( ref_clk0 ),                                        
        .ref_clk_switch_n( ref_clk_switch_n ),                        
        .ref_clk_bad( ref_clk_bad ),                                  
        .ref_clk_active( ref_clk_active ),                            
        .fb_clk_in( fb_clk_in),                                       
        .out_clk( out_clk ),                                          
        .out_clk_external0( out_clk_external0 ),                      
        .out_clk_external1( out_clk_external1 ),                      
        .out_clk_periph0( out_clk_periph0 ),                          
        .out_clk_periph1( out_clk_periph1 ),                          
        .out_clk_cascade( out_clk_cascade ),                          
        .fb_clk_out( fb_clk_out ),                                    
        .vco_clk( vco_clk ),                                          
        .vco_clk_periph( vco_clk_periph ),                            
        .fb_clk_in_lvds(),                                            
        .ref_clk1( ),                                                 
        .reset( 1'b0 ),                                               
        .core_avl_clk(),                                              
        .core_avl_write(),                                            
        .core_avl_read(),                                             
        .core_avl_address(),                                          
        .core_avl_writedata(),                                        
        .cal_bus_rst_n(),                                            
        .cal_bus_clk(),                                               
        .cal_bus_write(),                                             
        .cal_bus_read(),                                              
        .cal_bus_address(),                                           
        .cal_bus_writedata(),                                         
        .dps_num_phase_shifts(),                                      
        .dps_cnt_sel(),                                               
        .dps_phase_en(),                                              
        .dps_up_dn(),                                                 
        .core_avl_readdata(),                                         
        .cal_bus_readdata(),                                          
        .dps_phase_done()                                             
    );
    
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "9QgWcS4BAPM0ijhGxFMUlbGjnPppWaR0YyNAdZWTcmGrECrj4gvxvXQLdWaGUWx1flqhiB7hZArgo45zOL12QZTa//IH6WALqExWaaTGOBBf3xIcRMaO8DBqZIhy1HLpRPRmEOcNzcGmRGq+Q3v81HBA2YRjjmIypoU3QErFIzyIuSAHPdWq24/2dMSQPgP5vJP9/EepkjUbBBUcTbQYowR9S9a6LFSGsn1aoUnfU0OagYVua+x0D6eo3kG+bH0MvNXkg2qopK+e4DGLYW3AMfj/h7cELOcRzIEIWGEbuthAnrY9Ooqufk7p3R2Dd3PPB3ZsIbQVBxXrmMG3Sl48PCXSQOP363cJrl+k8UAOJPtnaHptcSmwun2tiCBtvpN8jSkXPPvJNkug80ka4AUpmaRyudpoZ2D7bm49G16ro5fQQv4A6uZZgI0acd/EPnVkLPzXxOL3b5m1IZgtWxFCh1hY3PCTYj1fbrDoHqkaHZ1zRN68nwiRdS8uewQCRURashBFqSMgztzNiUVRdKpcroMAPcZW1Pe+RUYyavU792H+4SY82A1/BoysRpdhKojNbrrvFGi/M78rX3MXts1oscA4ET6lasRPCJCsoAKdsmHXSUdfeq4mksgkhXcIrepW9F3zp6MvlvgfzdtEVHGZh8YWPEQd/Ge36UUzBWKAW42iz+LbYd4jDaWgdb25yLdGPmHcbS+u3kzegPYVefmRJa8XJv7T+rPVSJVL4CoJFuTjqQtf16KNa1cGlYR+KJhXpaOSCnJPSd4HPXFG74mYbiEiFDWpwQmqgrFg2+f0VKaooZsJRSvqM6d59UF7GZ5+Ot5S9Ml3SoChGWtHzHW0kbc6zGqL9todBpjJF8pV0Fj3yIAG13IWVxEEvbGCIYg4svnAC1DOYfjG1aUjqZ144P5tA/IyeqVNq6GYoKWGPXPG5D/jUWUWLUVGwezblUPfn3HkZQZAGmFR5Qv9lVV4o6Poq3Yg1l7Mh5XYL0A7Xd/EWiRtnObGlKrLEA+XyzY+"
`endif