// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




(* altera_attribute = "-name AUTO_SHIFT_REGISTER_RECOGNITION off" *) module hyperpipe # ( 
  parameter WIDTH = 1,
  parameter CYCLES = 3
) (
  input clk,
  input [WIDTH-1:0] din,
  output [WIDTH-1:0] dout
);

generate
  if (CYCLES==0) begin : GEN_COMB_INPUT
    assign dout = din;
  end 
  else begin : GEN_REG_INPUT  
    integer i;
    reg [WIDTH-1:0] R_data_preserve [CYCLES-1:0];
    
    always @(posedge clk) begin   
      R_data_preserve[0] <= din;      
      for(i=1;i<CYCLES;i=i+1) R_data_preserve[i] <= R_data_preserve[i-1];
    end
    assign dout = R_data_preserve[CYCLES-1];
  end
endgenerate  
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "9QgWcS4BAPM0ijhGxFMUlbGjnPppWaR0YyNAdZWTcmGrECrj4gvxvXQLdWaGUWx1flqhiB7hZArgo45zOL12QZTa//IH6WALqExWaaTGOBBf3xIcRMaO8DBqZIhy1HLpRPRmEOcNzcGmRGq+Q3v81HBA2YRjjmIypoU3QErFIzyIuSAHPdWq24/2dMSQPgP5vJP9/EepkjUbBBUcTbQYowR9S9a6LFSGsn1aoUnfU0N9MjiCiKbskruhExs6ib7oixo6SfZLw/Y5CyyoNE+M/28V7ySk0i4JAD8+UpolOsb19v/HGHhklpWdmv70Z5T3TRosQm5IlwjxQZNAmhVKHfrNV7CBJkcR5nrDG8HCf2XFgKn5HU0X25wgb9FkLx8e5ZynGXwaHAaF9ebhrRuhfEoi8lBwP2yimtuK3phqvJGpeVFc8mr0oWPEsZLx0Tz/q3dFh9VGjffmd2cB0ZBzL5y72YjZONDYSpbqb7rue8gmTFZqwRy2fKEOsUIDuRg+dmHm4FPyAClm/mtxMgmRVxTEdbn4wO0WCSNAvwBUHRER0x2QJECoFq56+N7DEs/ALsx6Ys8vVqhrEvszLCexLhKU1y/L/syPlYvbI1H69WCl0rniHPQoLcoELZnT0Tk2wZbdpFSJ9y40qunL41atKK3e5R37f41PX5J6pB77RjUYFEIbioVyEtBbUtseijmYsWWmVKj4B7s5p1STZoq1MBJR6IaZexnsIiSEP7ASwfN6z3bI7LScwJApKieiyiCb+LTYX0vSyL0zOdzs4nmezby/n6rtz5ZIvjX3+YRWsBN7KPAHRAuztP5MNRzOgGcw4Tuo4azxu+Kv/E0NduU/tquKuVunZqngXZ2wckCpjsolICOwyNXm1mb0HjSiAdi+trBNuSaOQp+yPPjBQOKIwthKf+OTV2XWslJo7R1ydMoCAbX/SXHSfNRKFn3qldiSWPIWDBbDHDUwMi3wmvn1wXhqAz14nSOmx0cA9DAnEL9h0lea2JloYT+wRZvXj6f6"
`endif