// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.





module dphy_prbs9 #(
        WIDTH = 8,                                  
        LOOKAHEAD = 0                               
        )
(
    input                       clk,
    input                       srst_n,
    input                       enable,
    input                       skip,
    input                       pause,
    input  [8:0]                init_val,
    output logic                out_valid,
    output logic [WIDTH-1:0]    prbs_out,
    output logic [15:0]         prbs_next
);

    logic [8:0] q_0;
    logic [8:0] q_1;
    logic [8:0] q_2;
    logic [8:0] q_3;

    logic [8:0] init_val_int;
    int i;
    logic [8:0] init_val_tmp;
    assign init_val_tmp = 9'h02;   
    
    `ifdef VIP
        always @(*)
        begin
            for (i = 1; i < 9; i++)
                init_val_int[9-i] <= init_val_tmp[i];
            init_val_int[0] <= init_val_tmp[0];
        end
    `else
        assign init_val_int = init_val; 
    `endif

`ifdef DEBUG_ALT_CAL

    logic [WIDTH-1:0] cnt;

    always @(posedge clk)
        begin
            if(enable == 1'b0)
                cnt <= 'hc3;
            else
                cnt <= cnt + 1'b1 + skip;
            prbs_out <= { ~cnt[7:0] , cnt[7:0] };
        end        



`else
    always @(posedge clk)
        out_valid <= enable;
    
    if(WIDTH == 16)
    begin
        
        always @(posedge clk)
        begin
            logic [8:0] q_tmp;
            if(enable == 1'b0)
            begin
                q_tmp = init_val_int;
                q_0 <= q_tmp;
                for(i=0; i<8; i++)
                    q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                q_1 <= q_tmp;
                if(LOOKAHEAD == 1)
                begin
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_2 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_3 <= q_tmp;
                end
            end                                                     
            else
            begin
                if(LOOKAHEAD == 1 && skip == 'b1 && pause == 'b0)
                begin
                    q_tmp = q_3;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_0 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_1 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_2 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_3 <= q_tmp;
                end            
                else if(LOOKAHEAD == 0 && skip == 'b1 && pause == 'b0)
                begin
                    q_tmp = q_1;
                    for(i=0; i<24; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_0 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_1 <= q_tmp;
                end
                else if(LOOKAHEAD == 1 & skip == pause)
                begin
                    q_0 <= q_2;
                    q_1 <= q_3;
                    q_tmp = q_3;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_2 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_3 <= q_tmp;
                    
                end
                else if(LOOKAHEAD == 0 && pause == skip)
                begin
                    q_tmp = q_1;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_0 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_1 <= q_tmp;
                end
		else
		begin
		    q_tmp <= q_tmp;
		    q_0 <= q_0;
		    q_1 <= q_1;
		end
            end
        end
        
        always @(posedge clk)
        begin
        `ifdef VIP
            for (i = 1; i < 9; i++)
            begin
                prbs_out[8-i]    <= q_0[i];
                prbs_out[16-i]   <= q_1[i];
                prbs_next[8-i]   <= (LOOKAHEAD == 1) ? q_2[i] : 'h0;
                prbs_next[16-i]  <= (LOOKAHEAD == 1) ? q_3[i] : 'h0;
            end
        `else
            prbs_out <= { q_1[8:1] , q_0[8:1] };
            prbs_next <= (LOOKAHEAD == 1) ? {  q_3[8:1] , q_2[8:1] } : 'h0;
        `endif
        end

    end
    else
    begin
        always @(posedge clk)
        begin
            logic [8:0] q_tmp;
            if(enable == 1'b0)
            begin
                q_tmp = init_val_int;
                q_0 <= q_tmp;
                if(LOOKAHEAD == 1)
                begin
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_1 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_2 <= q_tmp;
                end                
            end
            else
            begin
                if(LOOKAHEAD == 1 && skip == 'b1 && pause == 'b0)
                begin
                    q_tmp = q_2;
                    q_0 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_1 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_2 <= q_tmp;
                end
                if(LOOKAHEAD == 0 && skip == 'b1 && pause == 'b0)
                begin
                    q_tmp = q_0;
                    for(i=0; i<16; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_0 <= q_tmp;
                end
                else if(LOOKAHEAD == 1 && skip == pause)
                begin
                    q_0 <= q_1;
                    q_tmp = q_2;
                    q_1 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_2 <= q_tmp;
                end 
                else if(LOOKAHEAD == 0 && pause == skip)
                begin
                    q_tmp = q_0;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_0 <= q_tmp;
                end
	       	else
		begin
		    q_tmp <= q_tmp;
		    q_0 <= q_0;
		    q_1 <= q_1;
		end
            end
        end

        always @(posedge clk)
        begin
        `ifdef VIP
            for (i = 1; i < 9; i++)
            begin
                prbs_out[8-i]    <= q_0[i];
                prbs_next[8-i]    <= (LOOKAHEAD == 1) ? q_1[i] : 'h0;
                prbs_next[16-i]   <= (LOOKAHEAD == 1) ? q_2[i] : 'h0;
            end
        `else
            prbs_out <= q_0[8:1];
            prbs_next <= LOOKAHEAD == 1 ? {q_2[8:1], q_1[8:1]} : 'h0;
        `endif
        end

    end

`endif    

 

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "9QgWcS4BAPM0ijhGxFMUlbGjnPppWaR0YyNAdZWTcmGrECrj4gvxvXQLdWaGUWx1flqhiB7hZArgo45zOL12QZTa//IH6WALqExWaaTGOBBf3xIcRMaO8DBqZIhy1HLpRPRmEOcNzcGmRGq+Q3v81HBA2YRjjmIypoU3QErFIzyIuSAHPdWq24/2dMSQPgP5vJP9/EepkjUbBBUcTbQYowR9S9a6LFSGsn1aoUnfU0MsGP2hw0+X4h9Er42rAFgt9pxxR+njc8IL2365UQ0fV/WirKYq2x0Yftgl9jhdgsxb33YKC2TMbcAbNvwmYXZeB9zLPdCapXBM567nRDGclwEaAlKmSJv5pcJ+qqnUuMesSIVoQP8SAZn6iGneCl3U6WkGARWDTfkuN/kn+WnnqKZJMU2HnBxDs44n6yZhj/DYotBZZlgCiV2aKrUogyyKhjhDQetUii8vpdHtPwlPjUjvpzOdsfLhig+oZyLQ4C3yLZIS1grGTCpM3/WYhu6mBvfX45iknR3q9wZ7x6oaAcvWZLDnMDyB8PCjh5+gXe7/kwRNdXbkZudchbl4yjTHs93vM67VIL7IfDRd7V7S/SVgaVmpsLcKThr46U2jRD5ND+lg7je+jZnV55GcbKQQZ4ibtX6FdfkKrzWYRKza61FBB3SLAnvo65r+vvU0XOt6paRs1vOyUl40ET/M4O0ndwCXk9n8ejNdwCUTSzPUNLH0rpTApTF29IqEEest5HbMGDwpph922R+MD8NlNZ/ep0eiyYhdOyaWuxcn3kUghremTqUw3nIk7mATB3u2P0pnL0zAiubk2X0Rparq5o6elgPdAYe7mb2RBUVHXOmZqXK/ieuoeairM2hkfLkO5qrsvurPvUOxA0pxDSgnyyQV+d/dtgKEbwFuLoHA4G7b9OEGIGoTpzpBY4QEzMk+vmpbs4Cs6s85BYGdLlxByw7jcmm9A4jIYVHSIHWQpTrQ+B3Pci4QEjSWBH8Q6ERqwSQ9oQJj3mCE59MwWnoj5i00"
`endif