// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



import dphy_pkg::*;

module dphy_pcs_timing_tx 
   (
        input  wire                     fr_clk,
        input  wire                     fr_clk_1024,
        input  wire                     srst_fr_n,     
        input  wire                     enable,
        
        input wire                      in_prepare,            
        input wire                      in_zero,  
        input wire                      in_pre,
        input wire                      in_trail,
        input wire                      in_post,
        input wire                      in_wake,
        input wire                      in_hs_exit,
        input wire                      in_lp_exit,
        input wire [7:0]                t_init,   
        input wire [7:0]                t_prepare,
        input wire [7:0]                t_zero,
        input wire [7:0]                t_pre,
        input wire [7:0]                t_trail,
        input wire [7:0]                t_post,
        input wire [7:0]                t_wake,
        input wire [7:0]                t_hs_exit,   
        input wire [7:0]                t_lp_exit,   
        output logic                    init_done,
        output logic                    timer_out

    );
    
    localparam FR_TIMER_WIDTH = 16;
    logic [6:0] in_trig;
    logic [6:0] in_trig_q;
    logic fr_ld_timer;
    logic fr_timer_en;
    logic [FR_TIMER_WIDTH-1:0] fr_ld_val;
    logic init_start;
    logic in_wake_q;
    logic fr_timer_out;

    assign in_trig = { in_prepare, in_zero, in_pre, in_trail, in_post, in_hs_exit, in_lp_exit };
    always @(posedge fr_clk)
    begin
        in_trig_q <= in_trig;
        in_wake_q <= in_wake;
    end
    
    
    assign fr_ld_timer = init_start | |(in_trig & ~in_trig_q) | (in_wake & ~in_wake_q);
    assign fr_timer_en = ( init_done & ~in_wake ) ? |in_trig : fr_clk_1024;
    assign fr_ld_val = { 8'h0,  ({ 8{init_start} } & t_init ) |
                                ({ 8{in_prepare} } & t_prepare ) |
                                ({ 8{in_zero} } & t_zero ) |
                                ({ 8{in_pre} } & t_pre ) |
                                ({ 8{in_trail} } & t_trail ) |
                                ({ 8{in_post} } & t_post ) |
                                ({ 8{in_wake} } & t_wake ) |
                                ({ 8{in_hs_exit} } & t_hs_exit ) |
                                ({ 8{in_lp_exit} } & t_lp_exit ) };
    
    always @(posedge fr_clk)
        if( (srst_fr_n & enable) == 1'b0)
        begin
            init_start <= 1;
            init_done <= 1'b0;
        end
        else
        begin
            init_start <= 1'b0;
            init_done <= init_done | fr_timer_out;
        end

    dphy_timer #(
        .WIDTH(FR_TIMER_WIDTH)
   ) tx_timer_fr
   (
        .clk(fr_clk),     
        .srst_n(srst_fr_n),     
        .timer_en(fr_timer_en), 
        .ld_timer(fr_ld_timer),   
        .ld_val(fr_ld_val), 
        .timer_out(fr_timer_out)   
    );
    
    assign timer_out = fr_timer_out;

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "EFp3MeAJX/lIDaqlP2bXklYrJ9H4kLxD18of/nu1/yvzD8WAeCSdgm842C29sY+u4jKW4cJhiBbRNxkoZOsJXr0Nl0UlJ2vNeyvx1FnvcIQJ1IOHvsnSV/sCIxLCk2lhGEl8PhdNJMALVPIbEBiGREMWXAMa9WmHpxw3xSZIzUU2Gt9VPV5HnzUgXy8dXsXSELTll6nsjuaaMkUcqpbujl9iNlYf5Wk78osDP8IQggRvCGDMsibLngP9fLXz+Qe6ZOOwcTUIxZPUCSB6ecFEbimXeEztkHvs7bLwdOv/07+kXqtycn6ewwZw4FA5j+dn0BTJ8OW6mQYS5/jmy2hswzLVvtrUauQQFsZx2Y3oCTEJXxKqpHcePeHBAKZ5j8D15md0KZI8ktf/5ceXo/VNXaOdPuQdrmKMLKtqdDi1OZpz/FSl06ANBwl9OPrulwa5WoKBRf41y6TdIeeK0IKSBlALhfQKdA5cCED7kEKu8FQPKEizJZjVxeDViCR0OZI+OvcZQ6/93v+hmCIaFwf8bW0KSALtdOw+PspzqaGYypEl0Ga9+ZR9IAAF24sbf/R2JQ1vDi1nrpFOaCOr5fu2LfeiRts9LlYKxPZTHZPy6cP7C1GWtKQvcXoGqmJP4AD/AqLyi8I+Z8VTAlf8Dv+HvtLdVne34N1erRor2v+pFNnWPpCpa9zH0LNvEPSBvVjTSdm5vC2zqR+rTzPol4x3ff4J1oiCHikB/xE8qjFN4bUE7hLWYeF2cFoKZXKhHv118q4fRM75uPt7vZv4ZagsAMC7JdlKmKuqBdVNRL6FP98CpJ8Ccf43xxFxV6kKRqmKqL/+d0bJ2jFg5zybttP1IhHc+7PNxYzZeMulJDPhCAdX/vIoOFnh1Wc3ttncYnrFtpdSwxxPY9rZQ0ZOAN9N/MgkFR4MOBkGSZCNRh5isWCR5CPb58k0iUhZNTSQs4BBrt9AZrPWH2ivE6nLeVl2I+EjRttiHa9JVaqCuocsHGlcVjW22Ax7ihle/cP6sdiU"
`endif