// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



import dphy_pkg::*;

interface dphy_io_if #(
    parameter NUM_LANES = 8,
    parameter IO_CONVERT_RATIO = 16,
    parameter BYTE_CNT = NUM_LANES > 4 ? 2 : 1
    ) ;
   
    logic [BYTE_CNT-1:0]                         rx_clk;         
    logic [NUM_LANES*IO_CONVERT_RATIO-1:0]       rx_rd_data; 
    logic [3:0]                                  rx_rd_valid;   
    logic                                        rx_clk_lp_p;
    logic                                        rx_clk_lp_n;
    logic [NUM_LANES-1:0]                        rx_data_lp_p;
    logic [NUM_LANES-1:0]                        rx_data_lp_n;
    logic [3:0]                                  rx_data_read_en;    
    logic                                        rx_clk_lp_hs_b;
    logic [NUM_LANES-1:0]                        rx_data_lp_hs_b;
    logic [16*NUM_LANES-1:0]                     rx_data_deskew_cntrl;
    logic                                        core_clk;
    logic                                        srst_n;

    logic [NUM_LANES*IO_CONVERT_RATIO-1:0]       tx_wr_data; 
    logic [IO_CONVERT_RATIO-1:0]                 tx_clk_data; 
    logic                                        tx_clk_lp_p;
    logic                                        tx_clk_lp_n;
    logic [NUM_LANES-1:0]                        tx_data_lp_p;
    logic [NUM_LANES-1:0]                        tx_data_lp_n;
    logic [NUM_LANES-1:0]                        tx_data_lp_hs_b;
    logic                                        tx_clk_lp_hs_b;

    logic                                        mnl_tx_en;
    logic                                        mnl_tx_clk_lp_hs_b;
    logic [NUM_LANES-1:0]                        mnl_tx_data_lp_hs_b;
    logic                                        mnl_tx_data_lp_p;
    logic                                        mnl_tx_data_lp_n;
    logic [1:0]                                  mnl_tx_data_hs;
    logic [1:0]                                  mnl_tx_clk_hs;


endinterface : dphy_io_if
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "9QgWcS4BAPM0ijhGxFMUlbGjnPppWaR0YyNAdZWTcmGrECrj4gvxvXQLdWaGUWx1flqhiB7hZArgo45zOL12QZTa//IH6WALqExWaaTGOBBf3xIcRMaO8DBqZIhy1HLpRPRmEOcNzcGmRGq+Q3v81HBA2YRjjmIypoU3QErFIzyIuSAHPdWq24/2dMSQPgP5vJP9/EepkjUbBBUcTbQYowR9S9a6LFSGsn1aoUnfU0OlG71Ic2/m6jwGXMdY2PmRzK4pV8mmuh4epH2EydZCVdo7U9IXU8/3OAzXyLkfYYh7QX7lKqpUvSjiGmXnYScITmWRXZabAO8E0R20k52sAMAFJ71VVbSq5UhiZwwxzh4HfdyTKEUnaJKiHxQ6H7ja1uWscCDZcuaGvwROXHVESrAbHUjKGZZXvPU3dT74Bc+q5I/W3SyeqzTqqILsFbD3PslBVl5U/42gn/vB7DztyNVryIi/Edvb0vKed3kEMjEWDT5D7Ml6ttqh0u1cZbUhKL3dJbnyAzqnkHtObrTmiYXXMbLXCosBfUbqM1GV6f3WZlZRBfKVVXeSRLYbRD5M9wNahDsc8eE/7cVlA5oL+qFEwIm5oS9BpPlQ65ImdxtZjN69JJoccHaxKpaEeNHkfArRN6qDXiE8lWbSsw6yB/aEH3XAC+LQ9I5sJwpH2BT19Pewn23WoSZOVtg3otEkfZzXxnjEIwkQObT8GdlBCZikUv/cvV9lvsyTS1J+crLG5fbzkv+88e5T7uzJFIu0ceLf0VDxWnri0kjfuPHWr3day5ssi7gkMP0tADWOEmD/qA0pztgdLlDwqLZu5AmNpDCuSUQQyAQylpsIR+dwn6J+vofmkU1ToPcRPAV6hCilyoHfFsSPajpO+wo2WoV+439ndjj4O7Qj8KsbahgAPW8mASC2xMyEothE5LCh73jMqe0mlH2K92jEn+0UmiNU10z+34BLI0kRluTZCAnMlMgdU+/N1XMbrUiDdZFI+4zMTKDcLv4GYN+1U6Os+aGZ"
`endif