// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.





import dphy_pkg::*;
`ifdef MIPI_RTL_SIM_BHV
import dphy_pkg_sim::*;
`endif

module dphy_cp_map #(
    parameter NUM_LANES = 4,                            
    parameter IO_CONVERT_RATIO = 16,                    
    parameter DPHY_RX_EN = 0,                           
    parameter DPHY_TX_EN = 0,                           
    parameter BYTE_CNT = NUM_LANES>4 ? 2 : 1            
    )
   (    

        input  [BYTE_CNT-1:0]           rx_fwd_clk,          
        input  [BYTE_CNT*96-1:0]        p2c,                 
        input  [BYTE_CNT*4-1:0]         p2c_ctrl,            
        input  [BYTE_CNT*12-1:0]        phy_gpio_din,        

        output logic [BYTE_CNT*96-1:0]  c2p,                 
        output logic [BYTE_CNT*20-1:0]  c2p_ctrl,            

        dphy_io_if                      dphy_io             
    );

    integer i, j, k;


    




    if (DPHY_RX_EN == 1)
    begin : dphy_rx_inf
        assign dphy_io.rx_clk[BYTE_CNT-1:0] = rx_fwd_clk[BYTE_CNT-1:0];
       
        always @(*)
        begin
            for(i = 0 ; i < BYTE_CNT*4; i++)
            begin
                k = (i>3) ? 1 : 0;
                j = (i%4) > 1 ? (i%4) + 1 : (i%4);
                if(i<NUM_LANES)
                begin
		    dphy_io.rx_rd_data[i*IO_CONVERT_RATIO +: IO_CONVERT_RATIO] <= p2c[k*96+j*16 +: IO_CONVERT_RATIO];
                    dphy_io.rx_data_lp_p[i] <= phy_gpio_din[k*12+2*j];
                    dphy_io.rx_data_lp_n[i] <= phy_gpio_din[k*12+2*j+1];
                    if(j < 2)
                        c2p_ctrl[k*20+18+j] <= dphy_io.rx_data_lp_hs_b[i];
                    else
                        c2p_ctrl[k*20+12+j-2] <= dphy_io.rx_data_lp_hs_b[i];
                    c2p[k*96+j*16 +: 16] <= dphy_io.rx_data_deskew_cntrl[i*16 +: 16];
                end
                else
                begin
                    if(j < 2)
                        c2p_ctrl[k*20+18+j] <= 1'b0;
                    else
                        c2p_ctrl[k*20+12+j-2] <= 1'b0;
                    c2p[k*96+j*16 +: 16] <= 16'h0;
                end
            end
        end
        
        always @(*)
        begin
            dphy_io.rx_rd_valid[3:0] = p2c_ctrl[3:0];
            for(i = 0 ; i < (NUM_LANES+3)/4; i++)
            begin
                c2p_ctrl[i*20+8 +: 4] <= dphy_io.rx_data_read_en;
                c2p[i*96+2*16 +: 16] <= 16'h0;
                c2p_ctrl[i*20+15] <= 1'b0;
                if(i == 0)
                begin
                    dphy_io.rx_clk_lp_p <= phy_gpio_din[4];
                    dphy_io.rx_clk_lp_n <= phy_gpio_din[5];
                    c2p_ctrl[12] <= dphy_io.rx_clk_lp_hs_b;
                end
                else
                begin
                   c2p_ctrl[32] <= 1'b0;
                end
            end
        end 

        always @(*)
        begin
            for(i = 0 ; i < (NUM_LANES+3)/4; i++)
            begin
	       c2p[i*96 + 80 +: 16] = {16{1'b0}};
	       c2p_ctrl[i*20 + 0  +: 8] = {8{1'b0}};
	       c2p_ctrl[i*20 + 16 +: 2] = {2{1'b0}};
	    end	     
        end   
   
    end
    else if (DPHY_TX_EN == 1)
    begin : dphy_tx_inf
        
        logic [IO_CONVERT_RATIO-1:0] mnl_hs_data;
        logic [IO_CONVERT_RATIO-1:0] mnl_hs_clk;
        
        assign mnl_hs_data = { (IO_CONVERT_RATIO/2) { dphy_io.mnl_tx_data_hs } };
        assign mnl_hs_clk = { (IO_CONVERT_RATIO/2) { dphy_io.mnl_tx_clk_hs } };
       
        always @(*)
        begin
            for(i = 0 ; i < BYTE_CNT*4; i++)
            begin
                k = (i>3) ? 1 : 0;
                j = (i%4) > 1 ? (i%4) + 1 : (i%4);
                if(i<NUM_LANES)
                begin
                    c2p[k*96+j*16 +: IO_CONVERT_RATIO] <= dphy_io.mnl_tx_en == 1'b1 ? mnl_hs_data : dphy_io.tx_wr_data[i*IO_CONVERT_RATIO +: IO_CONVERT_RATIO];
                    if(j==4) 
                    begin: gpio_dout_8_9
                        c2p_ctrl[k*20+16] <= dphy_io.mnl_tx_en == 1'b1 ? dphy_io.mnl_tx_data_lp_p : dphy_io.tx_data_lp_p[i];
                        c2p_ctrl[k*20+17] <= dphy_io.mnl_tx_en == 1'b1 ? dphy_io.mnl_tx_data_lp_n : dphy_io.tx_data_lp_n[i];
                    end
                    else
                    begin: gpio_dout_0_7
                        c2p_ctrl[k*20+2*j]   <= dphy_io.mnl_tx_en == 1'b1 ? dphy_io.mnl_tx_data_lp_p : dphy_io.tx_data_lp_p[i];
                        c2p_ctrl[k*20+2*j+1] <= dphy_io.mnl_tx_en == 1'b1 ? dphy_io.mnl_tx_data_lp_n : dphy_io.tx_data_lp_n[i];
                    end
                    if(j < 2)
                    begin: gpio_dout_sel_0_1
                        c2p_ctrl[k*20+18+j] <= dphy_io.mnl_tx_en == 1'b1 ? dphy_io.mnl_tx_data_lp_hs_b[i] : dphy_io.tx_data_lp_hs_b[i];
                    end
                    else
                    begin: gpio_dout_sel_2_4
                        c2p_ctrl[k*20+12+j-2] <= dphy_io.mnl_tx_en == 1'b1 ? dphy_io.mnl_tx_data_lp_hs_b[i] : dphy_io.tx_data_lp_hs_b[i];
                    end
                end
                else
                begin
                    c2p[k*96+j*16 +: IO_CONVERT_RATIO] <= {IO_CONVERT_RATIO{1'b0}};
                    if(j==4)
                    begin
                        c2p_ctrl[k*20+16] <= 1'b0;
                        c2p_ctrl[k*20+17] <= 1'b0;
                    end
                    else
                    begin
                        c2p_ctrl[k*20+2*j]   <= 1'b0;
                        c2p_ctrl[k*20+2*j+1] <= 1'b0;
                    end
                    if(j < 2)
                        c2p_ctrl[k*20+18+j] <= 1'b0;
                    else
                        c2p_ctrl[k*20+12+j-2] <= 1'b0;
                end
            end
        end
        always @(*)
        begin
            for(i = 0 ; i < (NUM_LANES+3)/4; i++)
            begin
                c2p_ctrl[i*20+8 +: 4] <= dphy_io.rx_data_read_en;
                c2p_ctrl[i*20+15] <= 1'b0;  
                if(i==0)
                begin
                    c2p[32 +: IO_CONVERT_RATIO] <=  dphy_io.mnl_tx_en == 1'b1 ? mnl_hs_clk : dphy_io.tx_clk_data[i*IO_CONVERT_RATIO +: IO_CONVERT_RATIO];
                    c2p_ctrl[4]  <= dphy_io.mnl_tx_en == 1'b1 ? dphy_io.mnl_tx_data_lp_p : dphy_io.tx_clk_lp_p;
                    c2p_ctrl[5]  <= dphy_io.mnl_tx_en == 1'b1 ? dphy_io.mnl_tx_data_lp_n : dphy_io.tx_clk_lp_n;                    
                    c2p_ctrl[12] <= dphy_io.mnl_tx_en == 1'b1 ? dphy_io.mnl_tx_clk_lp_hs_b : dphy_io.tx_clk_lp_hs_b;
                end
                else
                begin
                    c2p[96+32 +: IO_CONVERT_RATIO] <= {IO_CONVERT_RATIO{1'b0}};
                    c2p_ctrl[24]  <= 1'b0;
                    c2p_ctrl[25]  <= 1'b0;                    
                    c2p_ctrl[32] <= 1'b0;
                end
            end
        end

        always @(*)
        begin
            for(i = 0 ; i < (NUM_LANES+3)/4; i++)
            begin
	       c2p[i*96 + 80 +: 16] = {16{1'b0}};
	    end	     
        end 

    end

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "EFp3MeAJX/lIDaqlP2bXklYrJ9H4kLxD18of/nu1/yvzD8WAeCSdgm842C29sY+u4jKW4cJhiBbRNxkoZOsJXr0Nl0UlJ2vNeyvx1FnvcIQJ1IOHvsnSV/sCIxLCk2lhGEl8PhdNJMALVPIbEBiGREMWXAMa9WmHpxw3xSZIzUU2Gt9VPV5HnzUgXy8dXsXSELTll6nsjuaaMkUcqpbujl9iNlYf5Wk78osDP8IQggQ5zyym6ZyIa3T9kK/pha0nI//QSYbQDUK8KnVq5tLZm8c3IBtBHPuIBH34KMHdhv7Ji1hsQNDQrcAIFibInpYHrnzNQx0iLPuzX8X/VZik7/Ba+aBNfYOzR1nQY+KKF9H7gGJvUSDKI/gOf3yHK1KC7WTJ2Mo/7d7zjVmA3WOjMEEJPwJuFYO9Ga1c98y/9ogHx1uuB443ssgLNWK0Jt1UT4zb45S13RQStmh8dLdJGngd3u/ky4lyF4kCLywI1DuWV4eoklL5ZxtywSqOkh7M7E/JzHNBhV9mnIM46n39UkDIlZIIr1I6rMrQROUA0yWu9E08T1y/YbWkivqQFOvoEG9EUGS+J3FecTZHDgb7FqgzUHKrq3V6tkZG2Sn+6GF9rFccN8TZ6qmmF5TQO73CFCOHZruz3pY/CsKGKcadNSNfhIdyJ48sisdnE+/mx8iabBVe+UAQcvQASic7UpXwa2ZTD9Ohxk09zmHBoAal9csURSvngDA0XNJC2wB7S/qKy83TM47MLFYzxlaxZlVacq8jJbN2Ua7Auqqoa+er/B2DWenvPofICV1iuZIDRHmL1x7h6v7DnUDOagr/3wpNFt7v1Neo+D1NnF6ux6nyQH7iPfgEhn+q3i0CRYxE6BqV5QsVQHXwqdmpCbUMdfFkIsnd1dIt6Z7m4nV443hOWys+/qz28uQNBRnn+mf/7uk6E7MATU7+qRfFFoGXnYkHjoQndx6mSRn9KCdHlRMEuc1mte7aXGT0kNaq38lQbECpjmXZ6VRGL2p5i0YOG++7"
`endif