 # (C) 2001-2024 Intel Corporation. All rights reserved.
# Your use of Intel Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files from any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Intel Program License Subscription 
# Agreement, Intel FPGA IP License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Intel and sold by 
# Intel or its authorized distributors.  Please refer to the applicable 
# agreement for further details.



package require -exact qsys 21.3

# create the csi2_dphy_sys system
proc do_create_csi2_dphy_sys {} {
    # create the system
    create_system csi2_dphy_sys

    # add the components
    add_instance csi2_rx intel_mipi_csi2
    set_instance_parameter_value csi2_rx BITS_PER_LANE {16}
    set_instance_parameter_value csi2_rx BUFFER_DEPTH {16384}
    set_instance_parameter_value csi2_rx DIRECTION {rx}
    set_instance_parameter_value csi2_rx ENABLE_SCRAMBLING {0}
    set_instance_parameter_value csi2_rx LANE {2}
    set_instance_parameter_value csi2_rx NUMBER_OF_VIDEO_STREAMING_INTERFACES {1}
    set_instance_parameter_value csi2_rx PIXELS_IN_PARALLEL {2}
    set_instance_parameter_value csi2_rx SUPPORT_LEGACY_YUV420_8B {0}
    set_instance_parameter_value csi2_rx SUPPORT_RAW10 {0}
    set_instance_parameter_value csi2_rx SUPPORT_RAW12 {0}
    set_instance_parameter_value csi2_rx SUPPORT_RAW14 {0}
    set_instance_parameter_value csi2_rx SUPPORT_RAW16 {0}
    set_instance_parameter_value csi2_rx SUPPORT_RAW20 {0}
    set_instance_parameter_value csi2_rx SUPPORT_RAW24 {0}
    set_instance_parameter_value csi2_rx SUPPORT_RAW6 {0}
    set_instance_parameter_value csi2_rx SUPPORT_RAW7 {0}
    set_instance_parameter_value csi2_rx SUPPORT_RAW8 {0}
    set_instance_parameter_value csi2_rx SUPPORT_RGB444 {0}
    set_instance_parameter_value csi2_rx SUPPORT_RGB555 {0}
    set_instance_parameter_value csi2_rx SUPPORT_RGB565 {0}
    set_instance_parameter_value csi2_rx SUPPORT_RGB666 {0}
    set_instance_parameter_value csi2_rx SUPPORT_RGB888 {1}
    set_instance_parameter_value csi2_rx SUPPORT_YUV420_10B {0}
    set_instance_parameter_value csi2_rx SUPPORT_YUV420_8B {0}
    set_instance_parameter_value csi2_rx SUPPORT_YUV422_10B {0}
    set_instance_parameter_value csi2_rx SUPPORT_YUV422_8B {0}
    set_instance_parameter_value csi2_rx USE_CONTINUOUS_CLK {true}
    set_instance_parameter_value csi2_rx VIDEO_INTERFACE_MODE {simple}


    add_instance mipi_dphy mipi_dphy
    set_instance_parameter_value mipi_dphy EX_DESIGN_GEN_SYNTH {0}
    set_instance_parameter_value mipi_dphy GUI_CORE_CLK_DIV_0 {8}
    set_instance_parameter_value mipi_dphy GUI_REF_CLK_FREQ_MHZ_0 {100.0}
    set_instance_parameter_value mipi_dphy GUI_VCO_FREQ_MHZ_0 {1200.0}
    set_instance_parameter_value mipi_dphy GUI_DPHY_IP_ROLE_0 {0}
    set_instance_parameter_value mipi_dphy GUI_BIT_RATE_MBPS_RNG_0 {2400.0}
    set_instance_parameter_value mipi_dphy GUI_PPI_WIDTH_USR_0 {16}
    set_instance_parameter_value mipi_dphy GUI_NUM_LANES_0 {2}
    set_instance_parameter_value mipi_dphy GUI_CONTINUOUS_CLK_0 {true}
    set_instance_parameter_value mipi_dphy GUI_BYTE_LOC_0 {0}

    # Reset Release
    add_instance reset_release_0 intel_user_rst_clkgate
    set_instance_parameter_value reset_release_0 outputType {Reset Interface}

    # Clock Bridge for axi clock
    add_instance rx_axi4s_clk_bridge altera_clock_bridge
    set_instance_parameter_value rx_axi4s_clk_bridge {EXPLICIT_CLOCK_RATE} {300000000.0}

    # add the connections
    add_connection mipi_dphy.LINK0_link_core_clk/mipi_dphy.reg_clk

    # CLOCK BRIDGE
    add_connection rx_axi4s_clk_bridge.out_clk/csi2_rx.axi4s_clk

    # RESET RELEASE
    add_connection reset_release_0.ninit_done/csi2_rx.axi4s_rst
    add_connection reset_release_0.ninit_done/mipi_dphy.arst
    add_connection reset_release_0.ninit_done/mipi_dphy.reg_srst

    # CLOCK LANE
    # RX
    add_connection csi2_rx.ck_ppi_hs/mipi_dphy.LINK0_CK_ppi_rx_hs
    add_connection csi2_rx.ck_ppi_lp/mipi_dphy.LINK0_CK_ppi_rx_lp
    add_connection csi2_rx.i_ck_ppi_rx_err/mipi_dphy.LINK0_CK_ppi_rx_err
    add_connection mipi_dphy.LINK0_CK_ppi_ctrl/csi2_rx.ck_ppi_ctrl
    add_connection mipi_dphy.LINK0_CK_ppi_rx_hs_clk/csi2_rx.ck_ppi_hs_clk
    add_connection mipi_dphy.LINK0_CK_ppi_rx_hs_srst/csi2_rx.ck_ppi_rx_hs_srst

    # For RX+TX Qsys Subsystem

    # DATA LANES
    # RX
    add_connection csi2_rx.d0_ppi_hs/mipi_dphy.LINK0_D0_ppi_rx_hs
    add_connection csi2_rx.d0_ppi_lp/mipi_dphy.LINK0_D0_ppi_rx_lp
    add_connection csi2_rx.i_d0_ppi_rx_err/mipi_dphy.LINK0_D0_ppi_rx_err
    add_connection mipi_dphy.LINK0_D0_ppi_ctrl/csi2_rx.d0_ppi_ctrl
    add_connection mipi_dphy.LINK0_D0_ppi_rx_hs_clk/csi2_rx.d0_ppi_hs_clk
    add_connection mipi_dphy.LINK0_D0_ppi_rx_hs_srst/csi2_rx.d0_ppi_rx_hs_srst

    # For RX+TX Qsys Subsystem
    # RX
    add_connection csi2_rx.d1_ppi_hs/mipi_dphy.LINK0_D1_ppi_rx_hs
    add_connection csi2_rx.d1_ppi_lp/mipi_dphy.LINK0_D1_ppi_rx_lp
    add_connection csi2_rx.i_d1_ppi_rx_err/mipi_dphy.LINK0_D1_ppi_rx_err
    add_connection mipi_dphy.LINK0_D1_ppi_ctrl/csi2_rx.d1_ppi_ctrl
    add_connection mipi_dphy.LINK0_D1_ppi_rx_hs_clk/csi2_rx.d1_ppi_hs_clk
    add_connection mipi_dphy.LINK0_D1_ppi_rx_hs_srst/csi2_rx.d1_ppi_rx_hs_srst

    # For RX+TX Qsys Subsystem

    # add the exports
    foreach instance [get_instances] {
        foreach interface [get_instance_interfaces $instance] {
            if { [get_connections ${instance}.${interface}] == "" } {
                set_interface_property ${instance}_${interface} EXPORT_OF ${instance}.${interface}
            }
        }
    }

    # save the system
    sync_sysinfo_parameters
    save_system csi2_dphy_sys
}

# create all the systems, from bottom up
do_create_csi2_dphy_sys


