//--AutoFous-------
module FOCUS_ADJ (
input              AUTO_FOC,       //
input              AUTO_OPEN,
output      [15:0] VCM_DATA, 
output             VCM_END ,
output       [9:0] STEP ,

input             CLK_50 , 
input             RESET_N ,      
input             RESET_SUB_N ,   //


input             SW_Y,           //
input             SW_H_FREQ,      //     
input             SW_FUC_ALL_CEN, // 
input             SW_FUC_LINE ,   // 
     
input             VS_NS   ,
input             HS_NS   ,
input             VIDEO_CLK,
input             VIDEO_DE , 
input   [7:0]     iR , 
input   [7:0]     iG , 
input   [7:0]     iB , 

output  reg [7:0] oR , 
output  reg [7:0] oG , 
output  reg [7:0] oB , 
output            SCL , 
inout             SDA , 
output [9:0]      STATUS 

);
//=============================================================================
// REG/WIRE declarations
//=============================================================================
wire   [7:0] S  ; 
wire  [17:0] Y  ; 
wire         ACTIV_C; 
wire         ACTIV_V; 
 

LCD_COUNTER  u_LCD_COUNTER(
       .CLK      ( VIDEO_CLK ),
       .VS       ( VS_NS), 
       .HS       ( HS_NS), 
		 .DE       ( VIDEO_DE ) , 
       .V_CNT    ( V_CNT) ,
       .H_CNT    ( H_CNT) ,
       .LINE     ( LINE ),
       .ACTIV_C  ( ACTIV_C ),
       .ACTIV_V  ( ACTIV_V )
) ; 

//----VCM_STEP CONTROL & PIXEL HIGH_Statistics
VCM_CTRL_P u_VCM_CTRL_P(
        .iR           ( iR),
        .iG           ( iG),
        .iB           ( iB),
        .VS           ( VS_NS    ), // VS_
        .HS           ( HS_NS    ), // HS_
        .ACTIV_C      ( ACTIV_C  ),
        .ACTIV_V      ( ACTIV_V  ),
        .VIDEO_CLK    ( VIDEO_CLK),  
        .SW_FUC_ALL_CEN( SW_FUC_ALL_CEN) ,
        .Y            ( Y ),
        .S            ( S ),
        .STEP         ( STEP        ),
        .AUTO_FOC     ( AUTO_FOC    ), 
        .AUTO_OPEN	 ( AUTO_OPEN   ),   
        .VCM_END      ( VCM_END     ),		  
        .VCM_DATA     ( VCM_DATA    )

);

assign STATUS[9:0]  = { VCM_END , STEP[6:0] ,SCL,SDA  } ;
                                             
	 
//-----VIDEO MIXED  -- 
always @( posedge VIDEO_CLK ) 
   {oR, oG, oB}  <=    
   ((SW_FUC_LINE &  LINE )  ||  ( SW_FUC_ALL_CEN  &  ( ~VCM_END  &  LINE) ) )?  {8'hFF, 8'hFF, 8'h0} : 
   ( !SW_Y )?  //( ACTIV_C ? 24'h555555 :  
	{ iR, iG, iB }   : 
   (SW_H_FREQ)?  { 
     Y[15:8 ],
     Y[15:8 ],
     Y[15:8 ]
   } :
   {
	   S[7:0],
	   S[7:0],
	   S[7:0]
	 };
	 
endmodule 
	 