// ============================================================================
// Copyright (c) 2024 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================

#include <stdio.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <sys/alt_alarm.h> // time tick function (alt_nticks(), alt_ticks_per_second())
#include "system.h"
#include "io.h"
#include "mem_verify.h"


typedef bool (*LP_VERIFY_FUNC)(void);


bool TEST_DDR4(void);
bool TEST_DDR4_QUICK(void);

typedef struct{
    LP_VERIFY_FUNC func;
    char szName[128];
}FUNC_INFO;

FUNC_INFO szFuncList[] = {
	{TEST_DDR4,         "LPDDR4x2 Test"},
	{TEST_DDR4_QUICK,   "LPDDR4x2 Quick Test"},

};

void GUI_ShowMenu(void){
    int nNum,i;

    nNum = sizeof(szFuncList)/sizeof(szFuncList[0]);
    printf("======= Agilex 5 NIOS LPDDR4x2 Program =======\r\n");
    for(i=0;i<nNum;i++){
        printf("[%d] %s\r\n", i, szFuncList[i].szName);
    }
    printf("Input your chioce:");
}

int GUI_QueryUser(void){
    int nChoice = 0;
    scanf("%d", &nChoice);
    printf("%d\r\n", nChoice);
    return nChoice;
}

//===============================================================
int main(void){
    int nChoice;
    int nNum;
    bool bPass;

    nNum = sizeof(szFuncList)/sizeof(szFuncList[0]);
    while(1){
    	GUI_ShowMenu();
        nChoice = GUI_QueryUser();
        if (nChoice >= 0 && nChoice < nNum){
            bPass = szFuncList[nChoice].func();
            printf("%s Test:%s\r\n", szFuncList[nChoice].szName, bPass?"PASS":"NG");
        }
    }

}


bool TEST_DDR4(void){
	bool bPassA, bPassB, bLoop;
	bool bPassSubA[32], bPassSubB[32];
	int TestIndex ;
	alt_u32 InitValue = 0x01;
	bool bShowMessage = true;
	alt_u32 TimeStart, TimeElapsed;
	alt_u16 ButtonStatus;
	const alt_u8 ButtonMask = 0x03; // 2 key (based on PIO_KEY_DATA_WIDTH 2)
	alt_u64 span_base;
	alt_u32 span_base_lo, span_base_hi;
	alt_u32 i;
	const int nSubBankNum_A = 1; // LPDDR4A has 1GB (1 sub-bank)
	const int nSubBankNum_B = 1; // LPDDR4B has 1GB (1 sub-bank)




	printf("===== LPDDR4x2 Test! Size=A: 1GB, B: 1GB =====\r\n");

        printf("\n==========================================================\n");

        printf("Press any BUTTON on the board to start test [BUTTON-0 for continued test] \n");
        ButtonStatus = ButtonMask;
        while((ButtonStatus & ButtonMask) == ButtonMask){
        	ButtonStatus = IORD(PIO_KEY_BASE, 0);
        	//ButtonStatus = 0x01;
        }


        if ((ButtonStatus & 0x01) == 0x00){
            bLoop = true;
        }else{
            bLoop = false;
            usleep(300*1000);
        }


		//
        bPassA = true;
        bPassB = true;
        TestIndex = 0;

        do{
        	TestIndex++;
        	printf("=====> LPDDR4x2 Testing, Iteration: %d\n", TestIndex);

        	TimeStart = alt_nticks();

        	////////////////////////////
        	// Testing //
        	// LPDDR4-A
        	TimeStart = alt_nticks();
        	printf("== LPDDR4-A Testing...\r\n");

        	if (bPassA) {
        		for (i = 0; i < nSubBankNum_A; i++){
        			printf("LPDDR4A address bank: %dGB ~ %dGB: \r\n", i, i + 1);
        			span_base = (alt_u64)0x0; // LPDDR4A starts at 0x0

        			span_base_lo = span_base & 0xffffffff;
        			span_base_hi = (span_base >> 32) & 0xffffffff;
        			IOWR(ADDRESS_SPAN_EXTENDER_CNTL_BASE, 0, span_base_lo);
        			IOWR(ADDRESS_SPAN_EXTENDER_CNTL_BASE, 1, span_base_hi);


            		bPassSubA[i] = TMEM_Verify(ADDRESS_SPAN_EXTENDER_WINDOWED_SLAVE_BASE, ADDRESS_SPAN_EXTENDER_WINDOWED_SLAVE_SPAN, InitValue << i,  bShowMessage);
        			bPassA = bPassA && bPassSubA[i];
        		}
        	}

        	TimeElapsed = alt_nticks() - TimeStart;
        	printf("LPDDR4A test:%s, %d seconds\r\n", bPassA ? "Pass" : "NG", (int)(TimeElapsed/alt_ticks_per_second()));


        	////////////////////////////
        	// LPDDR4-B
        	TimeStart = alt_nticks();
        	printf("== LPDDR4-B Testing...\r\n");

        	if (bPassB) {
        		for (i = 0; i < nSubBankNum_B; i++){
        			printf("LPDDR4B address bank: %dGB ~ %dGB: \r\n", i, i + 1);
        			span_base = (alt_u64)ADDRESS_SPAN_EXTENDER_WINDOWED_SLAVE_SPAN; // LPDDR4B starts at 0x40000000
        			span_base_lo = span_base & 0xffffffff;
        			span_base_hi = (span_base >> 32) & 0xffffffff;
        			IOWR(ADDRESS_SPAN_EXTENDER_CNTL_BASE, 0, span_base_lo);
        			IOWR(ADDRESS_SPAN_EXTENDER_CNTL_BASE, 1, span_base_hi);

            		bPassSubB[i] = TMEM_Verify(ADDRESS_SPAN_EXTENDER_WINDOWED_SLAVE_BASE, ADDRESS_SPAN_EXTENDER_WINDOWED_SLAVE_SPAN, InitValue << i,  bShowMessage);
        			bPassB = bPassB && bPassSubB[i];
        		}
        	}

        	TimeElapsed = alt_nticks() - TimeStart;
        	printf("LPDDR4B test:%s, %d seconds\r\n", bPassB ? "Pass" : "NG", (int)(TimeElapsed/alt_ticks_per_second()));


            if (bPassA && bPassB && bLoop){  // is abort loop?
            	ButtonStatus = IORD(PIO_KEY_BASE, 0);
            	if ((ButtonStatus & ButtonMask) != ButtonMask)
            		bLoop = false; // press any key to abort continued test
            }


        }while(bLoop && bPassA && bPassB);

    return bPassA;
}



bool TEST_DDR4_QUICK(void){
	bool bPassA, bPassB, bLoop;
	bool bPassSubA[32], bPassSubB[32];
	int TestIndex ;
	alt_u32 TimeStart, TimeElapsed;
	alt_u16 ButtonStatus;
	const alt_u8 ButtonMask = 0x03; // 2 key (based on PIO_KEY_DATA_WIDTH 2)
	alt_u64 span_base;
	alt_u32 span_base_lo, span_base_hi;
	alt_u32 i;
	const int nSubBankNum_A = 1; // LPDDR4A has 1GB (1 sub-bank)
	const int nSubBankNum_B = 1; // LPDDR4B has 1GB (1 sub-bank)


	printf("===== LPDDR4x2 Test! Size=A: 1GB, B: 1GB =====\r\n");

        printf("\n==========================================================\n");

        printf("Press any BUTTON on the board to start test [BUTTON-0 for continued test] \n");
        ButtonStatus = ButtonMask;
        while((ButtonStatus & ButtonMask) == ButtonMask){
        	ButtonStatus = IORD(PIO_KEY_BASE, 0);
        	//ButtonStatus = 0x01;
        }

        if ((ButtonStatus & 0x01) == 0x00){
            bLoop = true;
        }else{
            bLoop = false;
            usleep(300*1000);
        }


		//
        bPassA = true;
        bPassB = true;
        TestIndex = 0;

        do{
        	TestIndex++;
        	printf("=====> LPDDR4x2 Testing, Iteration: %d\n", TestIndex);


        	TimeStart = alt_nticks();


        	////////////////////////////
        	// Testing //
        	// LPDDR4-A
        	TimeStart = alt_nticks();
        	printf("== LPDDR4-A Testing...\r\n");

        	if (bPassA){
        		for (i = 0; i < nSubBankNum_A; i++){
        			printf("LPDDR4A address bank: %dGB ~ %dGB: ", i, i + 1);
        			span_base = (alt_u64)0x0; // LPDDR4A starts at 0x0
        			span_base_lo = span_base & 0xffffffff;
        			span_base_hi = (span_base >> 32) & 0xffffffff;
        			IOWR(ADDRESS_SPAN_EXTENDER_CNTL_BASE, 0, span_base_lo);
        			IOWR(ADDRESS_SPAN_EXTENDER_CNTL_BASE, 1, span_base_hi);

            		bPassSubA[i] = TMEM_QuickVerify(ADDRESS_SPAN_EXTENDER_WINDOWED_SLAVE_BASE, ADDRESS_SPAN_EXTENDER_WINDOWED_SLAVE_SPAN, 32,  28);
        			bPassA = bPassA && bPassSubA[i];



        		}
        	}

        	TimeElapsed = alt_nticks() - TimeStart;
        	printf("LPDDR4A test:%s, %d seconds\r\n", bPassA ? "Pass" : "NG", (int)(TimeElapsed/alt_ticks_per_second()));


        	////////////////////////////
        	// LPDDR4-B
        	TimeStart = alt_nticks();
        	printf("== LPDDR4-B Testing...\r\n");
        	if (bPassB) {
        		for (i = 0; i < nSubBankNum_B; i++){
        			printf("LPDDR4B address bank: %dGB ~ %dGB: ", i, i + 1);
        			span_base = (alt_u64)ADDRESS_SPAN_EXTENDER_WINDOWED_SLAVE_SPAN; // LPDDR4B starts at 0x40000000
        			span_base_lo = span_base & 0xffffffff;
        			span_base_hi = (span_base >> 32) & 0xffffffff;
        			IOWR(ADDRESS_SPAN_EXTENDER_CNTL_BASE, 0, span_base_lo);
        			IOWR(ADDRESS_SPAN_EXTENDER_CNTL_BASE, 1, span_base_hi);

            		bPassSubB[i] = TMEM_QuickVerify(ADDRESS_SPAN_EXTENDER_WINDOWED_SLAVE_BASE, ADDRESS_SPAN_EXTENDER_WINDOWED_SLAVE_SPAN, 32,  28);
        			bPassB = bPassB && bPassSubB[i];


        		}
        	}

        	TimeElapsed = alt_nticks() - TimeStart;
        	printf("LPDDR4B test:%s, %d seconds\r\n", bPassB ? "Pass" : "NG", (int)(TimeElapsed/alt_ticks_per_second()));


            if (bPassA && bPassB && bLoop){  // is abort loop?
            	ButtonStatus = IORD(PIO_KEY_BASE, 0);
            	if ((ButtonStatus & ButtonMask) != ButtonMask)
            		bLoop = false; // press any key to abort continued test
            }


        }while(bLoop && bPassA && bPassB);


    return bPassA;
}
