// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// $File: //acds/rel/25.1.1/ip/iconnect/avalon_st/altera_avalon_dc_fifo/altera_dcfifo_synchronizer_bundle.v $
// $Revision: #1 $
// $Date: 2025/04/24 $
// $Author: psgswbuild $
//-------------------------------------------------------------------------------

`timescale 1 ns / 1 ns
module altera_dcfifo_synchronizer_bundle(
                                     clk,
                                     reset_n,
                                     din,
                                     dout
                                     );
   parameter WIDTH = 1;
   parameter DEPTH = 3;   
   parameter retiming_reg_en = 0;

   input clk;
   input reset_n;
   input [WIDTH-1:0] din;
   output [WIDTH-1:0] dout;
   
   genvar i;
   
   generate
      for (i=0; i<WIDTH; i=i+1)
        begin : sync
           altera_std_synchronizer_nocut #(.depth(DEPTH), .retiming_reg_en(retiming_reg_en))
                                   u (
                                      .clk(clk), 
                                      .reset_n(reset_n), 
                                      .din(din[i]), 
                                      .dout(dout[i])
                                      );
        end
   endgenerate
   
endmodule 

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "wQtgtvKqJWgrzDkwk9GAB3thpTs1dbdVeXyagZEhYTY0TMU8uc8IINKw+JyOf/7B8h8x4eAHQa1nQuclXFA1+de6umTnjzgDN7g0Vp7/b+0JZRjeFjZ29eSUCyTa4mf28hxqY5qEFP2+jg3PI70fs5Wkg+PZ005d8LkvRNfNZpGJPIH6A/rnn76qg5DXUAcXqp/MHAFYqQimdC2Ohgkg3svZ3yq0mcf7iSWH62kEwycHcCwmqp9kmPAc9i3KrkPN89XB9d6gX0nwlnW1XYnEXCWXQ70PPwvDtYWfmllYIG+wUmISMP5ioBPGNGJuYqU5wM3AxfR/vKFieYkA3ga31/7/8Es90nwq2FkA50WVgWZaYhI4wD9OTEOJasMvZ7ntMhxPo6vZF9iBRxln+Vnv+MRt45kRKqyUlp3IIbCYy57prW6M/SRY2jdQaWIr9MimFsPzXz9Dh5++PnmCGadqe+9qcJLLIg6qAYI4+xuCrjTiQbnekNHM/mhR143oYnRrf6fE3ifaiIBM6ygp72Rbq7hrLE3qlxKh3F+fwxtpS1Ba8EtBp2tG3Ryz8MRIzGSIsYXZ53h3/+9ywFqLefAulYVMad6xFpuqLb0kyOmZlK/YIEd2NY3BEBek6VEZTAsVe/T8St05whXAx2k3KmwWMbRRRSvcj0OhPg46CueUqgyr3J2VxQYSmMw9tYcfH1XBryI8hoqRmIcRXB1YA9wxFiL9KmjCULA7XXk+lo1dZU6RLe1ouysa5Gt1ZGvMdCuW3UiF0sQWOrubolbuJmP3vWk6y5ar9mP6E8vgIEjFjBLKIlyXDzAyLuWLG+qjTN7aFNQ47DaEuuyifepggYccV3OAzp1m6enVcEPq+0Oma1/PlDaGHufpTurbQ/tRvsEbJp7bDiNXugOhVwZll64aF7fccBXpAr8pZ5lY5djG40h0IylYIk/iCJLdUYurPUMRpdjNESPpMUvHcr6fYj6UaSDBnLR69y1twzlVfseX9ZbYasuWEICRh1Rj2e/k53oo"
`endif