// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Tue May  6 11:16:28 2025
// ============================================================================

`define ENABLE_LPDDR4A
`define ENABLE_LPDDR4B
//`define ENABLE_HPS
//`define ENABLE_CAM

module golden_top(

      ///////// CLOCK /////////
      input              CLOCK0_50,
      input              CLOCK1_50,
      input              CLOCK2_50,

      ///////// KEY /////////
      input    [ 1: 0]   KEY, //BUTTON is Low-Active

      ///////// SW /////////
      input    [ 3: 0]   SW,

      ///////// LED /////////
      output   [ 7: 0]   LED,

      ///////// SDRAM /////////
      output             DRAM_CLK,
      output             DRAM_CKE,
      output   [12: 0]   DRAM_ADDR,
      output   [ 1: 0]   DRAM_BA,
      inout    [15: 0]   DRAM_DQ,
      output             DRAM_LDQM,
      output             DRAM_UDQM,
      output   [ 1: 0]   DRAM_CS_n,
      output             DRAM_WE_n,
      output             DRAM_CAS_n,
      output             DRAM_RAS_n,

`ifdef ENABLE_LPDDR4A
      ///////// LPDDR4A /////////
      input              LPDDR4A_REFCLK_p,
      output             LPDDR4A_CS_n,
      output   [ 5: 0]   LPDDR4A_CA,
      output             LPDDR4A_CK,
      output             LPDDR4A_CKE,
      output             LPDDR4A_CK_n,
      inout    [ 3: 0]   LPDDR4A_DM,
      inout    [31: 0]   LPDDR4A_DQ,
      inout    [ 3: 0]   LPDDR4A_DQS,
      inout    [ 3: 0]   LPDDR4A_DQS_n,
      output             LPDDR4A_RESET_n,
      input              LPDDR4A_RZQ,
`endif /*ENABLE_LPDDR4A*/

`ifdef ENABLE_LPDDR4B
      ///////// LPDDR4B /////////
      input              LPDDR4B_REFCLK_p,
      output             LPDDR4B_CS_n,
      output   [ 5: 0]   LPDDR4B_CA,
      output             LPDDR4B_CK,
      output             LPDDR4B_CKE,
      output             LPDDR4B_CK_n,
      inout    [ 3: 0]   LPDDR4B_DM,
      inout    [31: 0]   LPDDR4B_DQ,
      inout    [ 3: 0]   LPDDR4B_DQS,
      inout    [ 3: 0]   LPDDR4B_DQS_n,
      output             LPDDR4B_RESET_n,
      input              LPDDR4B_RZQ,
`endif /*ENABLE_LPDDR4B*/

      ///////// HDMI /////////
      inout              HDMI_LRCLK,
      inout              HDMI_MCLK,
      inout              HDMI_SCLK,
      output             HDMI_TX_CLK,
      output             HDMI_TX_HS,
      output             HDMI_TX_VS,
      output   [23: 0]   HDMI_TX_D,
      output             HDMI_TX_DE,
      inout              HDMI_I2C_SCL,
      inout              HDMI_I2C_SDA,
      input              HDMI_TX_INT,
      inout              HDMI_I2S,

`ifdef ENABLE_CAM
      ///////// CAM /////////
      input              CAM_CLK_p,
      input              CAM_CLK_n,
      input    [ 1: 0]   CAM_D_p,
      input    [ 1: 0]   CAM_D_n,
      inout              CAM_I2C_SCL,
      inout              CAM_I2C_SDA,
      inout              CAM_GPIO,
      input              CAM_RZQ1,
`endif /*ENABLE_CAM*/

      ///////// FPGA UART /////////
      output             FPGA_UART_TX,
      input              FPGA_UART_RX,

      ///////// ADC /////////
      output             ADC_SCK,
      input              ADC_SDO,
      output             ADC_SDI,
      output             ADC_CS_n,

      ///////// GPIO /////////
      inout    [35: 0]   GPIO0_D,
      inout    [35: 0]   GPIO1_D,

`ifdef ENABLE_HPS
      ///////// HPS /////////
      input              HPS_CLK_25,
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      inout              HPS_GSENSOR_I2C_EN,
      inout              HPS_GSENSOR_INT,
      inout              HPS_I2C_SCL,
      inout              HPS_I2C_SDA,
      inout              HPS_KEY,
      inout              HPS_LED,
      output             HPS_SD_CLK,
      inout              HPS_SD_CMD,
      inout    [ 3: 0]   HPS_SD_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
`endif /*ENABLE_HPS*/

      ///////// FAN /////////
      input              FAN_ALERT_n

);


//=======================================================
//  REG/WIRE declarations
//=======================================================

wire AXI_LITE_CLK;
wire LPDDR4_IOPLL_Lock;

wire LPDDR4A_AXI_Ready_ctrl;
wire LPDDR4B_AXI_Ready_ctrl;


//=======================================================
//  Structural coding
//=======================================================


wire ninit_done;
    reset_release reset_release_inst (
        .ninit_done (ninit_done)  //  output,  width = 1, ninit_done.ninit_done
    );
		

parameter AXIL_DRIVER_ADDRESS_WIDTH = 27; 

/////////////////// LPDDR4(A) Test ///////////////////	  
//LPDDR4A Calibration (AXI-Lite)
wire  												LPDDR4A_axil_driver_clk;
wire  												LPDDR4A_axil_driver_rst_n;
wire  [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]	LPDDR4A_axil_driver_araddr;
wire  [2:0]											LPDDR4A_axil_driver_arprot;
wire  												LPDDR4A_axil_driver_arvalid;
wire  												LPDDR4A_axil_driver_arready;
wire  [31:0]										LPDDR4A_axil_driver_rdata;
wire  [1:0]											LPDDR4A_axil_driver_rresp;
wire  												LPDDR4A_axil_driver_rvalid;
wire                                      LPDDR4A_axil_driver_rready;
wire   [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]  LPDDR4A_axil_driver_awaddr;
wire   [2:0]                              LPDDR4A_axil_driver_awprot;
wire                                      LPDDR4A_axil_driver_awvalid;
wire                                      LPDDR4A_axil_driver_awready;
wire   [31:0]                             LPDDR4A_axil_driver_wdata;
wire   [3:0]                              LPDDR4A_axil_driver_wstrb;
wire                                      LPDDR4A_axil_driver_wvalid;
wire                                      LPDDR4A_axil_driver_wready;
wire   [1:0]                              LPDDR4A_axil_driver_bresp;
wire                                      LPDDR4A_axil_driver_bvalid;
wire                                      LPDDR4A_axil_driver_bready;
wire													LPDDR4A_cal_done_rst_n;

 
axil_driver_calibration LPDDR4A_axil_driver_calibration_Inst(

   /*input    wire                                         */    .axil_driver_clk(AXI_LITE_CLK),
   /*input    wire                                         */    .axil_driver_rst_n(LPDDR4_IOPLL_Lock),
   /*output   wire     [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]   */    .axil_driver_araddr(LPDDR4A_axil_driver_araddr),
   /*output   wire     [2:0]                               */    .axil_driver_arprot(LPDDR4A_axil_driver_arprot),
   /*output   wire                                         */    .axil_driver_arvalid(LPDDR4A_axil_driver_arvalid),
   /*input    wire                                         */    .axil_driver_arready(LPDDR4A_axil_driver_arready),
   /*input    wire     [31:0]                              */    .axil_driver_rdata(LPDDR4A_axil_driver_rdata),
   /*input    wire     [1:0]                               */    .axil_driver_rresp(LPDDR4A_axil_driver_rresp),
   /*input    wire                                         */    .axil_driver_rvalid(LPDDR4A_axil_driver_rvalid),
	
   /*output   wire                                         */    .axil_driver_rready(LPDDR4A_axil_driver_rready),
   /*output   wire     [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]   */    .axil_driver_awaddr(LPDDR4A_axil_driver_awaddr),
   /*output   wire     [2:0]                               */    .axil_driver_awprot(LPDDR4A_axil_driver_awprot),
   /*output   wire                                         */    .axil_driver_awvalid(LPDDR4A_axil_driver_awvalid),
   /*input    wire                                         */    .axil_driver_awready(LPDDR4A_axil_driver_awready),
   /*output   wire     [31:0]                              */    .axil_driver_wdata(LPDDR4A_axil_driver_wdata),
   /*output   wire     [3:0]                               */    .axil_driver_wstrb(LPDDR4A_axil_driver_wstrb),
   /*output   wire                                         */    .axil_driver_wvalid(LPDDR4A_axil_driver_wvalid),
   /*input    wire                                         */    .axil_driver_wready(LPDDR4A_axil_driver_wready),
   /*input    wire     [1:0]                               */    .axil_driver_bresp(LPDDR4A_axil_driver_bresp),
   /*input    wire                                         */    .axil_driver_bvalid(LPDDR4A_axil_driver_bvalid),
   /*output   wire                                         */    .axil_driver_bready(LPDDR4A_axil_driver_bready),
   /*output   wire                                         */    .cal_done_rst_n(LPDDR4A_cal_done_rst_n)
	
);
defparam LPDDR4A_axil_driver_calibration_Inst.AXIL_DRIVER_ADDRESS_WIDTH = AXIL_DRIVER_ADDRESS_WIDTH; 
  
  	 

/////////////////// LPDDR4(B) Test ///////////////////	  
//LPDDR4B Calibration (AXI-Lite)
wire  												LPDDR4B_axil_driver_clk;
wire  												LPDDR4B_axil_driver_rst_n;
wire  [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]	LPDDR4B_axil_driver_araddr;
wire  [2:0]											LPDDR4B_axil_driver_arprot;
wire  												LPDDR4B_axil_driver_arvalid;
wire  												LPDDR4B_axil_driver_arready;
wire  [31:0]										LPDDR4B_axil_driver_rdata;
wire  [1:0]											LPDDR4B_axil_driver_rresp;
wire  												LPDDR4B_axil_driver_rvalid;
wire                                      LPDDR4B_axil_driver_rready;
wire   [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]  LPDDR4B_axil_driver_awaddr;
wire   [2:0]                              LPDDR4B_axil_driver_awprot;
wire                                      LPDDR4B_axil_driver_awvalid;
wire                                      LPDDR4B_axil_driver_awready;
wire   [31:0]                             LPDDR4B_axil_driver_wdata;
wire   [3:0]                              LPDDR4B_axil_driver_wstrb;
wire                                      LPDDR4B_axil_driver_wvalid;
wire                                      LPDDR4B_axil_driver_wready;
wire   [1:0]                              LPDDR4B_axil_driver_bresp;
wire                                      LPDDR4B_axil_driver_bvalid;
wire                                      LPDDR4B_axil_driver_bready;
wire													LPDDR4B_cal_done_rst_n;

 
axil_driver_calibration LPDDR4B_axil_driver_calibration_Inst(

   /*input    wire                                         */    .axil_driver_clk(AXI_LITE_CLK),
   /*input    wire                                         */    .axil_driver_rst_n(LPDDR4_IOPLL_Lock),
   /*output   wire     [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]   */    .axil_driver_araddr(LPDDR4B_axil_driver_araddr),
   /*output   wire     [2:0]                               */    .axil_driver_arprot(LPDDR4B_axil_driver_arprot),
   /*output   wire                                         */    .axil_driver_arvalid(LPDDR4B_axil_driver_arvalid),
   /*input    wire                                         */    .axil_driver_arready(LPDDR4B_axil_driver_arready),
   /*input    wire     [31:0]                              */    .axil_driver_rdata(LPDDR4B_axil_driver_rdata),
   /*input    wire     [1:0]                               */    .axil_driver_rresp(LPDDR4B_axil_driver_rresp),
   /*input    wire                                         */    .axil_driver_rvalid(LPDDR4B_axil_driver_rvalid),
	
   /*output   wire                                         */    .axil_driver_rready(LPDDR4B_axil_driver_rready),
   /*output   wire     [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]   */    .axil_driver_awaddr(LPDDR4B_axil_driver_awaddr),
   /*output   wire     [2:0]                               */    .axil_driver_awprot(LPDDR4B_axil_driver_awprot),
   /*output   wire                                         */    .axil_driver_awvalid(LPDDR4B_axil_driver_awvalid),
   /*input    wire                                         */    .axil_driver_awready(LPDDR4B_axil_driver_awready),
   /*output   wire     [31:0]                              */    .axil_driver_wdata(LPDDR4B_axil_driver_wdata),
   /*output   wire     [3:0]                               */    .axil_driver_wstrb(LPDDR4B_axil_driver_wstrb),
   /*output   wire                                         */    .axil_driver_wvalid(LPDDR4B_axil_driver_wvalid),
   /*input    wire                                         */    .axil_driver_wready(LPDDR4B_axil_driver_wready),
   /*input    wire     [1:0]                               */    .axil_driver_bresp(LPDDR4B_axil_driver_bresp),
   /*input    wire                                         */    .axil_driver_bvalid(LPDDR4B_axil_driver_bvalid),
   /*output   wire                                         */    .axil_driver_bready(LPDDR4B_axil_driver_bready),
   /*output   wire                                         */    .cal_done_rst_n(LPDDR4B_cal_done_rst_n)
	
);
defparam LPDDR4B_axil_driver_calibration_Inst.AXIL_DRIVER_ADDRESS_WIDTH = AXIL_DRIVER_ADDRESS_WIDTH; 


    Qsys Qsys_Inst (
        .clk_clk                                  (CLOCK0_50),                                  //   input,   width = 1,                              clk.clk
        .emif_lpddr4a_core_init_n_reset_n         (LPDDR4A_cal_done_rst_n),         //   input,   width = 1,         emif_lpddr4a_core_init_n.reset_n
        .emif_lpddr4a_s0_axi4_ctrl_ready_reset_n  (LPDDR4A_AXI_Ready_ctrl),  //  output,   width = 1,  emif_lpddr4a_s0_axi4_ctrl_ready.reset_n
        .emif_lpddr4a_s0_axi4lite_clock_clk       (AXI_LITE_CLK),       //   input,   width = 1,   emif_lpddr4a_s0_axi4lite_clock.clk
        .emif_lpddr4a_s0_axi4lite_reset_n_reset_n (LPDDR4_IOPLL_Lock), //   input,   width = 1, emif_lpddr4a_s0_axi4lite_reset_n.reset_n
        .emif_lpddr4a_s0_axi4lite_awaddr          (LPDDR4A_axil_driver_awaddr),          //   input,  width = 27,         emif_lpddr4a_s0_axi4lite.awaddr
        .emif_lpddr4a_s0_axi4lite_awprot          (LPDDR4A_axil_driver_awprot),          //   input,   width = 3,                                 .awprot
        .emif_lpddr4a_s0_axi4lite_awvalid         (LPDDR4A_axil_driver_awvalid),         //   input,   width = 1,                                 .awvalid
        .emif_lpddr4a_s0_axi4lite_awready         (LPDDR4A_axil_driver_awready),         //  output,   width = 1,                                 .awready
        .emif_lpddr4a_s0_axi4lite_araddr          (LPDDR4A_axil_driver_araddr),          //   input,  width = 27,                                 .araddr
        .emif_lpddr4a_s0_axi4lite_arprot          (LPDDR4A_axil_driver_arprot),          //   input,   width = 3,                                 .arprot
        .emif_lpddr4a_s0_axi4lite_arvalid         (LPDDR4A_axil_driver_arvalid),         //   input,   width = 1,                                 .arvalid
        .emif_lpddr4a_s0_axi4lite_arready         (LPDDR4A_axil_driver_arready),         //  output,   width = 1,                                 .arready
        .emif_lpddr4a_s0_axi4lite_wdata           (LPDDR4A_axil_driver_wdata),           //   input,  width = 32,                                 .wdata
        .emif_lpddr4a_s0_axi4lite_wstrb           (LPDDR4A_axil_driver_wstrb),           //   input,   width = 4,                                 .wstrb
        .emif_lpddr4a_s0_axi4lite_wvalid          (LPDDR4A_axil_driver_wvalid),          //   input,   width = 1,                                 .wvalid
        .emif_lpddr4a_s0_axi4lite_wready          (LPDDR4A_axil_driver_wready),          //  output,   width = 1,                                 .wready
        .emif_lpddr4a_s0_axi4lite_bready          (LPDDR4A_axil_driver_bready),          //   input,   width = 1,                                 .bready
        .emif_lpddr4a_s0_axi4lite_bresp           (LPDDR4A_axil_driver_bresp),           //  output,   width = 2,                                 .bresp
        .emif_lpddr4a_s0_axi4lite_bvalid          (LPDDR4A_axil_driver_bvalid),          //  output,   width = 1,                                 .bvalid
        .emif_lpddr4a_s0_axi4lite_rready          (LPDDR4A_axil_driver_rready),          //   input,   width = 1,                                 .rready
        .emif_lpddr4a_s0_axi4lite_rdata           (LPDDR4A_axil_driver_rdata),           //  output,  width = 32,                                 .rdata
        .emif_lpddr4a_s0_axi4lite_rresp           (LPDDR4A_axil_driver_rresp),           //  output,   width = 2,                                 .rresp
        .emif_lpddr4a_s0_axi4lite_rvalid          (LPDDR4A_axil_driver_rvalid),          //  output,   width = 1,                                 .rvalid
        .emif_lpddr4a_mem_0_mem_cs                (LPDDR4A_CS_n),                //  output,   width = 1,               emif_lpddr4a_mem_0.mem_cs
        .emif_lpddr4a_mem_0_mem_ca                (LPDDR4A_CA),                //  output,   width = 6,                                 .mem_ca
        .emif_lpddr4a_mem_0_mem_cke               (LPDDR4A_CKE),               //  output,   width = 1,                                 .mem_cke
        .emif_lpddr4a_mem_0_mem_dq                (LPDDR4A_DQ),                //   inout,  width = 32,                                 .mem_dq
        .emif_lpddr4a_mem_0_mem_dqs_t             (LPDDR4A_DQS),             //   inout,   width = 4,                                 .mem_dqs_t
        .emif_lpddr4a_mem_0_mem_dqs_c             (LPDDR4A_DQS_n),             //   inout,   width = 4,                                 .mem_dqs_c
        .emif_lpddr4a_mem_0_mem_dmi               (LPDDR4A_DM),               //   inout,   width = 4,                                 .mem_dmi
        .emif_lpddr4a_mem_ck_0_mem_ck_t           (LPDDR4A_CK),           //  output,   width = 1,            emif_lpddr4a_mem_ck_0.mem_ck_t
        .emif_lpddr4a_mem_ck_0_mem_ck_c           (LPDDR4A_CK_n),           //  output,   width = 1,                                 .mem_ck_c
        .emif_lpddr4a_mem_reset_n_mem_reset_n     (LPDDR4A_RESET_n),     //  output,   width = 1,         emif_lpddr4a_mem_reset_n.mem_reset_n
        .emif_lpddr4a_oct_0_oct_rzqin             (LPDDR4A_RZQ),             //   input,   width = 1,               emif_lpddr4a_oct_0.oct_rzqin
        .emif_lpddr4a_ref_clk_clk                 (LPDDR4A_REFCLK_p),                 //   input,   width = 1,             emif_lpddr4a_ref_clk.clk
        .emif_lpddr4b_core_init_n_reset_n         (LPDDR4B_cal_done_rst_n),         //   input,   width = 1,         emif_lpddr4b_core_init_n.reset_n
        .emif_lpddr4b_s0_axi4_ctrl_ready_reset_n  (LPDDR4B_AXI_Ready_ctrl),  //  output,   width = 1,  emif_lpddr4b_s0_axi4_ctrl_ready.reset_n
        .emif_lpddr4b_s0_axi4lite_clock_clk       (AXI_LITE_CLK),       //   input,   width = 1,   emif_lpddr4b_s0_axi4lite_clock.clk
        .emif_lpddr4b_s0_axi4lite_reset_n_reset_n (LPDDR4_IOPLL_Lock), //   input,   width = 1, emif_lpddr4b_s0_axi4lite_reset_n.reset_n
        .emif_lpddr4b_s0_axi4lite_awaddr          (LPDDR4B_axil_driver_awaddr),          //   input,  width = 27,         emif_lpddr4b_s0_axi4lite.awaddr
        .emif_lpddr4b_s0_axi4lite_awprot          (LPDDR4B_axil_driver_awprot),          //   input,   width = 3,                                 .awprot
        .emif_lpddr4b_s0_axi4lite_awvalid         (LPDDR4B_axil_driver_awvalid),         //   input,   width = 1,                                 .awvalid
        .emif_lpddr4b_s0_axi4lite_awready         (LPDDR4B_axil_driver_awready),         //  output,   width = 1,                                 .awready
        .emif_lpddr4b_s0_axi4lite_araddr          (LPDDR4B_axil_driver_araddr),          //   input,  width = 27,                                 .araddr
        .emif_lpddr4b_s0_axi4lite_arprot          (LPDDR4B_axil_driver_arprot),          //   input,   width = 3,                                 .arprot
        .emif_lpddr4b_s0_axi4lite_arvalid         (LPDDR4B_axil_driver_arvalid),         //   input,   width = 1,                                 .arvalid
        .emif_lpddr4b_s0_axi4lite_arready         (LPDDR4B_axil_driver_arready),         //  output,   width = 1,                                 .arready
        .emif_lpddr4b_s0_axi4lite_wdata           (LPDDR4B_axil_driver_wdata),           //   input,  width = 32,                                 .wdata
        .emif_lpddr4b_s0_axi4lite_wstrb           (LPDDR4B_axil_driver_wstrb),           //   input,   width = 4,                                 .wstrb
        .emif_lpddr4b_s0_axi4lite_wvalid          (LPDDR4B_axil_driver_wvalid),          //   input,   width = 1,                                 .wvalid
        .emif_lpddr4b_s0_axi4lite_wready          (LPDDR4B_axil_driver_wready),          //  output,   width = 1,                                 .wready
        .emif_lpddr4b_s0_axi4lite_bready          (LPDDR4B_axil_driver_bready),          //   input,   width = 1,                                 .bready
        .emif_lpddr4b_s0_axi4lite_bresp           (LPDDR4B_axil_driver_bresp),           //  output,   width = 2,                                 .bresp
        .emif_lpddr4b_s0_axi4lite_bvalid          (LPDDR4B_axil_driver_bvalid),          //  output,   width = 1,                                 .bvalid
        .emif_lpddr4b_s0_axi4lite_rready          (LPDDR4B_axil_driver_rready),          //   input,   width = 1,                                 .rready
        .emif_lpddr4b_s0_axi4lite_rdata           (LPDDR4B_axil_driver_rdata),           //  output,  width = 32,                                 .rdata
        .emif_lpddr4b_s0_axi4lite_rresp           (LPDDR4B_axil_driver_rresp),           //  output,   width = 2,                                 .rresp
        .emif_lpddr4b_s0_axi4lite_rvalid          (LPDDR4B_axil_driver_rvalid),          //  output,   width = 1,                                 .rvalid
        .emif_lpddr4b_mem_0_mem_cs                (LPDDR4B_CS_n),                //  output,   width = 1,               emif_lpddr4b_mem_0.mem_cs
        .emif_lpddr4b_mem_0_mem_ca                (LPDDR4B_CA),                //  output,   width = 6,                                 .mem_ca
        .emif_lpddr4b_mem_0_mem_cke               (LPDDR4B_CKE),               //  output,   width = 1,                                 .mem_cke
        .emif_lpddr4b_mem_0_mem_dq                (LPDDR4B_DQ),                //   inout,  width = 32,                                 .mem_dq
        .emif_lpddr4b_mem_0_mem_dqs_t             (LPDDR4B_DQS),             //   inout,   width = 4,                                 .mem_dqs_t
        .emif_lpddr4b_mem_0_mem_dqs_c             (LPDDR4B_DQS_n),             //   inout,   width = 4,                                 .mem_dqs_c
        .emif_lpddr4b_mem_0_mem_dmi               (LPDDR4B_DM),               //   inout,   width = 4,                                 .mem_dmi
        .emif_lpddr4b_mem_ck_0_mem_ck_t           (LPDDR4B_CK),           //  output,   width = 1,            emif_lpddr4b_mem_ck_0.mem_ck_t
        .emif_lpddr4b_mem_ck_0_mem_ck_c           (LPDDR4B_CK_n),           //  output,   width = 1,                                 .mem_ck_c
        .emif_lpddr4b_mem_reset_n_mem_reset_n     (LPDDR4B_RESET_n),     //  output,   width = 1,         emif_lpddr4b_mem_reset_n.mem_reset_n
        .emif_lpddr4b_oct_0_oct_rzqin             (LPDDR4B_RZQ),             //   input,   width = 1,               emif_lpddr4b_oct_0.oct_rzqin
        .emif_lpddr4b_ref_clk_clk                 (LPDDR4B_REFCLK_p),                 //   input,   width = 1,             emif_lpddr4b_ref_clk.clk
        .iopll_locked_export                      (LPDDR4_IOPLL_Lock),                      //  output,   width = 1,                     iopll_locked.export
        .pio_key_external_connection_export       (KEY),       //   input,   width = 2,      pio_key_external_connection.export
        .pio_led_external_connection_export       (LED),       //  output,   width = 8,      pio_led_external_connection.export
        .iopll_outclk_axi4_lite_clk               (AXI_LITE_CLK),               //  output,   width = 1,           iopll_outclk_axi4_lite.clk

		  .reset_reset_n                            (!ninit_done)                             //   input,   width = 1,                            reset.reset_n
   
	);



endmodule
