// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Tue May  6 11:16:28 2025
// ============================================================================

//`define ENABLE_LPDDR4A
//`define ENABLE_LPDDR4B
//`define ENABLE_HPS
//`define ENABLE_CAM

module golden_top(

      ///////// CLOCK /////////
      input              CLOCK0_50,
      input              CLOCK1_50,
      input              CLOCK2_50,

      ///////// KEY /////////
      input    [ 1: 0]   KEY, //BUTTON is Low-Active

      ///////// SW /////////
      input    [ 3: 0]   SW,

      ///////// LED /////////
      output   [ 7: 0]   LED,

      ///////// SDRAM /////////
      output             DRAM_CLK,
      output             DRAM_CKE,
      output   [12: 0]   DRAM_ADDR,
      output   [ 1: 0]   DRAM_BA,
      inout    [15: 0]   DRAM_DQ,
      output             DRAM_LDQM,
      output             DRAM_UDQM,
      output   [ 1: 0]   DRAM_CS_n,
      output             DRAM_WE_n,
      output             DRAM_CAS_n,
      output             DRAM_RAS_n,

`ifdef ENABLE_LPDDR4A
      ///////// LPDDR4A /////////
      input              LPDDR4A_REFCLK_p,
      output             LPDDR4A_CS_n,
      output   [ 5: 0]   LPDDR4A_CA,
      output             LPDDR4A_CK,
      output             LPDDR4A_CKE,
      output             LPDDR4A_CK_n,
      inout    [ 3: 0]   LPDDR4A_DM,
      inout    [31: 0]   LPDDR4A_DQ,
      inout    [ 3: 0]   LPDDR4A_DQS,
      inout    [ 3: 0]   LPDDR4A_DQS_n,
      output             LPDDR4A_RESET_n,
      input              LPDDR4A_RZQ,
`endif /*ENABLE_LPDDR4A*/

`ifdef ENABLE_LPDDR4B
      ///////// LPDDR4B /////////
      input              LPDDR4B_REFCLK_p,
      output             LPDDR4B_CS_n,
      output   [ 5: 0]   LPDDR4B_CA,
      output             LPDDR4B_CK,
      output             LPDDR4B_CKE,
      output             LPDDR4B_CK_n,
      inout    [ 3: 0]   LPDDR4B_DM,
      inout    [31: 0]   LPDDR4B_DQ,
      inout    [ 3: 0]   LPDDR4B_DQS,
      inout    [ 3: 0]   LPDDR4B_DQS_n,
      output             LPDDR4B_RESET_n,
      input              LPDDR4B_RZQ,
`endif /*ENABLE_LPDDR4B*/

      ///////// HDMI /////////
      inout              HDMI_LRCLK,
      inout              HDMI_MCLK,
      inout              HDMI_SCLK,
      output             HDMI_TX_CLK,
      output             HDMI_TX_HS,
      output             HDMI_TX_VS,
      output   [23: 0]   HDMI_TX_D,
      output             HDMI_TX_DE,
      inout              HDMI_I2C_SCL,
      inout              HDMI_I2C_SDA,
      input              HDMI_TX_INT,
      inout              HDMI_I2S,

`ifdef ENABLE_CAM
      ///////// CAM /////////
      input              CAM_CLK_p,
      input              CAM_CLK_n,
      input    [ 1: 0]   CAM_D_p,
      input    [ 1: 0]   CAM_D_n,
      inout              CAM_I2C_SCL,
      inout              CAM_I2C_SDA,
      inout              CAM_GPIO,
      input              CAM_RZQ1,
`endif /*ENABLE_CAM*/

      ///////// FPGA UART /////////
      output             FPGA_UART_TX,
      input              FPGA_UART_RX,

      ///////// ADC /////////
      output             ADC_SCK,
      input              ADC_SDO,
      output             ADC_SDI,
      output             ADC_CS_n,

      ///////// GPIO /////////
      inout    [35: 0]   GPIO0_D,
      inout    [35: 0]   GPIO1_D,

`ifdef ENABLE_HPS
      ///////// HPS /////////
      input              HPS_CLK_25,
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      inout              HPS_GSENSOR_I2C_EN,
      inout              HPS_GSENSOR_INT,
      inout              HPS_I2C_SCL,
      inout              HPS_I2C_SDA,
      inout              HPS_KEY,
      inout              HPS_LED,
      output             HPS_SD_CLK,
      inout              HPS_SD_CMD,
      inout    [ 3: 0]   HPS_SD_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
`endif /*ENABLE_HPS*/

      ///////// FAN /////////
      input              FAN_ALERT_n

);
//=======================================================
//  Structural coding
//=======================================================
//--RESET 	
wire reset_n;
assign reset_n = ~ninit_done;	
//---INIT RESET 
wire ninit_done;
	ResetRelease ResetRelease_inst (
		.ninit_done (ninit_done)  
	);
	

//-- HDMI SET READY	
assign LED[0] = ~HDMI_READY	 ;

//-----Freq measure----	
wire  M50_1HZ ; 
//-----heart ----
CLOCKMEM  ckK0( .RESET_n(1), .CLK(HDMI_TX_CLK    ) ,.CLK_FREQ ( 148_500_000 ) ,.CK_1HZ  (LED[1] ) ) ;
CLOCKMEM  ckK1( .RESET_n(1), .CLK(AUD_DACLRCK    ) ,.CLK_FREQ ( 48_000     )  ,.CK_1HZ  (LED[2] ) ) ;
CLOCKMEM  ckK2( .RESET_n(1), .CLK(SYSTEM_50MHZ   ) ,.CLK_FREQ ( 50_000_000 )  ,.CK_1HZ  (LED[3] ) ) ;
CLOCKMEM  ckK3( .RESET_n(1), .CLK(AUD_CTRL_CLk   ) ,.CLK_FREQ ( 12_288_000 )  ,.CK_1HZ  (LED[4] ) ) ;
//---AV PLL 
wire  V_locked , A_locked;
wire  pll_12M288; 
wire  SYSTEM_50MHZ;

V_PLL u_V_PLL(
    .refclk       (CLOCK0_50     ),
    .outclk_0     (vpg_pclk      ),//148.5MHZ
    .locked       (V_locked     ),
	 .rst          (~reset_n      )
);

A_PLL u_A_PLL(
    .refclk       (CLOCK1_50     ),
    .outclk_0     (pll_12M288    ),//12.288136Mhz
    .locked       (A_locked     ),
	 .rst          (~reset_n      )
);


assign SYSTEM_50MHZ = CLOCK2_50;//

assign HDMI_TX_D[23:16]	=	vpg_r;
assign HDMI_TX_D[15:8] 	=	vpg_g;
assign HDMI_TX_D[7:0]  	=	vpg_b;

//--HDMI timing generater & //pattern generator
wire [7:0] vpg_r;
wire [7:0] vpg_g;
wire [7:0] vpg_b;				
VPG	u_VPG (
	.vpg_pclk    (vpg_pclk   ),//vedio clock input
	.reset_n     (reset_n    ),    
	.vpg_de      (HDMI_TX_DE ),
	.vpg_hs      (HDMI_TX_HS ),
	.vpg_vs      (HDMI_TX_VS ),
	.vpg_pclk_out(HDMI_TX_CLK),
	.vpg_r       (vpg_r),
	.vpg_g       (vpg_g),
	.vpg_b       (vpg_b)
	);
								
//--  HDMI I2C	SETTING
wire HDMI_READY ;
wire HDMI_I2C_SCLK ; 
I2C_HDMI_Config u_I2C_HDMI_Config (
	              .iCLK       (SYSTEM_50MHZ  ),
	              .iRST_N     (reset_n & KEY[0]),
	              .I2C_SCLK   (HDMI_I2C_SCL  ),
	              .I2C_SDAT   (HDMI_I2C_SDA  ),
	              .HDMI_TX_INT(HDMI_TX_INT   ),
	              .READY      (HDMI_READY    ) 	
	            );
			



//---Audio Master L/RCLK , BCK ,DATA  generater 
wire AUD_BCLK   ;
wire DAC_DACDAT ;
wire AUD_DACLRCK;
wire AUD_CTRL_CLK ; 
assign AUD_CTRL_CLK =pll_12M288;

AUDIO_DAC 	u_AUDIO_DAC	(	//	Audio Side
					.oAUD_BCK       (AUD_BCLK        ),
					.oAUD_DATA      (DAC_DACDAT      ),
					.oAUD_LRCK      (AUD_DACLRCK     ),
					//	Control Signals
					.iSrc_Select    (2'b00           ),
			      .iCLK_18_4      (AUD_CTRL_CLK    ),//12.288000MHz
					.iRST_N         (HDMI_READY      )
					);
										
// HDMI  SOUND MCLK
assign HDMI_MCLK   =	AUD_CTRL_CLK;
							
// 1Khz sine-tone output to HDMI
assign HDMI_I2S   = SW[0]?DAC_DACDAT:0;
assign HDMI_SCLK  = AUD_BCLK     ;
assign HDMI_LRCLK = AUD_DACLRCK  ;	



endmodule
