// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Tue May  6 11:16:28 2025
// ============================================================================

//`define ENABLE_LPDDR4A
//`define ENABLE_LPDDR4B
//`define ENABLE_HPS
//`define ENABLE_CAM

module golden_top(

      ///////// CLOCK /////////
      input              CLOCK0_50,
      input              CLOCK1_50,
      input              CLOCK2_50,

      ///////// KEY /////////
      input    [ 1: 0]   KEY, //BUTTON is Low-Active

      ///////// SW /////////
      input    [ 3: 0]   SW,

      ///////// LED /////////
      output   [ 7: 0]   LED,

      ///////// SDRAM /////////
      output             DRAM_CLK,
      output             DRAM_CKE,
      output   [12: 0]   DRAM_ADDR,
      output   [ 1: 0]   DRAM_BA,
      inout    [15: 0]   DRAM_DQ,
      output             DRAM_LDQM,
      output             DRAM_UDQM,
      output   [ 1: 0]   DRAM_CS_n,
      output             DRAM_WE_n,
      output             DRAM_CAS_n,
      output             DRAM_RAS_n,

`ifdef ENABLE_LPDDR4A
      ///////// LPDDR4A /////////
      input              LPDDR4A_REFCLK_p,
      output             LPDDR4A_CS_n,
      output   [ 5: 0]   LPDDR4A_CA,
      output             LPDDR4A_CK,
      output             LPDDR4A_CKE,
      output             LPDDR4A_CK_n,
      inout    [ 3: 0]   LPDDR4A_DM,
      inout    [31: 0]   LPDDR4A_DQ,
      inout    [ 3: 0]   LPDDR4A_DQS,
      inout    [ 3: 0]   LPDDR4A_DQS_n,
      output             LPDDR4A_RESET_n,
      input              LPDDR4A_RZQ,
`endif /*ENABLE_LPDDR4A*/

`ifdef ENABLE_LPDDR4B
      ///////// LPDDR4B /////////
      input              LPDDR4B_REFCLK_p,
      output             LPDDR4B_CS_n,
      output   [ 5: 0]   LPDDR4B_CA,
      output             LPDDR4B_CK,
      output             LPDDR4B_CKE,
      output             LPDDR4B_CK_n,
      inout    [ 3: 0]   LPDDR4B_DM,
      inout    [31: 0]   LPDDR4B_DQ,
      inout    [ 3: 0]   LPDDR4B_DQS,
      inout    [ 3: 0]   LPDDR4B_DQS_n,
      output             LPDDR4B_RESET_n,
      input              LPDDR4B_RZQ,
`endif /*ENABLE_LPDDR4B*/

      ///////// HDMI /////////
      inout              HDMI_LRCLK,
      inout              HDMI_MCLK,
      inout              HDMI_SCLK,
      output             HDMI_TX_CLK,
      output             HDMI_TX_HS,
      output             HDMI_TX_VS,
      output   [23: 0]   HDMI_TX_D,
      output             HDMI_TX_DE,
      inout              HDMI_I2C_SCL,
      inout              HDMI_I2C_SDA,
      input              HDMI_TX_INT,
      inout              HDMI_I2S,

`ifdef ENABLE_CAM
      ///////// CAM /////////
      input              CAM_CLK_p,
      input              CAM_CLK_n,
      input    [ 1: 0]   CAM_D_p,
      input    [ 1: 0]   CAM_D_n,
      inout              CAM_I2C_SCL,
      inout              CAM_I2C_SDA,
      inout              CAM_GPIO,
      input              CAM_RZQ1,
`endif /*ENABLE_CAM*/

      ///////// FPGA UART /////////
      output             FPGA_UART_TX,
      input              FPGA_UART_RX,

      ///////// ADC /////////
      output             ADC_SCK,
      input              ADC_SDO,
      output             ADC_SDI,
      output             ADC_CS_n,

      ///////// GPIO /////////
      inout    [35: 0]   GPIO0_D,
      inout    [35: 0]   GPIO1_D,

`ifdef ENABLE_HPS
      ///////// HPS /////////
      input              HPS_CLK_25,
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      inout              HPS_GSENSOR_I2C_EN,
      inout              HPS_GSENSOR_INT,
      inout              HPS_I2C_SCL,
      inout              HPS_I2C_SDA,
      inout              HPS_KEY,
      inout              HPS_LED,
      output             HPS_SD_CLK,
      inout              HPS_SD_CMD,
      inout    [ 3: 0]   HPS_SD_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
`endif /*ENABLE_HPS*/

      ///////// FAN /////////
      input              FAN_ALERT_n

);





//=======================================================
//  REG/WIRE declarations
//=======================================================
reg  [31:0]	Cont;

//hdmi
wire [7:0] hdmi_b;
wire [7:0] hdmi_g;
wire [7:0] hdmi_r;
wire       disp_clk;
wire       disp_de;
wire       disp_hs;
wire       disp_vs;
wire       DLY_RST;
wire		  reset_n;
wire 		  pll_12M288;
//=======================================================
//  Structural coding
//=======================================================
assign reset_n = !ninit_done;
wire ninit_done;
agilex_reset_release reset_release_Inst (
	.ninit_done(ninit_done)
	);
	

	
wire beat;
heart_beat heart_beat_clk50(
	.clk(CLOCK0_50),
	.led(beat)
	);


assign LED = (!KEY[0])?8'h0:
				  (!KEY[1])?8'hff:{10{~PWM_width[6]}};
				  
	
reg 	[27:0] 	counter;
reg 	[5:0]   PWM_adj;
reg   [6:0]   PWM_width;
always @(posedge CLOCK0_50 or negedge reset_n)
begin
	if(!reset_n)
		begin
			counter <= 0;
		end
	else 
	begin
		counter   <= counter+1;
		PWM_width <= PWM_width[5:0]+ PWM_adj;
		if(counter[26])
		begin
			PWM_adj <= counter[25:20];
		end
		else 
		begin
			PWM_adj <= ~ counter[25:20];
		end
	end
end									  

//=======================================================
//  Structural coding
//=======================================================


av_pll av_pll_Inst (
    .refclk   (CLOCK1_50),   //   input,  width = 1,  refclk.clk
    .locked   (),   //  output,  width = 1,  locked.export
    .rst      (!reset_n),      //   input,  width = 1,   reset.reset
    .outclk_0 (Pll_12M288)  //  output,  width = 1, outclk0.clk
);

sys_pll u_sys_pll (
   .refclk(CLOCK0_50),
	.rst(!reset_n),
	.outclk_0(disp_clk)
	);
	
//HDMI I2C	
I2C_HDMI_Config u_I2C_HDMI_Config (
	.iCLK(CLOCK0_50),
	.iRST_N(reset_n),
	.I2C_SCLK(HDMI_I2C_SCL),
	.I2C_SDAT(HDMI_I2C_SDA),
	.HDMI_TX_INT(HDMI_TX_INT),
	.READY      (HDMI_READY) 	
	);


vga_controller hdmi_ins(.iRST_n(reset_n),
                      .iVGA_CLK(disp_clk),
                      .oBLANK_n(disp_de),
                      .oHS(disp_hs),
                      .oVS(disp_vs),
                      .b_data(hdmi_b),
                      .g_data(hdmi_g),
                      .r_data(hdmi_r));	
							 
							 
assign HDMI_TX_CLK	= disp_clk;
assign HDMI_TX_D		= {hdmi_r,hdmi_g,hdmi_b};
assign HDMI_TX_DE		= disp_de;
assign HDMI_TX_HS		= disp_hs;
assign HDMI_TX_VS		= disp_vs;	


AUDIO_IF u_AVG(
	.clk(Pll_12M288),
	.reset_n(reset_n& SW[0]),
	.sclk(HDMI_SCLK),
	.lrclk(HDMI_LRCLK),
	.i2s(HDMI_I2S)
);
assign HDMI_MCLK 		= Pll_12M288;


endmodule
