// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Tue May  6 11:16:28 2025
// ============================================================================

//`define ENABLE_LPDDR4A
//`define ENABLE_LPDDR4B
//`define ENABLE_HPS
//`define ENABLE_CAM

module golden_top(

      ///////// CLOCK /////////
      input              CLOCK0_50,
      input              CLOCK1_50,
      input              CLOCK2_50,

      ///////// KEY /////////
      input    [ 1: 0]   KEY, //BUTTON is Low-Active

      ///////// SW /////////
      input    [ 3: 0]   SW,

      ///////// LED /////////
      output   [ 7: 0]   LED,

      ///////// SDRAM /////////
      output             DRAM_CLK,
      output             DRAM_CKE,
      output   [12: 0]   DRAM_ADDR,
      output   [ 1: 0]   DRAM_BA,
      inout    [15: 0]   DRAM_DQ,
      output             DRAM_LDQM,
      output             DRAM_UDQM,
      output   [ 1: 0]   DRAM_CS_n,
      output             DRAM_WE_n,
      output             DRAM_CAS_n,
      output             DRAM_RAS_n,

`ifdef ENABLE_LPDDR4A
      ///////// LPDDR4A /////////
      input              LPDDR4A_REFCLK_p,
      output             LPDDR4A_CS_n,
      output   [ 5: 0]   LPDDR4A_CA,
      output             LPDDR4A_CK,
      output             LPDDR4A_CKE,
      output             LPDDR4A_CK_n,
      inout    [ 3: 0]   LPDDR4A_DM,
      inout    [31: 0]   LPDDR4A_DQ,
      inout    [ 3: 0]   LPDDR4A_DQS,
      inout    [ 3: 0]   LPDDR4A_DQS_n,
      output             LPDDR4A_RESET_n,
      input              LPDDR4A_RZQ,
`endif /*ENABLE_LPDDR4A*/

`ifdef ENABLE_LPDDR4B
      ///////// LPDDR4B /////////
      input              LPDDR4B_REFCLK_p,
      output             LPDDR4B_CS_n,
      output   [ 5: 0]   LPDDR4B_CA,
      output             LPDDR4B_CK,
      output             LPDDR4B_CKE,
      output             LPDDR4B_CK_n,
      inout    [ 3: 0]   LPDDR4B_DM,
      inout    [31: 0]   LPDDR4B_DQ,
      inout    [ 3: 0]   LPDDR4B_DQS,
      inout    [ 3: 0]   LPDDR4B_DQS_n,
      output             LPDDR4B_RESET_n,
      input              LPDDR4B_RZQ,
`endif /*ENABLE_LPDDR4B*/

      ///////// HDMI /////////
    //  inout              HDMI_LRCLK,
    //  inout              HDMI_MCLK,
    //  inout              HDMI_SCLK,
    //  output             HDMI_TX_CLK,
    //  output             HDMI_TX_HS,
    //  output             HDMI_TX_VS,
    //  output   [23: 0]   HDMI_TX_D,
    //  output             HDMI_TX_DE,
      inout              HDMI_I2C_SCL,
      inout              HDMI_I2C_SDA,
   //  input              HDMI_TX_INT,
   //  inout              HDMI_I2S,

`ifdef ENABLE_CAM
      ///////// CAM /////////
      input              CAM_CLK_p,
      input              CAM_CLK_n,
      input    [ 1: 0]   CAM_D_p,
      input    [ 1: 0]   CAM_D_n,
      inout              CAM_I2C_SCL,
      inout              CAM_I2C_SDA,
      inout              CAM_GPIO,
      input              CAM_RZQ1,
`endif /*ENABLE_CAM*/

      ///////// FPGA UART /////////
      output             FPGA_UART_TX,
      input              FPGA_UART_RX,

      ///////// ADC /////////
      output             ADC_SCK,
      input              ADC_SDO,
      output             ADC_SDI,
      output             ADC_CS_n,

      ///////// GPIO /////////
      inout    [35: 0]   GPIO0_D,
      inout    [35: 0]   GPIO1_D,

`ifdef ENABLE_HPS
      ///////// HPS /////////
      input              HPS_CLK_25,
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      inout              HPS_GSENSOR_I2C_EN,
      inout              HPS_GSENSOR_INT,
      inout              HPS_I2C_SCL,
      inout              HPS_I2C_SDA,
      inout              HPS_KEY,
      inout              HPS_LED,
      output             HPS_SD_CLK,
      inout              HPS_SD_CMD,
      inout    [ 3: 0]   HPS_SD_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
`endif /*ENABLE_HPS*/

      ///////// FAN /////////
      input              FAN_ALERT_n

);


//=======================================================
//  REG/WIRE declarations
//=======================================================




//=======================================================
//  Structural coding
//=======================================================

//assign TD_RESET_n=1;
// SDRAM OFF
assign DRAM_DQ   =16'hzzzz_zzzzz;
assign DRAM_CS_n =2'b11;
assign DRAM_WE_n =1'b1;
assign DRAM_CAS_n=1'b1;
assign DRAM_RAS_n=1'b1;

// LED OFF
assign LED[7:3] = 5'h1f; 


//=======================================================
//  REG/WIRE declarations
//=======================================================
//System Monitor IP
//IP interface
wire signed [15:0]FPGA_Temperature  ;// unit: C
wire signed [15:0]Board_Temperature ;// unit: C
wire [15:0]Fan_Speed         ;// unit: RPM
wire       Auto_Fan_Speed    ;// 1: enable audo speed control.0: user specify fan speed
wire [15:0]Set_Fan_Speed     ;// used when Auto_Fan_Speedis low
wire       I2C_READY         ;// 1:I2C BUS ready 0:I2C BUS no ready


//=======================================================
//  Structural coding
//=======================================================

//---LEDR0---------------------------
assign LED[0]=   ~KEY[0] ;

//---LEDR1---------------------------
assign LED[1]=   ~Auto_Fan_Speed ;

//---LEDR2---------------------------
assign LED[2]=   ~I2C_READY ;

//--select to AutoFAN-speed or USER fan-speed
assign Auto_Fan_Speed = SW[0] ;// 1: enable audo speed control.0: user specify fan speed

//--default USER fan-speed :rpm
assign Set_Fan_Speed = 9500 ;  

wire ninit_done ; 
reset_release  u_reset_release(
		.ninit_done (ninit_done)  
	);

wire reset_n ;
assign reset_n =  ~ninit_done;
BOARD_MANAGEMENT u_BOARD_MANAGEMENT(    
                       .I2C_READY(I2C_READY ),
     /*input*/         .clk_50   ( CLOCK0_50),
     /*input*/         .reset_n  ( reset_n & KEY[0] ),
    // device i2c interface
       /*inout*/       .I2C_SCL  (HDMI_I2C_SCL),
       /*inout*/       .I2C_SDA  (HDMI_I2C_SDA),

    // board info and control
      /*output [15:0]*/.FPGA_Temperature  (FPGA_Temperature  ), // unit: C
      /*output [15:0]*/.Board_Temperature (Board_Temperature ), // unit: C		
      /*output [15:0]*/.Fan_Speed         (Fan_Speed         ), // unit: RPM
      
      /*input        */.Auto_Fan_Speed    (Auto_Fan_Speed),       // 1: enable audo speed control.0: user specify fan speed
      /*input  [15:0]*/.Set_Fan_Speed     (Set_Fan_Speed )        // used when Auto_Fan_Speedis low

);





endmodule
