module VOLTAGE_METER (
      input CLK_50,//CLOCK2_50
		
      //ADC 
		output   ADC_CONVST , 
      inout   ADC_CS_N,
      output  ADC_DIN,
      input   ADC_DOUT,
      output  ADC_SCLK,
		
		//BCD HEX 
		output [6:0] HEX0,
		output [6:0] HEX1,
		
		//LEVEL LED 
		output [7:0] LED ,
		output [11:0] ADC_D ,
		output        SYS_CLK ,
		input RESET_N  ,
		input [3:0]SW,
		output reg [2:0]CCH 
);

wire [5:0]CH;

reg 	[7:0] TIME;

//---TIME-SCALE

always @(posedge CLK_50  ) 	TIME<=TIME+1;

//----ADC SYSTEM-CLOCK

assign      SYS_CLK =TIME[2];//6.25mhz

assign CH= { 
1'b1 ,    //S   = 1: SINGLE-ENDED
CCH[0] ,  //ODD = 1/ even =0  
CCH[2:1] ,//ADDRESS SELECT
1'b1 ,    //UNI = 1: UNIPOLAR
1'b0      //SLP = 0: none SLEEP MODE
};


always @( posedge ADC_CONVST) CCH <= CCH+1 ; 


//---ADC CONTROLLER
ADC_CTRL	adc(	// for DE1-SOC , ltc2308 
               .CONVST(ADC_CONVST)  ,
					.iCLK(SYS_CLK),
					.iCREG ({CH[5:0],6'b000000} ),
					                                                      
					.oADC_D(ADC_D ),
					
					.oDIN (ADC_DIN),
					.oCS_n(ADC_CS_N),
					.oSCLK(ADC_SCLK),
					.iDOUT(ADC_DOUT),
					.RESET_N ( RESET_N  ) 
				);


//----HEX TO LEVEL LED
LEVEL_MTER v1(
	.iVV   ( ADC_D ),
	.oLEVEL( LED ) 
);

endmodule
