module TLA2518_ADC_CTRL 	(	
input              iRESET_N , 
input				    iSYS_CLK,
output	reg	    oMOSI,
output	reg 	    oCS  ,
output	reg	    oSCLK,
input				    iMISO,
output	reg [11:0]CH0_D,
output	reg [11:0]CH1_D,
output	reg [11:0]CH2_D,
output	reg [11:0]CH3_D,
output	reg [11:0]CH4_D,
output	reg [11:0]CH5_D,
output	reg [11:0]CH6_D,
output	reg [11:0]CH7_D,
output   reg       oREADY, 
//---for test 
output   reg [7:0] ST,
output   reg [4:0] COUNTER,

output   reg [23:0]ADC_DATA,
output   reg [31:0]DELAY ,

output   reg [23:0]REGISTER ,
output       [7:0 ]SEQUENCE_CFG, 

output   reg [23:0]ID , 
output   reg [7:0 ]CH 

);

//----parameter 
parameter  P_SEQUENCE_CFG =8'h10 ; //SEQUENCE_CFG Register
parameter  P_CHANNEL_SEL  =8'h11;

parameter  SEQ_MODE       =2'h2  ; //On-the-fly sequence mode
parameter  AUTO_SEQ_MODE  =2'h1  ; //AUTO sequence mode
parameter  MANUAL_MODE    =2'h0  ; //MANUAL mode
parameter  START_SEQ      =1'b1 ;  //start-seq

parameter  WRITE_REG      =8'h08 ;  //write register command 
parameter  READ_REG       =8'h10 ;  //read  register command 

			
//----write SEQUENCE_CFG
assign SEQUENCE_CFG  = {6'b000_000, MANUAL_MODE[1:0] };// 

reg [31:0] delay ; 
//-- 4-wire SPI adc controller 
always@( negedge iRESET_N or posedge iSYS_CLK )
   if ( !iRESET_N) begin 
	   ST      <= 0; 
	   oCS     <= 1; 
		ID      <= 0;
		CH      <=0;
      CH7_D   <= 0;
      CH0_D   <= 0;
      CH1_D   <= 0;
      CH2_D   <= 0;
      CH3_D   <= 0;		
      CH4_D   <= 0;		
      CH5_D   <= 0;		
      CH6_D   <= 0;
      oREADY  <= 0;	
		
	end 
else 
begin
case (ST)
//---Write regsiter -----
0:begin 
      ST     <= 1;
		oCS    <= 1; 
		oSCLK  <= 0;
		COUNTER<= 24;
		//config manual mode 
		REGISTER[23:0]   <={WRITE_REG[7:0],P_SEQUENCE_CFG[7:0] ,SEQUENCE_CFG[7:0]  }  ;
  end 
1:begin 
      oCS    <=0; 
      ST     <=2;
  end 
2:begin 
      {oMOSI,REGISTER[23:0]} <= {REGISTER[23:0], 1'b0} ;
       ST<=3;
  end 
3:begin 
      oSCLK   <= 1;
      COUNTER <= COUNTER-1;
      ST      <= 4;
  end 
4:begin 
      oSCLK   <=0;
      if ( COUNTER!=0)  ST<=2 ; else ST<=5; 
  end 
  
//---read  Channel 0~7 ADC DATA -----  
//---channel set
5:begin 
      oCS      <= 1; 
      ST       <= 6;
		COUNTER  <= 24;
		//write CHANNEL_SEL regsiter 
		REGISTER[23:0]   <={WRITE_REG[7:0],P_CHANNEL_SEL[7:0],CH[7:0]}  ;
  end 		
//--bit read 
6:begin 	
      oCS   <= 0;	
     { oMOSI, REGISTER[23:0] } <= { REGISTER[23:0] ,1'b0};
      ST<=7 ;
  end 				
7:begin 
      oSCLK   <= 1;
      COUNTER <= COUNTER-1;
      ST      <= 8;
  end 
8:begin 
      oSCLK   <=0;
		ADC_DATA[23:0]  <= { ADC_DATA[22:0] ,iMISO};
      if ( COUNTER!=0)  ST<=6 ; else ST<=9; 
  end		
//---NEXT channel  and ADC data latch		
9:	begin 
     oREADY  <= 1;
          if (CH==0)       CH6_D <= ADC_DATA[23:12] ; 
     else if (CH==1)       CH7_D <= ADC_DATA[23:12] ; 
     else if (CH==2)       CH0_D <= ADC_DATA[23:12] ; 
     else if (CH==3)       CH1_D <= ADC_DATA[23:12] ; 
     else if (CH==4)       CH2_D <= ADC_DATA[23:12] ; 
     else if (CH==5)       CH3_D <= ADC_DATA[23:12] ; 
     else if (CH==6)       CH4_D <= ADC_DATA[23:12] ; 
     else if (CH==7)       CH5_D <= ADC_DATA[23:12] ;     
     CH   <=CH+1 ; 
     ST   <=10 ;
	  delay<=0;
  end		
10:   begin 
     oCS      <= 1;
     if ( delay==100) begin 
	         ST      <= 5 ; 
            oREADY  <= 0;				
	  end 
	  else delay<=delay+1; 
end	  

endcase
end

endmodule
