module  LEVEL_MTER (
 input  [11:0]iVV,
 output [7:0] oLEVEL 
);

 parameter STEP    =  8 ; 
 parameter MAX     =  4095 ; 
 parameter LEVEL   =  MAX/STEP ; 

assign oLEVEL =(
 (iVV > 8*LEVEL  )?8'hFF :(  //4.095v
 (iVV > 7*LEVEL  )?8'h7F :(  //3.579v
 (iVV > 6*LEVEL  )?8'h3F :(  //3.067v
 (iVV > 5*LEVEL  )?8'h1F :(  //2.555v
 (iVV > 4*LEVEL  )?8'h0F :(  //2.044v
 (iVV > 3*LEVEL  )?8'h07 :(  //1.533v 
 (iVV > 2*LEVEL  )?8'h03 :(  //1.022v
 (iVV > 1*LEVEL  )?8'h01 :0  //0.512v 
))))))));

endmodule  
