#include <stdio.h>
#include <io.h>
#include <unistd.h>

#include "system.h"
#include "TLA2518.h"

void main(void){
	bool bSuccess;
	alt_u32 Measured16, data16;
	int ch;
	const float fAVDD = 3.3;

	printf("ADC Demo\r\n");

	// soft reset
	bSuccess = TLA2518_Softreset(SPI_MASTER_BASE);
	if (!bSuccess)
		printf("failed to reset TLA2518\r\n");


	while (bSuccess){
		ch = IORD(PIO_SW_BASE, 0x00) & 0x07;
		bSuccess = TLA2518_Read_CH(SPI_MASTER_BASE, ch, &Measured16);
		if (!bSuccess){
			printf("Failed to read data!\r\n");
			break;
		}else{
			data16 = (Measured16 >> 4) & 0x0FFFF;
			printf("ch%d=%.2fV (%04xh)\r\n", ch, (float)data16/4095.0 * fAVDD,  data16);
			usleep(1000*1000); // 1 sec
		}

	}
}
