/*
 * TLA2518.h
 *
 *  Created on: 2025/5/29
 *      Author: richard
 */

#ifndef TLA2518_H_
#define TLA2518_H_

#include <stdint.h>
#include <stdbool.h>
#include <alt_types.h>

// REGISTER
#define REG_SYSTEM_STATUS 	0x00
#define REG_GENERAL_CFG		0x01
#define REG_DATA_CFG		0x02
#define REG_OSR_CFG 		0x03 // oversampling ratio. default no
#define REG_OPMODE_CFG		0x04
#define REG_PIN_CFG			0x05 // analog input (default)  or digital input
#define REG_GPIO_CFG		0x07 // digital direction
#define REG_GPO_DRIVE_CFG 	0x09
#define REG_GPO_VALUE		0x0B
#define REG_GPI_VALUE		0x0D
#define REG_SEQUENCE_CFG	0x10 // SEQ_MODE. default manual mode
#define REG_CHANNEL_SEL 	0x11 // MANUAL_CHID[3:0] used in manual mode
#define REG_AUTO_SEQ_CH_SEL 0x12

// OPCODE
#define OP_NO 			0x00 // no operation
#define OP_REG_READ 	0x10 // single register read
#define OP_REG_WRITE 	0x08 // single register write
#define OP_SET_BIT	 	0x18 // set bit
#define OP_CLEAR_BIT 	0x20 // clear bit

// REG_SEQUENCE_CFG
#define SEQ_START_BIT_MASK	0x08
#define SEQ_MOD_BIT_MASK	0x07


bool TLA2518_Write_Reg8(alt_u32 base, alt_u8 Addr8, alt_u8 Data8);
bool TLA2518_Read_Reg8(alt_u32 base, alt_u8 Addr8, alt_u8 *pData8);
bool TLA2518_Read_Data24(alt_u32 base, alt_u16 *pData16);
bool TLA2518_Read_Data16(alt_u32 base, alt_u16 *pData16);

bool TLA2518_Softreset(alt_u32 base);
bool TLA2518_Read_CH(alt_u32 base, alt_u32 ch, alt_u32 *pMeasured16);
bool TLA2518_Read_8CH_ManualMode(alt_u32 base, alt_u32 szCH[8], bool bShowData);



#endif /* TLA2518_H_ */
