// core_sdram_axi4.v

// Generated using ACDS version 25.1 129

`timescale 1 ps / 1 ps
module core_sdram_axi4 #(
		parameter SDRAM_MHZ          = 80,
		parameter SDRAM_ADDR_W       = 24,
		parameter SDRAM_COL_W        = 9,
		parameter SDRAM_READ_LATENCY = 2
	) (
		output wire                            sdram_cke_o,         //             sdram.cke
		output wire                            sdram_cs_o,          //                  .cs_n
		output wire                            sdram_ras_o,         //                  .ras_n
		output wire                            sdram_cas_o,         //                  .cas_n
		output wire                            sdram_we_o,          //                  .we_n
		output wire [3:0]                      sdram_dqm_o,         //                  .dqm
		output wire [12:0]                     sdram_addr_o,        //                  .addr
		output wire [1:0]                      sdram_ba_o,          //                  .ba
		output wire [31:0]                     sdram_data_output_o, //                  .data_out
		output wire                            sdram_data_out_en_o, //                  .data_oe
		input  wire [31:0]                     sdram_data_input_i,  //                  .data_in
		input  wire                            clk_i,               //        clock_sink.clk
		input  wire                            clk_sample_i,        // clock_sample_sink.clk
		input  wire                            rst_i,               //        reset_sink.reset
		input  wire                            inport_awvalid_i,    //        axi4_slave.awvalid
		input  wire [((SDRAM_ADDR_W-0)+2)-1:0] inport_awaddr_i,     //                  .awaddr
		input  wire [3:0]                      inport_awid_i,       //                  .awid
		input  wire [7:0]                      inport_awlen_i,      //                  .awlen
		input  wire [1:0]                      inport_awburst_i,    //                  .awburst
		input  wire                            inport_wvalid_i,     //                  .wvalid
		input  wire [63:0]                     inport_wdata_i,      //                  .wdata
		input  wire [7:0]                      inport_wstrb_i,      //                  .wstrb
		input  wire                            inport_wlast_i,      //                  .wlast
		input  wire                            inport_bready_i,     //                  .bready
		input  wire                            inport_arvalid_i,    //                  .arvalid
		input  wire [((SDRAM_ADDR_W-0)+2)-1:0] inport_araddr_i,     //                  .araddr
		input  wire [3:0]                      inport_arid_i,       //                  .arid
		input  wire [7:0]                      inport_arlen_i,      //                  .arlen
		input  wire [1:0]                      inport_arburst_i,    //                  .arburst
		input  wire                            inport_rready_i,     //                  .rready
		output wire                            inport_awready_o,    //                  .awready
		output wire                            inport_wready_o,     //                  .wready
		output wire                            inport_bvalid_o,     //                  .bvalid
		output wire [1:0]                      inport_bresp_o,      //                  .bresp
		output wire [3:0]                      inport_bid_o,        //                  .bid
		output wire                            inport_arready_o,    //                  .arready
		output wire                            inport_rvalid_o,     //                  .rvalid
		output wire [63:0]                     inport_rdata_o,      //                  .rdata
		output wire [1:0]                      inport_rresp_o,      //                  .rresp
		output wire [3:0]                      inport_rid_o,        //                  .rid
		output wire                            inport_rlast_o,      //                  .rlast
		input  wire [2:0]                      inport_awsize_i,     //                  .awsize
		input  wire [2:0]                      inport_arsize_i      //                  .arsize
	);

	sdram_axi #(
		.SDRAM_MHZ          (SDRAM_MHZ),
		.SDRAM_ADDR_W       (SDRAM_ADDR_W),
		.SDRAM_COL_W        (SDRAM_COL_W),
		.SDRAM_READ_LATENCY (SDRAM_READ_LATENCY)
	) sdram (
		.sdram_cke_o         (sdram_cke_o),         //  output,                     width = 1,             sdram.cke
		.sdram_cs_o          (sdram_cs_o),          //  output,                     width = 1,                  .cs_n
		.sdram_ras_o         (sdram_ras_o),         //  output,                     width = 1,                  .ras_n
		.sdram_cas_o         (sdram_cas_o),         //  output,                     width = 1,                  .cas_n
		.sdram_we_o          (sdram_we_o),          //  output,                     width = 1,                  .we_n
		.sdram_dqm_o         (sdram_dqm_o),         //  output,                     width = 4,                  .dqm
		.sdram_addr_o        (sdram_addr_o),        //  output,                    width = 13,                  .addr
		.sdram_ba_o          (sdram_ba_o),          //  output,                     width = 2,                  .ba
		.sdram_data_output_o (sdram_data_output_o), //  output,                    width = 32,                  .data_out
		.sdram_data_out_en_o (sdram_data_out_en_o), //  output,                     width = 1,                  .data_oe
		.sdram_data_input_i  (sdram_data_input_i),  //   input,                    width = 32,                  .data_in
		.clk_i               (clk_i),               //   input,                     width = 1,        clock_sink.clk
		.clk_sample_i        (clk_sample_i),        //   input,                     width = 1, clock_sample_sink.clk
		.rst_i               (rst_i),               //   input,                     width = 1,        reset_sink.reset
		.inport_awvalid_i    (inport_awvalid_i),    //   input,                     width = 1,        axi4_slave.awvalid
		.inport_awaddr_i     (inport_awaddr_i),     //   input,  width = ((SDRAM_ADDR_W-0)+2),                  .awaddr
		.inport_awid_i       (inport_awid_i),       //   input,                     width = 4,                  .awid
		.inport_awlen_i      (inport_awlen_i),      //   input,                     width = 8,                  .awlen
		.inport_awburst_i    (inport_awburst_i),    //   input,                     width = 2,                  .awburst
		.inport_wvalid_i     (inport_wvalid_i),     //   input,                     width = 1,                  .wvalid
		.inport_wdata_i      (inport_wdata_i),      //   input,                    width = 64,                  .wdata
		.inport_wstrb_i      (inport_wstrb_i),      //   input,                     width = 8,                  .wstrb
		.inport_wlast_i      (inport_wlast_i),      //   input,                     width = 1,                  .wlast
		.inport_bready_i     (inport_bready_i),     //   input,                     width = 1,                  .bready
		.inport_arvalid_i    (inport_arvalid_i),    //   input,                     width = 1,                  .arvalid
		.inport_araddr_i     (inport_araddr_i),     //   input,  width = ((SDRAM_ADDR_W-0)+2),                  .araddr
		.inport_arid_i       (inport_arid_i),       //   input,                     width = 4,                  .arid
		.inport_arlen_i      (inport_arlen_i),      //   input,                     width = 8,                  .arlen
		.inport_arburst_i    (inport_arburst_i),    //   input,                     width = 2,                  .arburst
		.inport_rready_i     (inport_rready_i),     //   input,                     width = 1,                  .rready
		.inport_awready_o    (inport_awready_o),    //  output,                     width = 1,                  .awready
		.inport_wready_o     (inport_wready_o),     //  output,                     width = 1,                  .wready
		.inport_bvalid_o     (inport_bvalid_o),     //  output,                     width = 1,                  .bvalid
		.inport_bresp_o      (inport_bresp_o),      //  output,                     width = 2,                  .bresp
		.inport_bid_o        (inport_bid_o),        //  output,                     width = 4,                  .bid
		.inport_arready_o    (inport_arready_o),    //  output,                     width = 1,                  .arready
		.inport_rvalid_o     (inport_rvalid_o),     //  output,                     width = 1,                  .rvalid
		.inport_rdata_o      (inport_rdata_o),      //  output,                    width = 64,                  .rdata
		.inport_rresp_o      (inport_rresp_o),      //  output,                     width = 2,                  .rresp
		.inport_rid_o        (inport_rid_o),        //  output,                     width = 4,                  .rid
		.inport_rlast_o      (inport_rlast_o),      //  output,                     width = 1,                  .rlast
		.inport_awsize_i     (inport_awsize_i),     //   input,                     width = 3,                  .awsize
		.inport_arsize_i     (inport_arsize_i)      //   input,                     width = 3,                  .arsize
	);

endmodule
