	component nios_system is
		port (
			clk_clk                        : in  std_logic                     := 'X';             -- clk
			sdram_clk_clk                  : out std_logic;                                        -- clk
			key_external_connection_export : in  std_logic_vector(3 downto 0)  := (others => 'X'); -- export
			led_external_connection_export : out std_logic_vector(9 downto 0);                     -- export
			sw_external_connection_export  : in  std_logic_vector(9 downto 0)  := (others => 'X'); -- export
			reset_reset_n                  : in  std_logic                     := 'X';             -- reset_n
			sdram_cke                      : out std_logic;                                        -- cke
			sdram_cs_n                     : out std_logic;                                        -- cs_n
			sdram_ras_n                    : out std_logic;                                        -- ras_n
			sdram_cas_n                    : out std_logic;                                        -- cas_n
			sdram_we_n                     : out std_logic;                                        -- we_n
			sdram_dqm                      : out std_logic_vector(3 downto 0);                     -- dqm
			sdram_addr                     : out std_logic_vector(12 downto 0);                    -- addr
			sdram_ba                       : out std_logic_vector(1 downto 0);                     -- ba
			sdram_data_out                 : out std_logic_vector(31 downto 0);                    -- data_out
			sdram_data_oe                  : out std_logic;                                        -- data_oe
			sdram_data_in                  : in  std_logic_vector(31 downto 0) := (others => 'X')  -- data_in
		);
	end component nios_system;

	u0 : component nios_system
		port map (
			clk_clk                        => CONNECTED_TO_clk_clk,                        --                     clk.clk
			sdram_clk_clk                  => CONNECTED_TO_sdram_clk_clk,                  --               sdram_clk.clk
			key_external_connection_export => CONNECTED_TO_key_external_connection_export, -- key_external_connection.export
			led_external_connection_export => CONNECTED_TO_led_external_connection_export, -- led_external_connection.export
			sw_external_connection_export  => CONNECTED_TO_sw_external_connection_export,  --  sw_external_connection.export
			reset_reset_n                  => CONNECTED_TO_reset_reset_n,                  --                   reset.reset_n
			sdram_cke                      => CONNECTED_TO_sdram_cke,                      --                   sdram.cke
			sdram_cs_n                     => CONNECTED_TO_sdram_cs_n,                     --                        .cs_n
			sdram_ras_n                    => CONNECTED_TO_sdram_ras_n,                    --                        .ras_n
			sdram_cas_n                    => CONNECTED_TO_sdram_cas_n,                    --                        .cas_n
			sdram_we_n                     => CONNECTED_TO_sdram_we_n,                     --                        .we_n
			sdram_dqm                      => CONNECTED_TO_sdram_dqm,                      --                        .dqm
			sdram_addr                     => CONNECTED_TO_sdram_addr,                     --                        .addr
			sdram_ba                       => CONNECTED_TO_sdram_ba,                       --                        .ba
			sdram_data_out                 => CONNECTED_TO_sdram_data_out,                 --                        .data_out
			sdram_data_oe                  => CONNECTED_TO_sdram_data_oe,                  --                        .data_oe
			sdram_data_in                  => CONNECTED_TO_sdram_data_in                   --                        .data_in
		);

