// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps / 1 ps
module mux_data_synchronizer #(
    parameter DEPTH = 3,
    parameter DATA_WIDTH = 32
)
(
    input logic                     clk_dest
   ,input logic                     rst_dest
   ,input logic                     dvalid_in_src
   ,input logic [DATA_WIDTH-1 : 0]  data_in_src
   ,output logic [DATA_WIDTH-1 : 0] data_out_dest
);

   logic [1:0]  dvalid_sync;
   logic        dvalid_out_dest;
   logic [DATA_WIDTH-1 : 0]    data_in_src_reg;
   logic [DATA_WIDTH-1 : 0]    data_temp;
   
   altera_std_synchronizer_nocut 
      #(.depth(DEPTH)) 
      syncr ( 
            .clk(clk_dest),
            .reset_n(~rst_dest),
            .din(dvalid_in_src),
            .dout(dvalid_out_dest)
            );


    assign data_temp     = dvalid_out_dest ? data_in_src : data_out_dest ;
    // assign data_out_dest = data_temp ;

    always_ff@(posedge clk_dest) begin
        if (rst_dest)
            data_out_dest <= '0;
        else    
            data_out_dest <= data_temp;
    end
    
    
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "gxUC0uHYGh5iTQS8ia15YhsMdiQ/QO3FIgn/CTziZ81FfcVb1wIu1TUDtUSAlPhrI8sFn2gLVFPYIAWgXa1CDIAxu7+Mu95EspuhkTIiZDKiE84F2bHA++ET8wpXBxIIzmaIhNXoKrqjdVZK86WH9pgYZAAHPFZVidAScxF2oS+ZuawRq7tLosd7KKtmNPpGbid6ZD6+4i3ffC0mporV3iLa8AJf3f5c/wtX4oOh5PqcT0bsOx+qZq4LJ27AEWNlZgoVaIIfbiNUC4h+b9cRyVb0mW5wqJfm8xvqIpXHEOp1HlWdhVc3tNUSkoRe/k3TMEbwuwNCLhqWmL3LsO4NSVCmXXHqAtx2CUoC7TP+S4zQZsk4SGMFDjMxA3vLRCHUIStJXJLw4Q2CU5+fP17q2FyWry9/51nB1ag+mRRuloU9gOoqP68VCRSzAxEHSzKgNJ8bElPWX7NVhev/sUetWCbs6mXMo4SWjarp8hwdIqnNHgn3eCnh5hbtQjnJ/oGr9KTflVmcctzJG34lXF20HKFPfL3RdWe3PigT5hlDAGY9Tp63Fj+sdsufNTBLCs3wq0Zctm4OC3udQacCO7JmMkCMPNUsie4CCcNI51zGkdB7MLnuXEGAZo2+Pr1jfdmDBJfU3lok0upk3zSLXYfZr3yev2WFCJdwfYaFumq9UfV/EWs7MhJK/+ge/QONm3X+cWOE9vfxjp1ypx+qFOOBvyH8htowvMw/XwyUYd3r1mYuxisilrbBqx2Sl86w0ptMbIS7sScimHsJascZ9BnW/9sUwFa23onSu/IOEBhQ/K1Csv/guA7aj2Ep/NDKokgKzp5KC1jKicWCqwbQO5MEvEiVfgPp72cTZS766MXDHOaha4WkJBoqXhBDpMVKB8myqZM2ptC7ZCkk4MzcSuOI4NphN8CKFIfVLYAEIOwjMWvGf0ZMb308xW++i21Ar9VGAAldFxNWrLtaNA2lHcGmQq5oYLycsARgMzaEI0GLKI+wl4+eYl5eTghWnx/voZ/J"
`endif