// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1ns / 100ps

// this module has zero ready latency input and non zero latency output


module ready_latency_adapter # (
 parameter READY_LATENCY_OUT = 2,
 parameter PAYLOAD_WIDTH = 256,
 parameter LOG_DEPTH = 3


) (  
 output logic         in_ready,
 input  logic            in_valid,
 input  logic   [PAYLOAD_WIDTH-1: 0]  in_data,
 // Interface: out
 input  logic             out_ready,
 output logic          out_valid,
 output logic [PAYLOAD_WIDTH-1: 0] out_data,
  // Interface: clk
 input logic          clk,
 // Interface: reset
 input logic           reset

 /*AUTOARG*/);

   // ---------------------------------------------------------------------
   //| Signal Declarations
   // ---------------------------------------------------------------------
   
   logic [PAYLOAD_WIDTH-1:0]   in_payload;
   logic [PAYLOAD_WIDTH-1:0]   out_payload;
   logic            in_ready_wire;
   logic            out_valid_wire;
   logic [2:0]      fifo_fill;
   logic    rdreq;
   logic empty;   

   logic [READY_LATENCY_OUT-1:0] in_ready_dly_reg;
   logic in_ready_dly;
   assign in_ready_dly = (READY_LATENCY_OUT > 0) ? in_ready_dly_reg[0] : in_ready;

   logic fifo_wr_req;
   assign fifo_wr_req = (in_valid === 1'b1) && (in_ready_dly === 1'b1);
 
   localparam DEPTH = 2 ** LOG_DEPTH -1 ;

   // ---------------------------------------------------------------------
   //| Payload Mapping
   // ---------------------------------------------------------------------
   always @* begin
     in_payload = {in_data};
     {out_data} = out_payload;
   end

   // ---------------------------------------------------------------------
   //| FIFO
   // ---------------------------------------------------------------------                           
    scfifo_s # (
      .LOG_DEPTH (LOG_DEPTH),
      .WIDTH (PAYLOAD_WIDTH),
      .ALMOST_FULL_VALUE (DEPTH-1),
      .SHOW_AHEAD (1),
      .FAMILY ("Agilex")
    ) fifo_inst ( 
       .clock        (clk),
       .aclr       (reset),
       .sclr (1'b0),
       //.in_ready   (),
       .wrreq  (fifo_wr_req),      
       .data    (in_payload),
      //.out_ready  (out_ready),
       .rdreq      (rdreq),
       .q (out_payload),
       .usedw (fifo_fill),
       .empty (empty),
       .full (full),
       .almost_empty (),
       .almost_full ()
       );

   // ---------------------------------------------------------------------
   //| Ready & valid signals.
   // ---------------------------------------------------------------------
   always @* begin
      in_ready = ( DEPTH- fifo_fill > READY_LATENCY_OUT);
   end

    always @(posedge clk) begin
        in_ready_dly_reg[READY_LATENCY_OUT-1] <= in_ready;
        for (int i = 0; i < READY_LATENCY_OUT - 1; i++) begin
            in_ready_dly_reg[i] <= in_ready_dly_reg[i+1];
        end
    end

assign rdreq = out_ready && !empty;

assign out_valid = !empty;


endmodule


`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "RtVKlZGjfRixi4xI11oYmrX+PMax0ulTtjOi5H3vq2H9zwuewt6wOulIreltk437X2PN4+MA07zC7WAQxIKVWtvCyK8cLE2rjfi6HhxTSzoTIo1Qrz0u4txZkK44gbWE8ciHAjGJlVBS72Jo2w+woMvcnXL0SDXJLwiZGCMnECEWfD/klH6X8VTgVJ7kFzee0lqdtgSl5H6EDucawAfGK9fcaYln19FxKZB59GmwSkfowlXcZlRFJERM/FHGz+UIQVQf3Veie+ngf8Aef/c0jLFqTfvlBdG5WelBAJdTGDDg4ZCwqftwrnyQ6kSz4wuD7SfPYccANV5Ai/p3qNxhdKqvEtuFArzfyw9q3WZ31XSQaKQWfA2htSpLD5SOVO07c2LBiJpk6bZtIvwKNlYdpMYaevMg5Q0CLssPkttMs/oNN0snI95m7SasRmsCvqB6XVquS+mc0DpNQv0gNr4wa7Qdn+6lvhfCb6tpyceQNG38gf3QgkqyifX+eKg7L62vHzh3PhV/OXxJXVdOKmK5OsSd/g4IJA7e6y4xwIaPSLWZDLZAUDmAtIAdFSFMU/xralHuhHfjd7Qw9qKmDFbRI+/+JDWW8wY8H94xQdyiIjD4EFyTpIfYrf2bxBpWeb4zKtNRXmQrNGxrEIgNhhmfiC2ZKWD3Plr3qMT6tT0FWt/YywBwkRUCbwF0sgWODkwbFSWx77XfOfDbJPTCJQFJ9RiXFzg7+NsW/YsIsKEqQE3ji1BvcwAOkUZy5OekTeEp6Gh5m/jHSMbeFdGPLe9ig0b/AJ5RzzOizqfTasLDuW5pqCePykJbhC0azbWBJ/LFhFEiDdPWgiA5ZDjOEzbaRU+/E59yauZGnidJlosuc0n5wEBpygtcYB51wRRx4hDL7/28mi6U/OnFE0mUwVKLzKh0nWQCYAOJWkGLOMDETGPzVpLbOfPKwPTx6GkZM2KMTUxZdSBQ7voUqWFmsKiy+lCCGZeVKB1GIGLQV/FlaO/xb70LZKedKvrMz2e67eFL"
`endif