// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module ff_macro_c2p # (
 parameter DATA_WIDTH = 256,
 parameter NUM_FLOPS = 1 // based on number of flops you need in 1 dir 
 ) (
 input logic clk,

 input [DATA_WIDTH -1:0] in_data ,

 output [DATA_WIDTH -1:0] out_data

);


 (* altera_attribute = {"-name FORCE_HYPER_REGISTER_FOR_CORE_PERIPHERY_TRANSFER ON; -name HYPER_REGISTER_DELAY_CHAIN 350"} *)
    reg [DATA_WIDTH-1:0] in_data_reg [NUM_FLOPS:0];    

    assign in_data_reg[0] = in_data;


    genvar i;
    
    generate 
    for (i=0 ; i<NUM_FLOPS ; i=i+1 ) begin : hps_c2p_ff
      always @(posedge clk) begin
          in_data_reg[i+1] <= in_data_reg[i];
      end
    end
    endgenerate

    assign out_data = in_data_reg[NUM_FLOPS];



    
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "RtVKlZGjfRixi4xI11oYmrX+PMax0ulTtjOi5H3vq2H9zwuewt6wOulIreltk437X2PN4+MA07zC7WAQxIKVWtvCyK8cLE2rjfi6HhxTSzoTIo1Qrz0u4txZkK44gbWE8ciHAjGJlVBS72Jo2w+woMvcnXL0SDXJLwiZGCMnECEWfD/klH6X8VTgVJ7kFzee0lqdtgSl5H6EDucawAfGK9fcaYln19FxKZB59GmwSke/0DsKnKxGZyoV15nbEwLfRrsz8PhXwXGkddsJC104Ry/GfUbnSQNcS1+IHInmhr2++nMT3dFtBKrSE7m5dqMmpVdqwyT2YQXfZcCr7uhuYjgWEIgia9TwbIpjzR4YGYKrTE/NLBWKX3/veZSpVbeoTq0y5raebivzKKCaulDcZWC4g0v7R8zBcBGyYF5YUt6YXJ20FlKTq2+cdeKTuFIYAV5VKyTL9EzJC0DkL0a0t6GKMiXz5kh4G7MGV3CTqLv+XnKVmCxMrsYJjfUMRosgEIJ3TuJTjs790L40Uq1VZh/u3O4fDrsNeeH34K34KrbJcHz89S+ye2uzx/rRSx383gUO66qDzTbu8kS7FQ79l6A5kI6uaQ5shzHqRIn2PTjjoAG1g7WsjUpkeA7/GvLHOiirI57F01yUL1B9lmwFujTXhyg4PrCDeGoNkqqYRxv7i5YerErh4C3Y90wnZJVKEqO3ocOuJP7D4W1k4wC877oXTS/R7DhS/qSYv5YeNHpoEOdDq0l86HxAkPhuhzyUjLaQBrBFEI9Vxk1Pcic5HsRGbeLRWOfCuBhGdSzPxyA5O5TI3UW1XteU89J7qL8Mu9/TpUDYr4dRDBCqdpPmXJuTEsXYu62TRkBsZNGULpR0bSweLcFJYFnx4ddsKONmMC0B5DVBj/aNpjLFUKfi/3QkRt8e2I4k001mIaa2VctFG9usXMzrMJJiAQuN49DHK+77bPJzMjfyncvlQux2FYMDoZX5Hc+MnILTamaJvE1myy7YxBHBaPJ23pfTRiR2"
`endif