// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


//
// Module : ready_latency_reset_synchronizer
// Description :
//     2-stage reset synchronizer used for ready latency reset. Takes an
//     asynchronous, active high reset input (rst_async) and synchronizes it
//     to the rising edge of the clock (clk). The output (rst_sync) is active
//     high and safe for use in the clk domain. 
//     This module is intended to be used for Agilex 5 HPS ready latency
//     adapters for the fabric-facing bridges. HPS IP generation should
//     automatically instantiate and connect the HPS reset output (h2f_reset)
//     to the synchronizer input and synchronizer output to each bridge ready
//     latency adapter. This ensures HPS reset and the bridge soft-logic
//     resets are synchronized to the bridge clocks.
//
module ready_latency_reset_synchronizer (
    input logic clk,
    input logic rst_async,    // asynchronous active high input reset
    output logic rst_sync     // synchronized active high output reset 
);

    // 2-stage synchronizer register
    logic [1:0] sync_reg;

    // asynchronous assertion, synchronous deassertion of reset
    always_ff @(posedge clk or posedge rst_async) begin
        if (rst_async) begin
            sync_reg <= 2'b11;    // assert reset synchronously
        end else begin
            sync_reg <= {sync_reg[0], 1'b0}; // Shift in '0' to release reset
        end
    end

    // Output is the last stage of the synchronizer
    assign rst_sync = sync_reg[1];

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "RtVKlZGjfRixi4xI11oYmrX+PMax0ulTtjOi5H3vq2H9zwuewt6wOulIreltk437X2PN4+MA07zC7WAQxIKVWtvCyK8cLE2rjfi6HhxTSzoTIo1Qrz0u4txZkK44gbWE8ciHAjGJlVBS72Jo2w+woMvcnXL0SDXJLwiZGCMnECEWfD/klH6X8VTgVJ7kFzee0lqdtgSl5H6EDucawAfGK9fcaYln19FxKZB59GmwSkdiuMGwpjyqqH5AqfN6Rf8lpA9LjBstxEjnfgRuVyE0txh+GkbhocGpxDATqMK7xoXRifEs2a7k7ioM1j7FdCvohvgLjR8JRaTSKi0oq3qUYWYOpehY0D/84Cl9XaqPO9iGYf1VG7qTrRYzZf6iYwRmnsX+fVu1xKBqcGDTAS+23RdhsPZG095NWmOcKawbV2yXTc3z9JQG2pRqweW0f89oxbyqeG/6melXuUBxVCyEhlH2kfME0q2CUa5kTgkeiHhLH8N9Wj7dIhtge6qXXky6W7RoDH7TdeNkqw1ijBwfrlVdpKVcp6teTBSCS3uoaOyvBgF2XrOfjWEbNY2q8XA3bo7+L4DvxSE6NNTztxVHpmvzawCS8G5kCqoDXNp7lFR/iy8CwJ4229uhXO3mDdLbj8V4i8CFGynnXIPWmW/HhbhzHgf/6GeOhfOPZbTUb6ANCAeUEWCvyFlG3jpXyFoxhGxXJMbhcZBkTnkuJkBQoYUxhJesW8g329RWDIU6FvIjXdQB5GFj3ACjNOuaxVnmlGf0eaucAAFyTTvMMDl4LfpaqC/6s1VgEv9HHp36pG4NWmi66eq48+BNeM6B+jpobuJ50j/uxykR3Thofeiwh2ErxWZFHmJ8pOUKVR9jZFT3fv6BgyludcjqY7zwt6Tq37/fvhdljNlJwqO3pnlYtEjdum0vMkh51mx169InrP41OMTKjBs0h+bl4gdaa/DHnVlMPhlQMmJUn8X1VKT9lcJt/XiCmuYOTUctpu2ruUQhaXmkQ2RrXY1+E3I+uJ7b"
`endif